/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.dao.LoginLogMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.LoginLog;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.user.service.SelectUserDetailService"})
public class SelectUserDetailServiceImpl
implements SelectUserDetailService {
    private static final Logger log = LoggerFactory.getLogger(SelectUserDetailServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private LoginLogMapper loginLogMapper;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"selectUserDetailByUserId"})
    public SelectUserInfoRspBO selectUserDetailByUserId(@RequestBody UserIdBO userIdBO) {
        UserPO userPO = this.userMapper.selectUserInfo(userIdBO.getUserIdWeb());
        SelectUserInfoRspBO selectUserInfoRspBO = new SelectUserInfoRspBO();
        if (userPO != null) {
            LoginLog loginLog;
            OrganisationPO organisation;
            selectUserInfoRspBO = (SelectUserInfoRspBO)BeanMapper.map((Object)userPO, SelectUserInfoRspBO.class);
            TenantRspBO tenant = this.tenantMapper.selectTenantById(userPO.getTenantId());
            if (tenant != null) {
                selectUserInfoRspBO.setTenantName(tenant.getTenantName());
            }
            if ((organisation = this.organizationMapper.selectOrganisationByOrgId(userPO.getOrgId())) != null) {
                selectUserInfoRspBO.setTitle(organisation.getTitle());
                selectUserInfoRspBO.setRegionCode(organisation.getRegionCode());
            }
            if ((loginLog = this.loginLogMapper.selectByLoginName(userPO.getLoginName())) != null) {
                selectUserInfoRspBO.setHost(loginLog.getHost());
                selectUserInfoRspBO.setLoginTime(loginLog.getLoginTime());
            }
        }
        this.cacheClient.delete("cas" + userPO.getLoginName());
        return selectUserInfoRspBO;
    }
}

