/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.dao.RRoleTagMapper;
import com.ohaotian.authority.dao.RoleTagMapper;
import com.ohaotian.authority.po.RRoleTagPO;
import com.ohaotian.authority.po.RoleTagPO;
import com.ohaotian.authority.role.bo.RoleTagBO;
import com.ohaotian.authority.role.bo.SelectRoleTagDistributionReqBO;
import com.ohaotian.authority.role.bo.SelectRoleTagDistributionRspBO;
import com.ohaotian.authority.role.service.SelectRoleTagDistributionBusiService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.role.service.SelectRoleTagDistributionBusiService"})
public class SelectRoleTagDistributionBusiServiceImpl
implements SelectRoleTagDistributionBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectRoleTagDistributionBusiServiceImpl.class);
    @Autowired
    private RoleTagMapper roleTagMapper;
    @Autowired
    private RRoleTagMapper rRoleTagMapper;

    @PostMapping(value={"distribution"})
    public SelectRoleTagDistributionRspBO distribution(@RequestBody SelectRoleTagDistributionReqBO reqBO) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getRoleId())) {
            throw new ZTBusinessException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<RoleTagPO> poList = new ArrayList<RoleTagPO>();
        if (!StringUtils.isEmpty((Object)reqBO.getTenantId())) {
            RoleTagPO roleTagPO = new RoleTagPO();
            roleTagPO.setOrgId(1L);
            poList.addAll(this.roleTagMapper.selectByCondition(roleTagPO));
            roleTagPO.setOrgId(null);
            roleTagPO.setTenantId(reqBO.getTenantId());
            poList.addAll(this.roleTagMapper.selectByCondition(roleTagPO));
        } else {
            poList.addAll(this.roleTagMapper.selectByCondition(new RoleTagPO()));
        }
        RRoleTagPO rRoleTagPO = new RRoleTagPO();
        rRoleTagPO.setRoleId(Long.parseLong(reqBO.getRoleId()));
        List<RRoleTagPO> rRoleTagPOS = this.rRoleTagMapper.selectByCondition(rRoleTagPO);
        ArrayList<RoleTagBO> hasDistributionTags = new ArrayList<RoleTagBO>();
        ArrayList<RoleTagBO> hasNoDistributionTags = new ArrayList<RoleTagBO>();
        if (rRoleTagPOS != null && rRoleTagPOS.size() > 0) {
            Map<Long, List<RRoleTagPO>> rRoleTagmap = rRoleTagPOS.stream().collect(Collectors.groupingBy(RRoleTagPO::getTagId));
            for (RoleTagPO itemPO : poList) {
                if (rRoleTagmap.containsKey(itemPO.getTagId())) {
                    hasDistributionTags.add(this.bulidRoleTagBO(itemPO));
                    continue;
                }
                hasNoDistributionTags.add(this.bulidRoleTagBO(itemPO));
            }
        } else {
            for (RoleTagPO itemPO : poList) {
                hasNoDistributionTags.add(this.bulidRoleTagBO(itemPO));
            }
        }
        SelectRoleTagDistributionRspBO rspBO = new SelectRoleTagDistributionRspBO();
        if ("1".equals(reqBO.getDistributionType()) || "3".equals(reqBO.getDistributionType())) {
            rspBO.setHasDistributionTags(hasDistributionTags);
        }
        if ("2".equals(reqBO.getDistributionType()) || "3".equals(reqBO.getDistributionType())) {
            rspBO.setHasNoDistributionTags(hasNoDistributionTags);
        }
        return rspBO;
    }

    @PostMapping(value={"selectRoleTag"})
    public SelectRoleTagDistributionRspBO selectRoleTag(@RequestBody SelectRoleTagDistributionReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRoleIds())) {
            throw new ZTBusinessException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SelectRoleTagDistributionRspBO rspBO = new SelectRoleTagDistributionRspBO();
        RRoleTagPO rrPO = new RRoleTagPO();
        rrPO.setRoleIds(reqBO.getRoleIds());
        List<RRoleTagPO> rrPOS = this.rRoleTagMapper.selectTagByRole(rrPO);
        if (!CollectionUtils.isEmpty(rrPOS)) {
            ArrayList<RoleTagBO> roleTagBOS = new ArrayList<RoleTagBO>();
            for (RRoleTagPO rroleTagPO : rrPOS) {
                RoleTagBO roleTagBO = new RoleTagBO();
                roleTagBO.setTagCode(rroleTagPO.getTagCode());
                roleTagBO.setTagName(rroleTagPO.getTagName());
                roleTagBO.setTagId(rroleTagPO.getTagId().toString());
                roleTagBOS.add(roleTagBO);
            }
            rspBO.setHasDistributionTags(roleTagBOS);
        }
        return rspBO;
    }

    private RoleTagBO bulidRoleTagBO(RoleTagPO po) {
        RoleTagBO bo = new RoleTagBO();
        bo.setOrgId(po.getOrgId().toString());
        bo.setTagId(po.getTagId().toString());
        bo.setTagName(po.getTagName());
        bo.setTagCode(po.getTagCode());
        bo.setTenantId(po.getTenantId());
        bo.setStatus(po.getStatus());
        bo.setTagType(po.getTagType());
        return bo;
    }
}

