/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.workday;

import com.ohaotian.authority.dao.SpecialDateMapper;
import com.ohaotian.authority.util.WorkDayUtils;
import com.ohaotian.authority.workday.bo.SelectEndWorkdayReqBO;
import com.ohaotian.authority.workday.bo.SelectEndWorkdayRspBO;
import com.ohaotian.authority.workday.bo.SpecialDateBO;
import com.ohaotian.authority.workday.service.SelectEndWorkdayService;
import com.ohaotian.plugin.common.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.workday.service.SelectEndWorkdayService"})
public class SelectEndWorkdayServiceImpl
implements SelectEndWorkdayService {
    private static final Logger log = LoggerFactory.getLogger(SelectEndWorkdayServiceImpl.class);
    @Autowired
    SpecialDateMapper specialDateMapper;

    @PostMapping(value={"selectEndWorkday"})
    public SelectEndWorkdayRspBO selectEndWorkday(@RequestBody SelectEndWorkdayReqBO reqBO) {
        int days = reqBO.getWorkdays();
        Date time = DateUtils.strToDate((String)reqBO.getStartDate());
        Date endDate = DateUtils.getDate((Date)time, (Integer)days);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(5, 1);
        while (days > 0) {
            int size;
            List<SpecialDateBO> holidayBOS = this.specialDateMapper.queryHolidays(calendar.getTime(), endDate, reqBO.getTenantId());
            List<SpecialDateBO> weekdayBOS = this.specialDateMapper.queryWeekdays(calendar.getTime(), endDate, reqBO.getTenantId());
            days = size = holidayBOS.size() + WorkDayUtils.getWeekends(calendar.getTime(), endDate) - weekdayBOS.size();
            calendar.setTime(endDate);
            endDate = DateUtils.getDate((Date)calendar.getTime(), (Integer)size);
            calendar.add(5, 1);
        }
        SelectEndWorkdayRspBO rspBO = new SelectEndWorkdayRspBO();
        rspBO.setEndDate(endDate);
        return rspBO;
    }
}

