/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.atom.impl.organisation;

import com.ohaotian.authority.atom.api.organisation.InsertOrgBatchAtomService;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class InsertOrgBatchAtomServiceImpl
implements InsertOrgBatchAtomService {
    private static final Logger log = LoggerFactory.getLogger(InsertOrgBatchAtomServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(InsertOrgBatchAtomServiceImpl.class);
    @Resource
    private OrganizationMapper organizationMapper;

    @Override
    public List<OrganisationBO> insertOrgBatch(List<OrganisationBO> organisationBOS) throws Exception {
        if (CollectionUtils.isEmpty(organisationBOS)) {
            log.info("\u673a\u6784\u6279\u91cf\u65b0\u589e\u539f\u5b50\u670d\u52a1-\u5165\u53c2\u4e3a\u7a7a-organisationBOS{}," + organisationBOS);
            return new ArrayList<OrganisationBO>();
        }
        for (OrganisationBO organisationBO : organisationBOS) {
            if (organisationBO.getParentId() != null) continue;
            throw new ZTBusinessException("\u673a\u6784\u6279\u91cf\u65b0\u589e\u539f\u5b50\u670d\u52a1-\u5b58\u5728parentId\u4e3a\u7a7a");
        }
        logger.info("[\u5165\u53c2organisationBOS]={}", organisationBOS);
        ArrayList<OrganisationPO> organisationPOS = new ArrayList<OrganisationPO>();
        ArrayList<Long> parentIdS = new ArrayList<Long>();
        for (OrganisationBO organisationBO : organisationBOS) {
            organisationBO.setExtJson(organisationBO.mapToJsaon());
            OrganisationPO organisationPO = new OrganisationPO();
            BeanUtils.copyProperties((Object)organisationBO, (Object)organisationPO);
            organisationPOS.add(organisationPO);
            parentIdS.add(organisationPO.getParentId());
        }
        List<OrganisationPO> repeatPOS = this.organizationMapper.selectOrgBatchByParentIdTitle(organisationPOS);
        if (CollectionUtils.isNotEmpty(repeatPOS)) {
            throw new ZTBusinessException("\u76f8\u540c\u7236\u7ea7\u8282\u70b9\u4e0b\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        Map<Long, OrganisationPO> longOrganisationPOMap = this.organizationMapper.selectOrgBatchByOrgIdS(parentIdS);
        ArrayList<OrganisationPO> parentPOS = null;
        if (longOrganisationPOMap != null) {
            parentPOS = new ArrayList<OrganisationPO>(longOrganisationPOMap.values());
        }
        if (CollectionUtils.isNotEmpty(parentPOS)) {
            for (OrganisationPO parentPO : parentPOS) {
                for (OrganisationPO organisationPO : organisationPOS) {
                    if (!organisationPO.getParentId().equals(parentPO.getOrgId())) continue;
                    organisationPO.setDeep(parentPO.getDeep() + 1);
                    organisationPO.setStatus(0);
                }
            }
        }
        this.organizationMapper.insertOrganisationBatch(organisationPOS);
        for (OrganisationPO parentPO : parentPOS) {
            for (OrganisationPO organisationPO : organisationPOS) {
                if (!organisationPO.getParentId().equals(parentPO.getOrgId())) continue;
                Long orgId = organisationPO.getOrgId();
                String parentPath = parentPO.getOrgTreePath();
                organisationPO.setOrgTreePath(parentPath + orgId + "-");
            }
        }
        this.organizationMapper.updateOrganisationBatch(organisationPOS);
        organisationBOS = new ArrayList<OrganisationBO>();
        for (OrganisationPO organisationPO : organisationPOS) {
            OrganisationBO organisationBO = new OrganisationBO();
            BeanUtils.copyProperties((Object)organisationPO, (Object)organisationBO);
            organisationBOS.add(organisationBO);
        }
        logger.info("insertOrgBatch() \u6279\u91cf\u65b0\u589e\u5b8c\u6210");
        return organisationBOS;
    }
}

