/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.atom.impl.user;

import com.ohaotian.authority.atom.api.user.SelectUserByRoleAtomService;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.RoleAuthPO;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.role.bo.RoleInfoBO;
import com.ohaotian.authority.role.bo.SearchRolesRspBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.user.bo.SelectRoleByRoleReqBO;
import com.ohaotian.authority.user.bo.SelectRoleByRoleRspBO;
import com.ohaotian.authority.user.bo.SelectUserByRoleReqBO;
import com.ohaotian.authority.user.bo.SelectUserByRoleRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SelectUserByRoleAtomServiceImpl
implements SelectUserByRoleAtomService {
    private static final Logger log = LoggerFactory.getLogger(SelectUserByRoleAtomServiceImpl.class);
    @Resource
    private UserMapper userMapper;
    @Resource
    private RoleMapper roleMapper;

    @Override
    public SelectUserByRoleRspBO selectUserByRoleIdentity(SelectUserByRoleReqBO selectUserByRoleReqBO) {
        RoleAuthPO roleAuthPO = new RoleAuthPO();
        roleAuthPO.setLists(selectUserByRoleReqBO.getLists());
        roleAuthPO.setTenantId(selectUserByRoleReqBO.getTenantId());
        List<UserPO> userPOS = this.userMapper.selectUserByRoleIdentity(roleAuthPO);
        SelectUserByRoleRspBO rspBO = new SelectUserByRoleRspBO();
        if (CollectionUtils.isNotEmpty(userPOS)) {
            ArrayList<UserBO> userBOS = new ArrayList<UserBO>();
            for (UserPO userPO : userPOS) {
                if (userPO == null) continue;
                UserBO userBO = new UserBO();
                userBO.setUserId(userPO.getUserId());
                userBO.setUserIdStr(userPO.getUserId().toString());
                userBO.setLoginName(userPO.getLoginName());
                userBO.setName(userPO.getName());
                userBO.setEmpId(userPO.getEmpId());
                userBO.setTenantId(userPO.getTenantId());
                userBO.setOrgId(userPO.getOrgId());
                userBO.setCellPhone(userPO.getCellPhone());
                userBO.setEmail(userPO.getEmail());
                userBOS.add(userBO);
            }
            rspBO.setRows(userBOS);
        }
        return rspBO;
    }

    @Override
    public SelectRoleByRoleRspBO selectRoleByRoleIdentity(SelectRoleByRoleReqBO selectRoleByRoleReqBO) {
        List<SearchRolesRspBO> roles = this.roleMapper.selectRoleInfoByAuthIdentityList(selectRoleByRoleReqBO.getLists());
        SelectRoleByRoleRspBO rspBO = new SelectRoleByRoleRspBO();
        List<Object> BOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(roles)) {
            BOList = roles.stream().map(role -> {
                RoleInfoBO roleBO = new RoleInfoBO();
                roleBO.setRoleName(role.getRoleName());
                roleBO.setAuthIdentity(role.getAuthIdentity());
                return roleBO;
            }).collect(Collectors.toList());
        }
        rspBO.setRows(BOList);
        return rspBO;
    }
}

