/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.dao.OrgMenuMapper;
import com.ohaotian.authority.dao.OrgRoleMenuMapper;
import com.ohaotian.authority.menu.bo.MenuTreeRspBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeByOrgReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeByOrgRspBO;
import com.ohaotian.authority.menu.service.SelectMenuTreeByUserBusiService;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.service.SelectOrgByMuserIdService;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.menu.service.SelectMenuTreeByUserBusiService"})
public class SelectMenuTreeByUserBusiServiceImpl
implements SelectMenuTreeByUserBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectMenuTreeByUserBusiServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private OrgMenuMapper orgMenuMapper;
    @Autowired
    private SelectOrgByMuserIdService selectOrgByMuserIdService;
    @Autowired
    private OrgRoleMenuMapper orgRoleMenuMapper;

    @PostMapping(value={"select"})
    public SelectMenuTreeByOrgRspBO select(@RequestBody SelectMenuTreeByOrgReqBO reqBO) {
        SelectMenuTreeByOrgRspBO selectMenuTreeRspBO = new SelectMenuTreeByOrgRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getRoleIdentity())) {
            throw new ZTBusinessException("\u6743\u9650\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> menus = new ArrayList();
        ArrayList<Object> menus2 = new ArrayList<Object>();
        if (reqBO.getRoleIdentity().equals("auth:tenant:manage")) {
            menus = this.menuMapper.selectMgrMenus(reqBO.getRoleIdentity(), reqBO.getApplicationCode());
            menus2.addAll(menus);
        } else {
            SelectOrgByMuserIdReqBO selectOrgByMuserIdReqBO = new SelectOrgByMuserIdReqBO();
            selectOrgByMuserIdReqBO.setmUserId(reqBO.getMgrUserId());
            SelectOrgByMuserIdRspBO select1 = this.selectOrgByMuserIdService.selectOrgByMuserId(selectOrgByMuserIdReqBO);
            if (select1 == null || select1.getTreePathRspBOS() == null || select1.getTreePathRspBOS().size() == 0) {
                throw new ZTBusinessException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u7406\u7684\u7ec4\u7ec7\u673a\u6784");
            }
            List treePathRspBOS = select1.getTreePathRspBOS();
            Iterator iterator = treePathRspBOS.iterator();
            while (iterator.hasNext()) {
                TreePathRspBO BO = (TreePathRspBO)iterator.next();
                List<Menu> menus1 = this.orgMenuMapper.selectMenuInfoByOrgTreePath(BO.getOrgTreePath(), reqBO.getApplicationCode());
                menus.addAll(menus1);
            }
            menus.stream().forEach(p -> {
                if (!menus2.contains(p)) {
                    menus2.add(p);
                }
            });
        }
        List<Long> longs = this.orgRoleMenuMapper.selectMenuIdsByOrgTreePath(reqBO.getOrgTreePath());
        if (menus2 != null && menus2.size() > 0) {
            LinkedList<MenuTreeRspBO> menuTree = new LinkedList<MenuTreeRspBO>();
            for (Menu menu : menus2) {
                MenuTreeRspBO map = (MenuTreeRspBO)BeanMapper.map((Object)menu, MenuTreeRspBO.class);
                if (longs.contains(menu.getMenuId())) {
                    map.setHasSel(Boolean.valueOf(true));
                    map.setFlag(Boolean.valueOf(true));
                }
                menuTree.add(map);
            }
            List<MenuTreeRspBO> menuTreeRspBOS = this.buildByRecursive(menuTree);
            ArrayList arrayList = new ArrayList();
            menuTreeRspBOS.stream().forEach(p -> {
                if (!menuTreeRspBOS2.contains(p)) {
                    menuTreeRspBOS2.add(p);
                }
            });
            selectMenuTreeRspBO.setMenuTreeRspBOS(arrayList);
        }
        return selectMenuTreeRspBO;
    }

    private List<MenuTreeRspBO> buildByRecursive(List<MenuTreeRspBO> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuTreeRspBO> trees = new ArrayList<MenuTreeRspBO>();
        for (MenuTreeRspBO treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuTreeRspBO findChildren(MenuTreeRspBO root, List<MenuTreeRspBO> allMenus) {
        for (MenuTreeRspBO it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            if (root.getAuthButtons() == null) {
                root.setAuthButtons(new ArrayList());
            }
            if (Constants.MENU_TYPE_F.equals(it.getType())) {
                root.getAuthButtons().add(it);
                continue;
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

