/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.authority.atom.api.organisation.InsertOrgBatchAtomService;
import com.ohaotian.authority.atom.api.organisation.SelectOrgBatchAtomService;
import com.ohaotian.authority.atom.api.user.SelectUserBatchAtomService;
import com.ohaotian.authority.organisation.bo.MerchantReqBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.MerchantAddService;
import com.ohaotian.authority.user.bo.AddUserListReqBO;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.util.HttpConnUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.organisation.service.MerchantAddService"})
public class MerchantAddServiceImpl
implements MerchantAddService {
    private static final Logger log = LoggerFactory.getLogger(MerchantAddServiceImpl.class);
    @Autowired
    private SelectUserBatchAtomService selectUserBatchAtomService;
    @Autowired
    private SelectOrgBatchAtomService selectOrgBatchAtomService;
    @Autowired
    private InsertOrgBatchAtomService insertOrgBatchAtomService;
    @Autowired
    private AddManageUserService addManageUserService;
    @Value(value="${ADDRESS_COORDINATE_URL:}")
    private String ADDRESS_COORDINATE_URL;
    @Value(value="${MERCHANT_SINGLE_ADD_URL:}")
    private String MERCHANT_SINGLE_ADD_URL;
    @Value(value="${MERCHANT_ADD_IS_REPATE_CHECK_URL}")
    private String MERCHANT_ADD_IS_REPATE_CHECK_URL;
    @Value(value="${MERCHANT_ROLE_CODE:auth:default:manage}")
    private String MERCHANT_ROLE_CODE;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"addMerchant"})
    public RspBaseBO addMerchant(@RequestBody MerchantReqBO reqBO) throws Exception {
        if (null == reqBO.getmOrgPath() || null == reqBO.getmTenantId()) {
            log.error("\u5546\u6237\u65b0\u589e\u7528\u6237\u4fe1\u606f\u6811\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
            throw new ZTBusinessException("\u5546\u6237\u65b0\u589e\u7528\u6237\u4fe1\u606f\u6811\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
        }
        RspBaseBO rspBaseBO = new RspBaseBO();
        reqBO.setTenantId(reqBO.getmTenantId());
        reqBO.setOrgTreePath(reqBO.getmOrgPath());
        log.info("\u5546\u6237\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportFileReqBO{}", (Object)JSON.toJSONString((Object)reqBO));
        log.info("\u5f00\u59cb\u9a8c\u8bc1\u5546\u6237\u65b0\u589e\u4fe1\u606f,startTime={}", (Object)System.currentTimeMillis());
        if (StringUtils.isBlank((CharSequence)reqBO.getTitle())) {
            log.error("\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            throw new ZTBusinessException("\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a|");
        }
        if (null == reqBO.getParentId()) {
            log.error("\u4e0a\u7ea7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a!");
            throw new ZTBusinessException("\u4e0a\u7ea7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a|");
        }
        this.dbCheck(reqBO, reqBO.getOrgTreePath(), reqBO.getToken());
        ArrayList<OrganisationBO> addOrgReqBOS = new ArrayList<OrganisationBO>();
        HashMap<String, AddUserReqBO> addUserMap = new HashMap<String, AddUserReqBO>();
        ArrayList orgBatchImportBOS = new ArrayList();
        OrganisationBO bo = new OrganisationBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)bo);
        bo.setTenantId(reqBO.getmTenantId());
        bo.setCreatTime(new Date());
        bo.setType("org_type_5");
        bo.setRemark(reqBO.getContactName());
        bo.setTel(reqBO.getContactPhone());
        bo.setTypeCode(reqBO.getType());
        addOrgReqBOS.add(bo);
        if (reqBO.getIsCreateUser().equals("01")) {
            if (StringUtils.isBlank((CharSequence)reqBO.getLoginNameReq()) || StringUtils.isBlank((CharSequence)reqBO.getContactPhone()) || StringUtils.isBlank((CharSequence)reqBO.getContactEmail())) {
                log.error("\u9700\u8981\u521b\u5efa\u767b\u5f55\u8d26\u53f7\u65f6|\u767b\u5f55\u540d|\u624b\u673a\u53f7|\u90ae\u7bb1|\u4e0d\u80fd\u4e3a\u7a7a!");
                throw new ZTBusinessException("\u9700\u8981\u521b\u5efa\u767b\u5f55\u8d26\u53f7\u65f6|\u767b\u5f55\u540d|\u624b\u673a\u53f7|\u90ae\u7bb1|\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            bo.setTempStr(reqBO.getLoginNameReq());
            AddUserReqBO addUserReqBO = new AddUserReqBO();
            addUserReqBO.setLoginNameReq(reqBO.getLoginNameReq());
            addUserReqBO.setCellPhoneReq(reqBO.getContactPhone());
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addUserReqBO.setAuthUserId(Long.valueOf(l));
            addUserReqBO.setNameReq(reqBO.getTitle());
            addUserReqBO.setEmailReq(reqBO.getContactEmail());
            addUserReqBO.setType(this.MERCHANT_ROLE_CODE);
            addUserReqBO.setUserId(reqBO.getmUserId());
            addUserReqBO.setTenantIdReq(reqBO.getmTenantId());
            addUserMap.put(addUserReqBO.getLoginNameReq(), addUserReqBO);
        }
        List<OrganisationBO> organisationBOS = this.insertOrgBatchAtomService.insertOrgBatch(addOrgReqBOS);
        for (OrganisationBO organisationBO : organisationBOS) {
            String loginName = organisationBO.getTempStr();
            AddUserReqBO addUserReqBO = (AddUserReqBO)addUserMap.get(loginName);
            if (addUserReqBO != null) {
                addUserReqBO.setOrgIdReq(organisationBO.getOrgId());
            }
            JSONObject data = JSONObject.parseObject((String)organisationBO.getExtJson());
            reqBO.setTenantId(organisationBO.getTenantId());
            reqBO.setMerchantId(organisationBO.getOrgId());
            reqBO.setOrgTreePath(organisationBO.getOrgTreePath());
            reqBO.setType(data.get((Object)"typeCode").toString());
        }
        ArrayList addUserReqBOS = new ArrayList(addUserMap.values());
        if (CollectionUtils.isNotEmpty(addUserReqBOS)) {
            AddUserListReqBO addUserListReqBO = new AddUserListReqBO();
            addUserListReqBO.setAddUserReqBOS(addUserReqBOS);
            this.addManageUserService.insertBatchUser(addUserListReqBO);
        }
        if (null != reqBO) {
            log.info("http\u8fde\u63a5\u5546\u6237\u5355\u6761\u65b0\u589e\u5f00\u59cb\uff0creqBO{}", (Object)JSON.toJSONString((Object)reqBO));
            System.out.println(JSON.toJSONString((Object)reqBO));
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("auth-token", reqBO.getToken());
            log.info("\u5546\u6237\u5355\u6761\u65b0\u589e\u8bbf\u95ee\u5730\u5740:" + this.MERCHANT_SINGLE_ADD_URL + reqBO.getToken());
            String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)reqBO), headerMap, this.MERCHANT_SINGLE_ADD_URL, null, null, "application/json");
            JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
            log.info("http\u8c03\u7528\u5546\u6237\u5b8c\u6bd5,\u5546\u6237\u6279\u5bfc\u65b0\u589e\u7ed3\u679c\u4e3a:{}", (Object)data);
            String respCode = data.get((Object)"respCode").toString();
            if (!respCode.equals("0000")) {
                String respDesc = data.get((Object)"respDesc").toString();
                log.error("\u5546\u6237\u65b0\u589e\u51fa\u9519\uff1a" + respDesc);
                throw new ZTBusinessException("\u673a\u6784\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u5546\u6237\u5355\u6761\u65b0\u589e\u5931\u8d25");
            }
        }
        log.info("\u7ed3\u675f\u9a8c\u8bc1\u5546\u6237\u65b0\u589e\u4fe1\u606f,endTime={}", (Object)System.currentTimeMillis());
        return rspBaseBO;
    }

    private void dbCheck(MerchantReqBO reqBO, String orgTreePath, String token) {
        ArrayList<String> loginNameS = new ArrayList<String>();
        ArrayList<String> cellPhoneS = new ArrayList<String>();
        ArrayList<Long> orgIdS = new ArrayList<Long>();
        loginNameS.add(reqBO.getLoginNameReq());
        cellPhoneS.add(reqBO.getContactPhone());
        if (reqBO.getParentId() == null) {
            log.error("\u4e0a\u7ea7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a!");
            throw new ZTBusinessException("\u4e0a\u7ea7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a|");
        }
        orgIdS.add(reqBO.getParentId());
        List<String> loginNameSOut = this.selectUserBatchAtomService.selectUserLoginNameBatchByLoginName(loginNameS);
        List<String> cellPhoneSOut = this.selectUserBatchAtomService.selectUserCellPhoneBatchByCellPhone(cellPhoneS);
        Map<Long, OrganisationBO> orgMap = this.selectOrgBatchAtomService.selectOrgBatchByOrgIdS(orgIdS);
        if (this.queryMerchantIsRepeat(reqBO.getTitle().trim(), token)) {
            log.error("\u5546\u6237\u540d\u79f0\u5df2\u5b58\u5728!");
            throw new ZTBusinessException("\u5546\u6237\u540d\u79f0\u5df2\u5b58\u5728|");
        }
        JSONObject dataObj = this.queryCoordinate(reqBO.getAddress(), token);
        if (null != dataObj) {
            reqBO.setLatitude(dataObj.getString("latitude"));
            reqBO.setLongitude(dataObj.getString("longitude"));
        }
        if (loginNameSOut.contains(reqBO.getLoginNameReq())) {
            log.error("\u7528\u6237\u540d\u5df2\u5b58\u5728!");
            throw new ZTBusinessException("\u7528\u6237\u540d\u5df2\u5b58\u5728|");
        }
        if (cellPhoneSOut.contains(reqBO.getContactPhone())) {
            log.error("\u624b\u673a\u53f7\u5df2\u5b58\u5728!");
            throw new ZTBusinessException("\u624b\u673a\u53f7\u5df2\u5b58\u5728|");
        }
        OrganisationBO organisationBO = orgMap.get(reqBO.getParentId());
        if (organisationBO != null) {
            if (!organisationBO.getOrgTreePath().contains(orgTreePath)) {
                log.error("\u5f53\u524d\u7528\u6237\u6743\u9650\u4e0d\u652f\u6301\u521b\u5efa\u8be5\u673a\u6784!");
                throw new ZTBusinessException("\u5f53\u524d\u7528\u6237\u6743\u9650\u4e0d\u652f\u6301\u521b\u5efa\u8be5\u673a\u6784|");
            }
            if ("org_type_5".equals(organisationBO.getType())) {
                log.error("\u4e0a\u7ea7\u673a\u6784\u4e3a\u5546\u6237,\u4e0d\u80fd\u7ee7\u7eed\u521b\u5efa\u5546\u6237!");
                throw new ZTBusinessException("\u4e0a\u7ea7\u673a\u6784\u4e3a\u5546\u6237,\u4e0d\u80fd\u7ee7\u7eed\u521b\u5efa\u5546\u6237|");
            }
            if (!"org_type_3".equals(organisationBO.getType()) && !"org_type_4".equals(organisationBO.getType())) {
                log.error("\u4e0a\u7ea7\u673a\u6784\u4e0d\u80fd\u521b\u5efa\u5546\u6237,\u8bf7\u91cd\u65b0\u6307\u5b9a!");
                throw new ZTBusinessException("\u4e0a\u7ea7\u673a\u6784\u4e0d\u80fd\u521b\u5efa\u5546\u6237,\u8bf7\u91cd\u65b0\u6307\u5b9a|");
            }
        } else {
            log.error("\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728!");
            throw new ZTBusinessException("\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728|");
        }
    }

    private JSONObject queryCoordinate(String address, String token) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("requestInput", address);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        log.info("\u67e5\u8be2\u7ecf\u7eac\u5ea6\u8bbf\u95ee\u63a5\u53e3\u5730\u5740:" + this.ADDRESS_COORDINATE_URL + token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString(paramMap), headerMap, this.ADDRESS_COORDINATE_URL, null, null, "application/json");
        JSONObject rspJson = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        if (null == rspJson || !"0000".equals(rspJson.get((Object)"respCode"))) {
            return null;
        }
        return rspJson.getJSONObject("data");
    }

    private boolean queryMerchantIsRepeat(String title, String token) {
        log.info("\u5546\u6237\u5355\u6761\u65b0\u589e,\u67e5\u8be2\u5546\u6237\u540d\u79f0\u662f\u5426\u5b58\u5728");
        HashMap map = new HashMap();
        OrgBatchImportBO merchantBO = new OrgBatchImportBO();
        merchantBO.setTitle(title);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)merchantBO), headerMap, this.MERCHANT_ADD_IS_REPATE_CHECK_URL, null, null, "application/json");
        JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        log.info("httpt\u8c03\u7528\u67e5\u8be2\u5546\u6237\u662f\u5426\u5b58\u5728\u5b8c\u6bd5,\u6839\u636e\u5546\u6237\u540d\u79f0\u67e5\u8be2\u7ed3\u679c\u4e3adata{}", (Object)data);
        if (!data.get((Object)"respCode").equals("0000")) {
            log.error("\u5546\u6237\u5355\u6761\u65b0\u589e,\u67e5\u8be2\u5546\u6237\u540d\u79f0\u662f\u5426\u5b58\u5728\u5931\u8d25:" + data.get((Object)"respDesc").toString());
            throw new ZTBusinessException("\u5546\u6237\u6279\u91cf\u65b0\u589e,\u67e5\u8be2\u5546\u6237\u540d\u79f0\u662f\u5426\u5b58\u5728\u5931\u8d25");
        }
        JSONObject result = JSON.parseObject((String)data.get((Object)"data").toString());
        return result.toJSONString().length() > 2 && StringUtils.isNotEmpty((CharSequence)result.getString("title"));
    }
}

