/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.authority.atom.api.organisation.InsertOrgBatchAtomService;
import com.ohaotian.authority.atom.api.organisation.SelectOrgBatchAtomService;
import com.ohaotian.authority.atom.api.user.SelectUserBatchAtomService;
import com.ohaotian.authority.organisation.bo.OrgBatchExcelURLRspBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportFileReqBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportParseRspBO;
import com.ohaotian.authority.organisation.bo.OrgBatchImportReqBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.OrgBatchImportService;
import com.ohaotian.authority.user.bo.AddUserListReqBO;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.util.ExcelParseUtils;
import com.ohaotian.authority.util.HttpConnUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.newretail.toolkit.bo.RspBaseBO;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.organisation.service.OrgBatchImportService"})
public class OrgBatchImportServiceImpl
implements OrgBatchImportService {
    private static final Logger log = LoggerFactory.getLogger(OrgBatchImportServiceImpl.class);
    private static final String janPattern = "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])";
    private static final String febPattern = "0?2-(0?[1-9]|[12][0-9])";
    private static final String aprPattern = "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)";
    private static final String dayPattern = String.format("^2[0-9]{3}-(%s|%s|%s)$", "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])", "0?2-(0?[1-9]|[12][0-9])", "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)");
    private static final String hhssPattern = String.format("([01][0-9]|2[0-3])(:[0-5][0-9])$", "0?2-(0?[1-9]|[12][0-9])", "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])", "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)");
    private static final String CREATE_USER_IDENTITY = "\u662f";
    @Resource
    FileClient fileClient;
    @Value(value="${MERCHANT_ESCAPECODE_BYPARENTCODE_URL:}")
    private String MERCHANT_ESCAPECODE_BYPARENTCODE_URL;
    @Value(value="${LEASE_CHECK_URL:}")
    private String LEASE_CHECK_URL;
    @Value(value="${ADDRESS_COORDINATE_URL:}")
    private String ADDRESS_COORDINATE_URL;
    @Value(value="${MERCHANT_ADD_IS_REPATE_CHECK_URL}")
    private String MERCHANT_ADD_IS_REPATE_CHECK_URL;
    @Value(value="${MERCHANT_BATCHIMOPRT_ADD_URL:}")
    private String MERCHANT_BATCHIMOPRT_ADD_URL;
    @Value(value="${ORGBATCH_EXECEL_URL:}")
    private String ORGBATCH_EXECEL_URL;
    @Value(value="${oss.accessUrl:}")
    private String OSS_ACCESSURL;
    @Autowired
    private SelectUserBatchAtomService selectUserBatchAtomService;
    @Autowired
    private SelectOrgBatchAtomService selectOrgBatchAtomService;
    @Autowired
    private InsertOrgBatchAtomService insertOrgBatchAtomService;
    @Value(value="${MERCHANT_ROLE_CODE:auth:default:manage}")
    private String MERCHANT_ROLE_CODE;
    @Autowired
    private AddManageUserService addManageUserService;

    @PostMapping(value={"parseOrgExcel"})
    public OrgBatchImportParseRspBO parseOrgExcel(@RequestBody OrgBatchImportFileReqBO orgBatchImportFileReqBO) {
        if (null == orgBatchImportFileReqBO || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgBatchImportFileReqBO.getFilePath())) {
            log.error("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a,orgBatchImportFileReqBO");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (null == orgBatchImportFileReqBO.getmOrgPath() || null == orgBatchImportFileReqBO.getmTenantId()) {
            log.error("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1\u7528\u6237\u4fe1\u606f\u6811\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        orgBatchImportFileReqBO.setTenantId(orgBatchImportFileReqBO.getmTenantId());
        orgBatchImportFileReqBO.setOrgTreePath(orgBatchImportFileReqBO.getmOrgPath());
        log.info("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportFileReqBO{}", (Object)JSON.toJSONString((Object)orgBatchImportFileReqBO));
        log.info("\u5f00\u59cb\u89e3\u6790\u673a\u6784\u6279\u5230\u4fe1\u606f,startTime={}", (Object)System.currentTimeMillis());
        File file = null;
        try {
            String filePath = orgBatchImportFileReqBO.getFilePath();
            if (filePath.contains("laowaitan")) {
                orgBatchImportFileReqBO.setFilePath(filePath.substring(filePath.substring(1).indexOf("/") + 2));
            }
            file = this.fileClient.downloadToFile(orgBatchImportFileReqBO.getFilePath());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,\u6279\u5bfc\u6587\u4ef6\u8def\u5f84path=" + orgBatchImportFileReqBO.getFilePath());
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,\u6279\u5bfc\u6587\u4ef6\u8def\u5f84");
        }
        String suffix = null;
        try {
            suffix = OrgBatchImportServiceImpl.getSuffix(file.getPath());
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,TkExcelUtils{}");
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25,\u6279\u5bfc\u6587\u4ef6\u8def\u5f84");
        }
        OrgBatchImportParseRspBO rspBO = this.readXlsx2(file.getPath(), suffix, orgBatchImportFileReqBO);
        log.info("\u5f00\u59cb\u89e3\u6790\u673a\u6784\u6279\u5230\u4fe1\u606f,endTime={}", (Object)System.currentTimeMillis());
        return rspBO;
    }

    public static String getSuffix(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1, path.length()) : null;
    }

    private OrgBatchImportParseRspBO readXlsx2(String path, String suffix, OrgBatchImportFileReqBO orgBatchImportFileReqBO) {
        log.info("\u673a\u6784\u6279\u5bfc\uff0cexcel\u9a8c\u8bc1\u5f00\u59cb");
        OrgBatchImportParseRspBO orgRspBO = new OrgBatchImportParseRspBO();
        String orgTreePath = orgBatchImportFileReqBO.getmOrgPath();
        ArrayList<HSSFRow> rows = null;
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelParseUtils.readXls(path, 0, 1, 2);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelParseUtils.readXlsx(path, 0, 1, 2);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            log.error("\u673a\u6784\u6279\u5bfc\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            log.error("\u673a\u6784\u6279\u5bfcExcel\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfcExcel\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        if (rows.size() > 100) {
            log.error("\u673a\u6784\u6279\u5bfc\u8d85\u8fc7100\u6761\u5546\u54c1\u4fe1\u606f\u8bf7\u5206\u6279\u4e0a\u4f20");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u8d85\u8fc7100\u6761\u5546\u54c1\u4fe1\u606f\u8bf7\u5206\u6279\u4e0a\u4f20");
        }
        ArrayList<OrgBatchImportBO> successTempBOs = new ArrayList<OrgBatchImportBO>();
        ArrayList<OrgBatchImportBO> failBOs = new ArrayList<OrgBatchImportBO>();
        HashSet<String> loginNameSet = new HashSet<String>();
        HashSet cellPhoneSet = new HashSet();
        HashSet<String> merchantNameSet = new HashSet<String>();
        Pattern phoneP = Pattern.compile("1\\d{10}");
        for (Row row : rows) {
            String contactWechat;
            StringBuilder failDesc = new StringBuilder();
            OrgBatchImportBO orgImportBO = new OrgBatchImportBO();
            String title = ExcelParseUtils.changeCellToString(row.getCell(0), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)title)) {
                failDesc.append("\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a|");
            } else {
                if (merchantNameSet.contains(title)) {
                    failDesc.append("\u5bfc\u5165\u6a21\u677f\u4e2d\u5546\u6237\u540d\u79f0\u91cd\u590d|");
                } else {
                    merchantNameSet.add(title);
                }
                orgImportBO.setTitle(title);
            }
            String parentName = ExcelParseUtils.changeCellToString(row.getCell(1), false);
            orgImportBO.setParentName(parentName);
            try {
                Long parentId = Long.parseLong(ExcelParseUtils.changeCellToString(row.getCell(2), false));
                orgImportBO.setParentId(parentId);
            }
            catch (Exception e) {
                failDesc.append("\u4e0a\u7ea7\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u662f\u6570\u5b57|");
            }
            String levelName = ExcelParseUtils.changeCellToString(row.getCell(3), false);
            orgImportBO.setLevelName(levelName);
            String merchantCharacterName = ExcelParseUtils.changeCellToString(row.getCell(4), false);
            orgImportBO.setMerchantCharacterName(merchantCharacterName);
            String typeName = ExcelParseUtils.changeCellToString(row.getCell(5), false);
            orgImportBO.setTypeName(typeName);
            String attributionAreaTypeName = ExcelParseUtils.changeCellToString(row.getCell(6), false);
            orgImportBO.setAttributionAreaTypeName(attributionAreaTypeName);
            String merchantBrand = ExcelParseUtils.changeCellToString(row.getCell(7), false);
            orgImportBO.setMerchantBrand(merchantBrand);
            String merchantIntroduction = ExcelParseUtils.changeCellToString(row.getCell(8), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)merchantIntroduction)) {
                failDesc.append("\u5546\u6237\u7b80\u4ecb\u4e0d\u80fd\u4e3a\u7a7a|");
            } else {
                orgImportBO.setMerchantIntroduction(merchantIntroduction);
            }
            String busiTime = ExcelParseUtils.changeCellToString(row.getCell(9), false);
            if (!OrgBatchImportServiceImpl.checkBusiTime(busiTime)) {
                log.info("\u8425\u4e1a\u65f6\u95f4\u683c\u5f0f\u9a8c\u8bc1\u5f00\u59cb");
                failDesc.append("\u8425\u4e1a\u65f6\u95f4\u683c\u5f0f\u9519\u8bef|");
            } else {
                orgImportBO.setBusiTime(busiTime);
            }
            String merchantPhone = ExcelParseUtils.changeCellToString(row.getCell(10), false);
            if (!OrgBatchImportServiceImpl.checkCellPhone(merchantPhone)) {
                failDesc.append("\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e|");
            } else {
                orgImportBO.setMerchantPhone(merchantPhone);
            }
            String address = ExcelParseUtils.changeCellToString(row.getCell(11), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)address)) {
                failDesc.append("\u7269\u4e1a\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a|");
            } else {
                orgImportBO.setAddress(address);
            }
            try {
                Double area = Double.parseDouble(ExcelParseUtils.changeCellToString(row.getCell(12), false));
                orgImportBO.setArea(area);
            }
            catch (Exception e) {
                failDesc.append("\u7ecf\u8425\u9762\u79ef\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e|");
            }
            String marketModeName = ExcelParseUtils.changeCellToString(row.getCell(13), false);
            orgImportBO.setMarketModeName(marketModeName);
            String isWater = ExcelParseUtils.changeCellToString(row.getCell(14), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isWater)) {
                failDesc.append("\u662f\u5426\u4f9b\u6c34\u4e0d\u80fd\u4e3a\u7a7a|");
            } else if (CREATE_USER_IDENTITY.equals(isWater)) {
                orgImportBO.setIsWater("01");
            } else {
                orgImportBO.setIsWater("00");
            }
            String isElectric = ExcelParseUtils.changeCellToString(row.getCell(15), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isElectric)) {
                failDesc.append("\u662f\u5426\u4f9b\u7535\u4e0d\u80fd\u4e3a\u7a7a|");
            } else if (CREATE_USER_IDENTITY.equals(isElectric)) {
                orgImportBO.setIsElectric("01");
            } else {
                orgImportBO.setIsElectric("00");
            }
            String isHeating = ExcelParseUtils.changeCellToString(row.getCell(16), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isHeating)) {
                failDesc.append("\u662f\u5426\u4f9b\u6696\u4e0d\u80fd\u4e3a\u7a7a|");
            } else if (CREATE_USER_IDENTITY.equals(isElectric)) {
                orgImportBO.setIsHeating("01");
            } else {
                orgImportBO.setIsHeating("00");
            }
            String bankAccountMaster = ExcelParseUtils.changeCellToString(row.getCell(17), false);
            orgImportBO.setBankAccountMaster(bankAccountMaster);
            String bankAccount = ExcelParseUtils.changeCellToString(row.getCell(18), false);
            orgImportBO.setBankAccount(bankAccount);
            String bankName = ExcelParseUtils.changeCellToString(row.getCell(19), false);
            orgImportBO.setBankName(bankName);
            String contactName = ExcelParseUtils.changeCellToString(row.getCell(20), false);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contactName)) {
                failDesc.append("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a|");
            } else {
                orgImportBO.setContactName(contactName);
            }
            String contactPhone = ExcelParseUtils.changeCellToString(row.getCell(21), false);
            if (!OrgBatchImportServiceImpl.checkCellPhone(contactPhone)) {
                failDesc.append("\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e|");
            } else {
                orgImportBO.setContactPhone(contactPhone);
            }
            String contactJob = ExcelParseUtils.changeCellToString(row.getCell(22), false);
            orgImportBO.setContactJob(contactJob);
            String contactSex = ExcelParseUtils.changeCellToString(row.getCell(23), false);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contactSex)) {
                if ("\u5973".equals(contactSex)) {
                    orgImportBO.setContactSex("00");
                } else {
                    orgImportBO.setContactSex("01");
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)(contactWechat = ExcelParseUtils.changeCellToString(row.getCell(24), false)))) {
                failDesc.append("\u5fae\u4fe1\u4e0d\u80fd\u4e3a\u7a7a|");
            } else {
                orgImportBO.setContactWechat(contactWechat);
            }
            String contactEmail = ExcelParseUtils.changeCellToString(row.getCell(25), false);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contactEmail)) {
                if (this.checkEmail(contactEmail)) {
                    orgImportBO.setContactEmail(contactEmail);
                } else {
                    failDesc.append("\u8054\u7cfb\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef|");
                }
            }
            String isCreateUser = ExcelParseUtils.changeCellToString(row.getCell(26), false);
            orgImportBO.setIsCreateUser(isCreateUser);
            String loginNameReq = ExcelParseUtils.changeCellToString(row.getCell(27), false);
            orgImportBO.setLoginNameReq(loginNameReq);
            String emailReq = ExcelParseUtils.changeCellToString(row.getCell(28), false);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)emailReq)) {
                if (this.checkEmail(emailReq)) {
                    orgImportBO.setEmailReq(emailReq);
                } else {
                    failDesc.append("\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef|");
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isCreateUser)) {
                failDesc.append("\u521b\u5efa\u7528\u6237\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a|");
                orgImportBO.setLoginNameReq(null);
                orgImportBO.setCellPhoneReq(null);
                orgImportBO.setEmailReq(null);
            } else if (isCreateUser.equals(CREATE_USER_IDENTITY)) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)loginNameReq)) {
                    failDesc.append("\u5546\u6237\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a|");
                } else if (!OrgBatchImportServiceImpl.isContainChinese(loginNameReq)) {
                    if (loginNameSet.contains(loginNameReq)) {
                        failDesc.append("\u5546\u6237\u8d26\u53f7\u91cd\u590d|");
                    } else {
                        loginNameSet.add(loginNameReq);
                    }
                } else {
                    failDesc.append("\u5546\u6237\u8d26\u53f7\u683c\u5f0f\u9519\u8bef|");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)emailReq)) {
                    failDesc.append("\u5546\u6237\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a|");
                }
                orgImportBO.setCellPhoneReq(contactPhone);
            } else {
                orgImportBO.setLoginNameReq(null);
                orgImportBO.setCellPhoneReq(null);
                orgImportBO.setEmailReq(null);
            }
            orgImportBO.setRowNum(String.valueOf(row.getRowNum() + 1));
            orgImportBO.setDesc(failDesc.toString());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgImportBO.getDesc())) {
                successTempBOs.add(orgImportBO);
                continue;
            }
            failBOs.add(orgImportBO);
        }
        log.info("\u673a\u6784\u6279\u5bfcExcel\u89e3\u6790\u7b26\u5408\u89c4\u5219\u96c6\u5408,successTempBOs{}", (Object)JSON.toJSONString(successTempBOs));
        ArrayList<OrgBatchImportBO> successBOs = new ArrayList<OrgBatchImportBO>();
        if (CollectionUtils.isNotEmpty(successTempBOs)) {
            this.dbCheck(successTempBOs, successBOs, failBOs, orgTreePath, orgBatchImportFileReqBO.getToken());
        }
        log.info("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u9a8c\u8bc1\u5931\u8d25\u96c6\u5408,failBOs={}", (Object)JSON.toJSONString(failBOs));
        log.info("\u673a\u6784\u6279\u5bfc\u89e3\u6790\u9a8c\u8bc1\u6210\u529f\u96c6\u5408,successBOs={}", (Object)JSON.toJSONString(successBOs));
        orgRspBO.setSuccessBOs(successBOs);
        orgRspBO.setFailuresBOs(failBOs);
        return orgRspBO;
    }

    private void dbCheck(List<OrgBatchImportBO> successTempBOs, List<OrgBatchImportBO> successBOs, List<OrgBatchImportBO> failBOs, String orgTreePath, String token) {
        ArrayList<String> loginNameS = new ArrayList<String>();
        ArrayList<String> cellPhoneS = new ArrayList<String>();
        ArrayList<Long> orgIdS = new ArrayList<Long>();
        for (OrgBatchImportBO orgBatchImportBO : successTempBOs) {
            loginNameS.add(orgBatchImportBO.getLoginNameReq());
            cellPhoneS.add(orgBatchImportBO.getCellPhoneReq());
            if (orgBatchImportBO.getParentId() == null) {
                orgBatchImportBO.setDesc(orgBatchImportBO.getDesc() + "\u4e0a\u7ea7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a|");
                continue;
            }
            orgIdS.add(orgBatchImportBO.getParentId());
        }
        List<String> loginNameSOut = this.selectUserBatchAtomService.selectUserLoginNameBatchByLoginName(loginNameS);
        List<String> cellPhoneSOut = this.selectUserBatchAtomService.selectUserCellPhoneBatchByCellPhone(cellPhoneS);
        Map<Long, OrganisationBO> orgMap = this.selectOrgBatchAtomService.selectOrgBatchByOrgIdS(orgIdS);
        Map<String, String> levelMap = this.queryMerchantEscapeCode("MERCHANT_LEVEL", token);
        Map<String, String> charcterMap = this.queryMerchantEscapeCode("MERCHANT_MERCHANT_CHARACTER", token);
        Map<String, String> typeMap = this.queryMerchantEscapeCode("MERCHANT_TYPE", token);
        Map<String, String> marketMap = this.queryMerchantEscapeCode("MERCHANT_MARKET_MODE", token);
        Map<String, String> attributionAreaTypeMap = this.queryMerchantEscapeCode("ATTRIBUTION_AREA_TYPE", token);
        for (OrgBatchImportBO orgBatchImportBO : successTempBOs) {
            OrganisationBO organisationBO;
            JSONObject dataObj;
            StringBuilder failDesc = new StringBuilder();
            if (this.queryMerchantIsRepeat(orgBatchImportBO.getTitle().trim(), token)) {
                failDesc.append(orgBatchImportBO.getTitle() + "\u5df2\u5b58\u5728|");
            }
            if (typeMap.containsKey(orgBatchImportBO.getTypeName())) {
                orgBatchImportBO.setType(typeMap.get(orgBatchImportBO.getTypeName()));
            } else {
                failDesc.append("\u5546\u6237\u7c7b\u578b\u4e0d\u5b58\u5728|");
            }
            if (marketMap.containsKey(orgBatchImportBO.getMarketModeName())) {
                orgBatchImportBO.setMarketMode(marketMap.get(orgBatchImportBO.getMarketModeName()));
            } else {
                failDesc.append("\u7ecf\u8425\u5f62\u5f0f\u4e0d\u5b58\u5728|");
            }
            if (attributionAreaTypeMap.containsKey(orgBatchImportBO.getAttributionAreaTypeName())) {
                orgBatchImportBO.setAttributionAreaType(attributionAreaTypeMap.get(orgBatchImportBO.getAttributionAreaTypeName()));
            } else {
                failDesc.append("\u5f52\u5c5e\u533a\u57df\u4e0d\u5b58\u5728|");
            }
            if (levelMap.containsKey(orgBatchImportBO.getLevelName())) {
                orgBatchImportBO.setLevel(levelMap.get(orgBatchImportBO.getLevelName()));
                if ("\u4f01\u4e1a".equals(orgBatchImportBO.getLevelName())) {
                    if (charcterMap.containsKey(orgBatchImportBO.getMerchantCharacterName())) {
                        orgBatchImportBO.setMerchantCharacter(charcterMap.get(orgBatchImportBO.getMerchantCharacterName()));
                    } else {
                        failDesc.append("\u4f01\u4e1a\u6027\u8d28\u4e0d\u5b58\u5728|");
                    }
                }
            } else {
                failDesc.append("\u5546\u6237\u5927\u7c7b\u4e0d\u5b58\u5728|");
            }
            if (null != (dataObj = this.queryCoordinate(orgBatchImportBO.getAddress(), token))) {
                orgBatchImportBO.setLatitude(dataObj.getString("latitude"));
                orgBatchImportBO.setLongitude(dataObj.getString("longitude"));
            }
            if (orgBatchImportBO.getIsCreateUser().equals(CREATE_USER_IDENTITY)) {
                if (loginNameSOut.contains(orgBatchImportBO.getLoginNameReq())) {
                    failDesc.append("\u7528\u6237\u540d\u5df2\u5b58\u5728|");
                }
                if (cellPhoneSOut.contains(orgBatchImportBO.getCellPhoneReq())) {
                    failDesc.append("\u624b\u673a\u53f7\u5df2\u5b58\u5728|");
                }
            }
            if ((organisationBO = orgMap.get(orgBatchImportBO.getParentId())) != null) {
                if (!organisationBO.getOrgTreePath().contains(orgTreePath)) {
                    failDesc.append("\u5f53\u524d\u7528\u6237\u6743\u9650\u4e0d\u652f\u6301\u521b\u5efa\u8be5\u673a\u6784|");
                }
                if ("org_type_5".equals(organisationBO.getType())) {
                    failDesc.append("\u4e0a\u7ea7\u673a\u6784\u4e3a\u5546\u6237,\u4e0d\u80fd\u7ee7\u7eed\u521b\u5efa\u5546\u6237|");
                }
                if (!"org_type_3".equals(organisationBO.getType()) && !"org_type_4".equals(organisationBO.getType())) {
                    failDesc.append("\u4e0a\u7ea7\u673a\u6784\u4e0d\u80fd\u521b\u5efa\u5546\u6237,\u8bf7\u91cd\u65b0\u6307\u5b9a|");
                }
            } else {
                failDesc.append("\u4e0a\u7ea7\u673a\u6784\u4e0d\u5b58\u5728|");
            }
            orgBatchImportBO.setDesc(orgBatchImportBO.getDesc() + failDesc.toString());
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgBatchImportBO.getDesc()) || "\u89e3\u6790\u6210\u529f".equals(orgBatchImportBO.getDesc())) {
                orgBatchImportBO.setDesc("\u89e3\u6790\u6210\u529f");
                successBOs.add(orgBatchImportBO);
                continue;
            }
            failBOs.add(orgBatchImportBO);
        }
    }

    private JSONObject queryCoordinate(String address, String token) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("requestInput", address);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString(paramMap), headerMap, this.ADDRESS_COORDINATE_URL, null, null, "application/json");
        JSONObject rspJson = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        if (null == rspJson || !"0000".equals(rspJson.get((Object)"respCode"))) {
            return null;
        }
        return rspJson.getJSONObject("data");
    }

    private Map<String, String> queryLease(String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("type", "01");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString(paramMap), headerMap, this.LEASE_CHECK_URL, null, null, "application/json");
        JSONObject leaseJson = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        if (null != leaseJson && null != leaseJson.get((Object)"rows")) {
            JSONArray rows = leaseJson.getJSONArray("rows");
            for (int i = 0; i < rows.size(); ++i) {
                JSONObject obj = rows.getJSONObject(i);
                map.put(obj.getString("id"), obj.getString("leaseName"));
            }
        }
        return map;
    }

    private Map<String, String> queryMerchantEscapeCode(String parentCode, String token) {
        log.info("\u673a\u6784\u6279\u5bfc,\u67e5\u8be2\u5546\u6237\u7801\u8868\u5f00\u59cb");
        HashMap<String, String> map = new HashMap<String, String>();
        OrgBatchImportBO merchantBO = new OrgBatchImportBO();
        merchantBO.setParentCode(parentCode);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)merchantBO), headerMap, this.MERCHANT_ESCAPECODE_BYPARENTCODE_URL, null, null, "application/json");
        JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        log.info("http\u8c03\u7528\u5546\u6237\u5b8c\u6bd5,\u6839\u636eparentCode\u67e5\u8be2\u7801\u8868\u7684\u7ed3\u679c\u4e3adata{}", (Object)data);
        if (!data.get((Object)"respCode").equals("0000")) {
            log.error("\u673a\u6784\u6279\u5bfc,\u67e5\u8be2\u5546\u6237\u7801\u8868\u5931\u8d25:" + data.get((Object)"respDesc").toString());
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u670d\u52a1,\u5546\u6237\u9a8c\u8bc1\u5931\u8d25");
        }
        JSONArray rows = JSONArray.parseArray((String)data.get((Object)"rows").toString());
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject jsonObject = JSON.parseObject((String)rows.get(i).toString());
            map.put(jsonObject.getString("codeTitle"), jsonObject.getString("code"));
        }
        return map;
    }

    private boolean queryMerchantIsRepeat(String title, String token) {
        log.info("\u5546\u6237\u6279\u91cf\u65b0\u589e,\u67e5\u8be2\u5546\u6237\u540d\u79f0\u662f\u5426\u5b58\u5728");
        HashMap map = new HashMap();
        OrgBatchImportBO merchantBO = new OrgBatchImportBO();
        merchantBO.setTitle(title);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("auth-token", token);
        String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)merchantBO), headerMap, this.MERCHANT_ADD_IS_REPATE_CHECK_URL, null, null, "application/json");
        JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
        log.info("httpt\u8c03\u7528\u67e5\u8be2\u5546\u6237\u662f\u5426\u5b58\u5728\u5b8c\u6bd5,\u6839\u636e\u5546\u6237\u540d\u79f0\u67e5\u8be2\u7ed3\u679c\u4e3adata{}", (Object)data);
        if (!data.get((Object)"respCode").equals("0000")) {
            log.error("\u5546\u6237\u6279\u91cf\u65b0\u589e,\u67e5\u8be2\u5546\u6237\u540d\u79f0\u662f\u5426\u5b58\u5728\u5931\u8d25:" + data.get((Object)"respDesc").toString());
            throw new ZTBusinessException("\u5546\u6237\u6279\u91cf\u65b0\u589e,\u67e5\u8be2\u5546\u6237\u540d\u79f0\u662f\u5426\u5b58\u5728\u5931\u8d25");
        }
        JSONObject result = JSON.parseObject((String)data.get((Object)"data").toString());
        return result.toJSONString().length() > 2 && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)result.getString("title"));
    }

    private static boolean checkLeasingTime(String leasingTime) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)leasingTime)) {
            return false;
        }
        try {
            String time = leasingTime.replaceAll(" ", "");
            String[] split = new String[]{time.substring(0, 10), time.substring(11)};
            if (split[0].length() != 10 || split[1].length() != 10) {
                return false;
            }
            for (String temp : split) {
                if (temp.matches(dayPattern)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkBusiTime(String busiTimeOne) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)busiTimeOne)) {
            return false;
        }
        if (busiTimeOne.length() == 11) {
            return OrgBatchImportServiceImpl.hhssSplit(busiTimeOne);
        }
        if (busiTimeOne.length() == 23) {
            if (!busiTimeOne.contains(" ")) {
                return false;
            }
            String[] splitOne = busiTimeOne.split(" ");
            if (splitOne.length != 2) {
                return false;
            }
            for (String busiTime : splitOne) {
                if (OrgBatchImportServiceImpl.hhssSplit(busiTime)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hhssSplit(String busiTime) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)busiTime) || !busiTime.contains("-")) {
            return false;
        }
        String[] split = busiTime.split("-");
        if (split.length != 2) {
            return false;
        }
        try {
            return OrgBatchImportServiceImpl.hhssCheck(split[0]) && (OrgBatchImportServiceImpl.hhssCheck(split[1]) || "24:00".equals(split[1]));
        }
        catch (Exception e) {
            log.info("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25\uff0ctime={}", (Object)busiTime);
            return false;
        }
    }

    private static boolean hhssCheck(String split) {
        return split.matches(hhssPattern);
    }

    public boolean checkEmail(String email) {
        boolean flag = false;
        try {
            String check = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            flag = matcher.matches();
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u90ae\u7bb1\u5730\u5740\u9519\u8bef", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"batchImportInsert"})
    public RspBaseBO batchImportInsert(@RequestBody OrgBatchImportReqBO orgBatchImportReqBO) throws Exception {
        RspBaseBO rspBaseBO = new RspBaseBO();
        if (orgBatchImportReqBO == null) {
            log.error("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportReqBO\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        if (null == orgBatchImportReqBO.getmOrgPath() || null == orgBatchImportReqBO.getmTenantId()) {
            log.error("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u7528\u6237\u4fe1\u606f\u8def\u5f84|\u79df\u6237id\u4e3a\u7a7a");
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1_\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
        }
        log.info("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u5165\u53c2,orgBatchImportReqBO{}", (Object)orgBatchImportReqBO);
        Long tenantId = orgBatchImportReqBO.getmTenantId();
        String orgTreePath = orgBatchImportReqBO.getmOrgPath();
        List orgBatchImportBOList = orgBatchImportReqBO.getLists();
        log.info("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1\u6821\u9a8c\u96c6\u5408,orgBatchImportBOList{}", (Object)JSON.toJSONString((Object)orgBatchImportBOList));
        ArrayList<OrgBatchImportBO> successBOs = new ArrayList<OrgBatchImportBO>();
        ArrayList<OrgBatchImportBO> failBOs = new ArrayList<OrgBatchImportBO>();
        this.dbCheck(orgBatchImportBOList, successBOs, failBOs, orgTreePath, orgBatchImportReqBO.getToken());
        if (CollectionUtils.isNotEmpty(failBOs)) {
            log.error("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u4fe1\u606f\u6821\u9a8c\u5931\u8d25failBOs{}" + JSON.toJSONString(failBOs));
            throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u4fe1\u606f\u6821\u9a8c\u5931\u8d25");
        }
        ArrayList<OrganisationBO> addOrgReqBOS = new ArrayList<OrganisationBO>();
        HashMap<String, AddUserReqBO> addUserMap = new HashMap<String, AddUserReqBO>();
        ArrayList<OrgBatchImportBO> orgBatchImportBOS = new ArrayList<OrgBatchImportBO>();
        for (Object orgBatchImportBO : orgBatchImportBOList) {
            OrganisationBO organisationBO = new OrganisationBO();
            BeanUtils.copyProperties((Object)orgBatchImportBO, (Object)organisationBO);
            organisationBO.setTenantId(tenantId);
            organisationBO.setCreatTime(new Date());
            organisationBO.setType("org_type_5");
            organisationBO.setRemark(orgBatchImportBO.getContactName());
            organisationBO.setTel(orgBatchImportBO.getContactPhone());
            organisationBO.setTypeCode(orgBatchImportBO.getType());
            addOrgReqBOS.add(organisationBO);
            if (!orgBatchImportBO.getIsCreateUser().equals(CREATE_USER_IDENTITY)) continue;
            organisationBO.setTempStr(orgBatchImportBO.getLoginNameReq());
            AddUserReqBO addUserReqBO = new AddUserReqBO();
            addUserReqBO.setLoginNameReq(orgBatchImportBO.getLoginNameReq());
            addUserReqBO.setCellPhoneReq(orgBatchImportBO.getCellPhoneReq());
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addUserReqBO.setAuthUserId(Long.valueOf(l));
            addUserReqBO.setNameReq(orgBatchImportBO.getTitle());
            addUserReqBO.setEmailReq(orgBatchImportBO.getEmailReq());
            addUserReqBO.setType(this.MERCHANT_ROLE_CODE);
            addUserReqBO.setUserId(orgBatchImportReqBO.getmUserId());
            addUserReqBO.setTenantIdReq(tenantId);
            addUserMap.put(addUserReqBO.getLoginNameReq(), addUserReqBO);
        }
        List<OrganisationBO> organisationBOS = this.insertOrgBatchAtomService.insertOrgBatch(addOrgReqBOS);
        for (OrganisationBO organisationBO : organisationBOS) {
            String loginName = organisationBO.getTempStr();
            AddUserReqBO addUserReqBO = (AddUserReqBO)addUserMap.get(loginName);
            if (addUserReqBO != null) {
                addUserReqBO.setOrgIdReq(organisationBO.getOrgId());
            }
            OrgBatchImportBO orgBatchImportBO = new OrgBatchImportBO();
            JSONObject data = JSONObject.parseObject((String)organisationBO.getExtJson());
            orgBatchImportBO.setTitle(organisationBO.getTitle());
            orgBatchImportBO.setMerchantId(organisationBO.getOrgId());
            orgBatchImportBO.setOrgTreePath(organisationBO.getOrgTreePath());
            orgBatchImportBO.setLevel(data.get((Object)"level").toString());
            if (null != data.get((Object)"merchantCharacter")) {
                orgBatchImportBO.setMerchantCharacter(data.get((Object)"merchantCharacter").toString());
            }
            orgBatchImportBO.setType(data.get((Object)"typeCode").toString());
            orgBatchImportBO.setAttributionAreaType(data.get((Object)"attributionAreaType").toString());
            orgBatchImportBO.setType(data.get((Object)"typeCode").toString());
            if (null != data.get((Object)"merchantBrand")) {
                orgBatchImportBO.setMerchantBrand(data.get((Object)"merchantBrand").toString());
            }
            orgBatchImportBO.setMerchantIntroduction(data.get((Object)"merchantIntroduction").toString());
            orgBatchImportBO.setBusiTime(data.get((Object)"busiTime").toString());
            orgBatchImportBO.setReserved1(data.get((Object)"busiTime").toString());
            orgBatchImportBO.setMerchantPhone(data.get((Object)"merchantPhone").toString());
            orgBatchImportBO.setAddress(data.get((Object)"address").toString());
            orgBatchImportBO.setArea(Double.valueOf(Double.parseDouble(data.get((Object)"area").toString())));
            if (null != data.get((Object)"leasingMode")) {
                // empty if block
            }
            orgBatchImportBO.setMarketMode(data.get((Object)"marketMode").toString());
            orgBatchImportBO.setIsWater(data.get((Object)"isWater").toString());
            orgBatchImportBO.setIsElectric(data.get((Object)"isElectric").toString());
            orgBatchImportBO.setIsHeating(data.get((Object)"isHeating").toString());
            orgBatchImportBO.setBankAccountMaster(data.get((Object)"bankAccountMaster").toString());
            orgBatchImportBO.setBankAccount(data.get((Object)"bankAccount").toString());
            orgBatchImportBO.setBankName(data.get((Object)"bankName").toString());
            orgBatchImportBO.setContactName(data.get((Object)"remark").toString());
            orgBatchImportBO.setContactPhone(data.get((Object)"tel").toString());
            if (null != data.get((Object)"longitude")) {
                orgBatchImportBO.setLongitude(data.get((Object)"longitude") + "");
            }
            if (null != data.get((Object)"latitude")) {
                orgBatchImportBO.setLatitude(data.get((Object)"latitude") + "");
            }
            if (null != data.get((Object)"contactJob")) {
                orgBatchImportBO.setContactJob(data.get((Object)"contactJob").toString());
            }
            if (null != data.get((Object)"contactSex")) {
                orgBatchImportBO.setContactSex(data.get((Object)"contactSex").toString());
            }
            orgBatchImportBO.setContactWechat(data.get((Object)"contactWechat").toString());
            if (null != data.get((Object)"contactEmail")) {
                orgBatchImportBO.setContactEmail(data.get((Object)"contactEmail").toString());
            }
            orgBatchImportBOS.add(orgBatchImportBO);
        }
        ArrayList addUserReqBOS = new ArrayList(addUserMap.values());
        if (CollectionUtils.isNotEmpty(addUserReqBOS)) {
            AddUserListReqBO addUserListReqBO = new AddUserListReqBO();
            addUserListReqBO.setAddUserReqBOS(addUserReqBOS);
            this.addManageUserService.insertBatchUser(addUserListReqBO);
        }
        if (CollectionUtils.isNotEmpty(orgBatchImportBOS)) {
            orgBatchImportReqBO.setLists(orgBatchImportBOS);
            log.info("http\u8fde\u63a5\u5546\u6237\u6279\u91cf\u65b0\u589e\u5f00\u59cb\uff0corgBatchImportReqBO{}", (Object)JSON.toJSONString((Object)orgBatchImportReqBO));
            System.out.println(JSON.toJSONString((Object)orgBatchImportReqBO));
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("auth-token", orgBatchImportReqBO.getToken());
            String jsonStr = HttpConnUtils.conn(null, JSON.toJSONString((Object)orgBatchImportReqBO), headerMap, this.MERCHANT_BATCHIMOPRT_ADD_URL, null, null, "application/json");
            JSONObject data = JSON.parseObject((String)String.valueOf(JSON.parseObject((String)jsonStr)));
            log.info("http\u8c03\u7528\u5546\u6237\u5b8c\u6bd5,\u5546\u6237\u6279\u5bfc\u65b0\u589e\u7ed3\u679c\u4e3a:{}", (Object)data);
            String respCode = data.get((Object)"respCode").toString();
            if (!respCode.equals("0000")) {
                String respDesc = data.get((Object)"respDesc").toString();
                log.error("\u5546\u6237\u6279\u91cf\u65b0\u589e\u51fa\u9519\uff1a" + respDesc);
                throw new ZTBusinessException("\u673a\u6784\u6279\u5bfc\u65b0\u589e\u4e1a\u52a1\u670d\u52a1,\u5546\u6237\u6279\u91cf\u65b0\u589e\u5931\u8d25");
            }
        }
        return rspBaseBO;
    }

    @PostMapping(value={"getOrgBatchExcelURL"})
    public OrgBatchExcelURLRspBO getOrgBatchExcelURL() {
        OrgBatchExcelURLRspBO orgBatchExcelURLRspBO = new OrgBatchExcelURLRspBO();
        orgBatchExcelURLRspBO.setExcelURL(this.OSS_ACCESSURL + this.ORGBATCH_EXECEL_URL);
        return orgBatchExcelURLRspBO;
    }

    private static boolean checkCellPhone(String cellPhoneReq) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)cellPhoneReq)) {
            return false;
        }
        Pattern phoneP = Pattern.compile("1\\d{10}");
        String gradedPhonePattern = "((\\d{11})|^((\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})|(\\d{4}|\\d{3})-(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1})|(\\d{7,8})-(\\d{4}|\\d{3}|\\d{2}|\\d{1}))$)";
        if (phoneP.matcher(cellPhoneReq).matches()) {
            return true;
        }
        if (cellPhoneReq.length() == 11 || cellPhoneReq.length() == 10 || cellPhoneReq.length() == 13 || cellPhoneReq.length() == 12) {
            if (cellPhoneReq.matches("\\(?0\\d{2}[) -]?\\d{8}")) {
                return true;
            }
            if (cellPhoneReq.matches("\\(?0\\d{3}[) -]?\\d{8}")) {
                return true;
            }
            if (cellPhoneReq.matches("\\(?0\\d{2}[) -]?\\d{7}")) {
                return true;
            }
            if (cellPhoneReq.matches("\\(?0\\d{3}[) -]?\\d{7}")) {
                return true;
            }
        }
        log.debug("\u5ea7\u673a\u5206\u673a\u53f7\u9a8c\u8bc1");
        if (cellPhoneReq.matches(gradedPhonePattern)) {
            return true;
        }
        log.debug("\u5ea7\u673a\u5206\u673a\u53f7\u5931\u8d25");
        return false;
    }
}

