/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.role.bo.HasAndNotGrantRoleBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService"})
public class SelectUserOperateRolesBusiServiceImpl
implements SelectUserOperateRolesBusiService {
    public static final Logger log = LoggerFactory.getLogger(SelectUserOperateRolesBusiServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;

    @PostMapping(value={"selectUserOperateRoles"})
    public SelectUserOperateRolesRspBO selectUserOperateRoles(@RequestBody SelectUserOperateRolesReqBO userOperateRolesReqBO) {
        List<HasAndNotGrantRoleBO> longList3;
        List<HasAndNotGrantRoleBO> longList2;
        log.info("\u67e5\u8be2\u767b\u5f55\u4eba\u6240\u6709\u53ef\u64cd\u4f5c\u7684\u89d2\u8272\u8be6\u60c5\u5165\u53c2\uff1a" + userOperateRolesReqBO.toString());
        HashSet<HasAndNotGrantRoleBO> operateRoles = new HashSet<HasAndNotGrantRoleBO>();
        UserPO userPO = this.userMapper.selectUserInfo(userOperateRolesReqBO.getUserId());
        List<HasAndNotGrantRoleBO> longList1 = this.roleMapper.selectRoleIdsByType(Constants.ORG_TYPE_OVERALL, null);
        if (!CollectionUtils.isEmpty(longList1)) {
            operateRoles.addAll(longList1);
        }
        if (!CollectionUtils.isEmpty(longList2 = this.roleMapper.selectRoleIdsByType(Constants.ORG_TYPE_PART, null))) {
            operateRoles.addAll(longList2);
        }
        if ("auth:overall:manage".equals(userPO.getType()) || "auth:system:manage".equals(userPO.getType())) {
            List<HasAndNotGrantRoleBO> longList32;
            UserPO selectUserInfo = null;
            OrganisationPO selectOrgInfo = null;
            if (null != userOperateRolesReqBO.getPrarmUserId()) {
                selectUserInfo = this.userMapper.selectUserInfo(userOperateRolesReqBO.getPrarmUserId());
            } else if (!StringUtils.isEmpty((Object)userOperateRolesReqBO.getPrarmOrgTreePath())) {
                selectOrgInfo = this.organizationMapper.selectOrganisationByOrgTreePath(userOperateRolesReqBO.getPrarmOrgTreePath());
            }
            Long tnantId = null;
            if (null != selectUserInfo) {
                tnantId = selectUserInfo.getTenantId();
            } else if (null != selectOrgInfo) {
                tnantId = selectOrgInfo.getTenantId();
            }
            if (tnantId != null && !CollectionUtils.isEmpty(longList32 = this.roleMapper.selectRoleIdsByTenantId(tnantId))) {
                operateRoles.addAll(longList32);
            }
        } else if ("auth:tenant:manage".equals(userPO.getType()) && !CollectionUtils.isEmpty(longList3 = this.roleMapper.selectRoleIdsByTenantId(userOperateRolesReqBO.getTenantId()))) {
            operateRoles.addAll(longList3);
        }
        SelectUserOperateRolesRspBO userOperateRolesRspBO = new SelectUserOperateRolesRspBO();
        LinkedList<HasAndNotGrantRoleBO> userOperateRoles = new LinkedList<HasAndNotGrantRoleBO>();
        if (!CollectionUtils.isEmpty(operateRoles)) {
            userOperateRoles.addAll(operateRoles);
        }
        userOperateRolesRspBO.setUserOperateRoles(userOperateRoles);
        return userOperateRolesRspBO;
    }
}

