/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.DeleteBatchUserReqBO;
import com.ohaotian.authority.user.bo.DeleteUserReqBO;
import com.ohaotian.authority.user.service.DeleteUserService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.user.service.DeleteUserService"})
public class DeleteUserServiceImpl
implements DeleteUserService {
    private static final Logger log = LoggerFactory.getLogger(DeleteUserServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    @PostMapping(value={"deleteUserByUserId"})
    public void deleteUserByUserId(@RequestBody DeleteUserReqBO userReqBO) {
        UserPO userPO = this.userMapper.selectUserInfo(userReqBO.getUserId());
        this.userMapper.deleteUserByUserId(userReqBO.getUserId());
        this.userMapper.deleteByExtSysUser(userReqBO.getUserId());
        this.userMapper.deleteUserStation(userReqBO.getUserId());
        this.authDistributeMapper.deleteByUserId(userReqBO.getUserId());
        this.organizationMapper.updateMuserIdNull(userReqBO.getUserId());
    }

    @Transactional
    @PostMapping(value={"deleteBatchUserByIds"})
    public void deleteBatchUserByIds(@RequestBody DeleteBatchUserReqBO reqBO) {
        log.info("\u6279\u91cf\u5220\u9664\u7528\u6237\u5165\u53c2, {}", (Object)JSON.toJSONString((Object)reqBO));
        if (null == reqBO || CollectionUtils.isEmpty((Collection)reqBO.getUserIdS())) {
            throw new ZTBusinessException("\u6279\u91cf\u5220\u9664\u7528\u6237,\u5165\u53c2\u4e3a\u7a7a");
        }
        List userIdS = reqBO.getUserIdS();
        List<UserPO> userPOS = this.userMapper.selectUserBatchByIdS(userIdS);
        if (CollectionUtils.isEmpty(userPOS) || userIdS.size() != userPOS.size()) {
            log.error("\u6279\u91cf\u5220\u9664\u7528\u6237,\u4e0d\u80fd\u5220\u9664\u4e0d\u5b58\u5728\u7684\u7528\u6237,userPOS= {}", (Object)JSON.toJSONString(userPOS));
            throw new ZTBusinessException("\u6279\u91cf\u5220\u9664\u7528\u6237,\u4e0d\u80fd\u5220\u9664\u4e0d\u5b58\u5728\u7684\u7528\u6237");
        }
        this.userMapper.deleteBatchExtSysUser(userIdS);
        this.userMapper.deleteUserBatchStation(userIdS);
        this.authDistributeMapper.deleteBatchByUserIdS(userIdS);
        this.organizationMapper.deleteBatchMangerOrgByUserIdS(userIdS);
        this.userMapper.deleteBatchUserByUserIdS(userIdS);
    }
}

