/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrgRoleMapper;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.role.service.SaveDistributeBusiService;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.service.DeleteRoleByUserIdService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.util.HttpConnUtils;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import com.ohaotian.plugin.db.Sequence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dev/1.0.0/com.ohaotian.authority.user.service.SaveUserAuthService"})
public class SaveUserAuthServiceImpl
implements SaveUserAuthService {
    private static final Logger log = LoggerFactory.getLogger(SaveUserAuthServiceImpl.class);
    @Autowired
    private DeleteRoleByUserIdService deleteRoleByUserIdService;
    @Autowired
    private SaveDistributeBusiService saveDistributeBusiService;
    @Resource
    private OrgRoleMapper orgRoleMapper;
    @Resource
    private AuthDistributeMapper authDistributeMapper;
    @Value(value="${APPROVAL_ROLE_OBJECT_UPDATE_URL}")
    private String APPROVAL_ROLE_OBJECT_UPDATE_URL;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"saveUserAuthService"})
    public void saveUserAuthService(@RequestBody SaveUserRolesAuthReqBO saveUserAuthReqBO) {
        Set<Long> delete;
        log.info("\u7528\u6237\u6388\u6743\u63d0\u4ea4-\u5165\u53c2{}", (Object)JSON.toJSONString((Object)saveUserAuthReqBO));
        Long userId = saveUserAuthReqBO.getUserId();
        String json = saveUserAuthReqBO.getJson();
        String manaOrgTreePath = saveUserAuthReqBO.getManaOrgTreePath();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        List<Long> roleIdList = this.orgRoleMapper.selectRoleIdByRoleName();
        HashSet<Long> roleIdSet = new HashSet<Long>(roleIdList);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            add.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                Sequence sequence = Sequence.getInstance();
                long l = sequence.nextId();
                authDistributeBO.setAuthId(Long.valueOf(l));
                authDistributeBO.setUserId(userId);
                authDistributeBO.setRoleId(e);
                authDistributeBO.setDisFlag(Constants.AUTH_USER);
                authDistributeBO.setManaOrgTreePath(manaOrgTreePath);
                this.saveDistributeBusiService.saveDistribute(authDistributeBO);
                if (roleIdSet.contains((long)e)) {
                    AuthDistribute authDistribute = new AuthDistribute();
                    authDistribute.setAddOrDelete(true);
                    authDistribute.setUserId(authDistributeBO.getUserId());
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    headerMap.put("auth-token", saveUserAuthReqBO.getToken());
                    String conn = HttpConnUtils.conn(null, JSON.toJSONString((Object)authDistribute), headerMap, this.APPROVAL_ROLE_OBJECT_UPDATE_URL, null, null, "application/json");
                    log.info("http\u8bf7\u6c42\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)conn);
                }
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            delete.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(userId);
                authDistributeBO.setRoleId(e);
                this.deleteRoleByUserIdService.deleteRoleByUserId(authDistributeBO);
                if (roleIdSet.contains((long)e)) {
                    AuthDistribute authDistribute = new AuthDistribute();
                    authDistribute.setAddOrDelete(false);
                    authDistribute.setUserId(authDistributeBO.getUserId());
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    headerMap.put("auth-token", saveUserAuthReqBO.getToken());
                    String conn = HttpConnUtils.conn(null, JSON.toJSONString((Object)authDistribute), headerMap, this.APPROVAL_ROLE_OBJECT_UPDATE_URL, null, null, "application/json");
                    log.info("http\u8bf7\u6c42\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)conn);
                }
            });
        }
    }
}

