/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.menu;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.menu.bo.UpdateByMenuIdReqBO;
import com.ohaotian.authority.menu.service.UpdateByMenuIdBusiService;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=UpdateByMenuIdBusiService.class)
public class UpdateByMenuIdBusiServiceImpl
implements UpdateByMenuIdBusiService {
    private static final Logger log = LoggerFactory.getLogger(UpdateByMenuIdBusiServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;

    @Transactional
    public void updateByMenuId(UpdateByMenuIdReqBO updateByMenuIdReqBO) {
        Menu menu = this.menuMapper.selectByPrimaryKey(updateByMenuIdReqBO.getMenuId());
        if (menu.getParentId() != null && menu.getParentId().equals(updateByMenuIdReqBO.getParentId())) {
            Menu parentMenu = this.menuMapper.selectByPrimaryKey(updateByMenuIdReqBO.getParentId());
            String menuTreePathTemp = parentMenu.getMenuTreePath() + updateByMenuIdReqBO.getMenuId() + "-";
            List<Menu> menus = this.menuMapper.selectTreePathMenus(menu.getMenuTreePath());
            for (Menu menu1 : menus) {
                String replace = menu1.getMenuTreePath().replace(menu.getMenuTreePath(), menuTreePathTemp);
                Menu cond = new Menu();
                cond.setMenuId(menu1.getMenuId());
                cond.setMenuTreePath(replace);
                this.menuMapper.updateByPrimaryKey(cond);
            }
        }
        if (Constants.MENU_TYPE_M.equals(menu.getType()) && !StringUtils.equals((String)menu.getExtApplicationCode(), (String)updateByMenuIdReqBO.getExtApplicationCode())) {
            if (StringUtils.isEmpty((String)updateByMenuIdReqBO.getExtApplicationCode())) {
                updateByMenuIdReqBO.setExtApplicationCode(null);
            }
            this.menuMapper.updateExtAppCode(updateByMenuIdReqBO.getExtApplicationCode(), menu.getMenuTreePath());
        }
        Menu map = (Menu)BeanMapper.map((Object)updateByMenuIdReqBO, Menu.class);
        map.setUpdateUserId(updateByMenuIdReqBO.getUserId());
        map.setUpdateTime(new Date());
        this.menuMapper.updateByPrimaryKey(map);
    }
}

