/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.ManagerRoleMapper;
import com.ohaotian.authority.manager.bo.SaveMgrConfigReqBO;
import com.ohaotian.authority.manager.service.SaveMgrConfigBusiService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV", serviceInterface=SaveMgrConfigBusiService.class)
public class SaveMgrConfigBusiServiceImpl
implements SaveMgrConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveMgrConfigBusiServiceImpl.class);
    @Autowired
    private ManagerRoleMapper managerRoleMapper;

    @Transactional
    public void saveMgrConfig(SaveMgrConfigReqBO saveMgrConfigReqBO) {
        Long mgrUserId = saveMgrConfigReqBO.getMgrUserId();
        String configDetail = saveMgrConfigReqBO.getConfigDetail();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.roleConfig(configDetail);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        adds.forEach(add -> this.managerRoleMapper.saveManagerPower(mgrUserId, (Long)add));
        deletes.forEach(delete -> this.managerRoleMapper.deleteManagerPower(mgrUserId, (Long)delete));
    }
}

