/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.aop;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class ServiceLogAdvice {
    private static final Logger log = LoggerFactory.getLogger(ServiceLogAdvice.class);
    private static final String SEPARATOR = "|";
    private static final String CLASS_METHOD_SEPARATOR = ".";
    private static final String TRACE_IDENTIFICATION = "TRACE_ID";
    private static final String START_IDENTIFICATION = "START";
    private static final String ERROR_IDENTIFICATION = "ERROR";
    private static final String END_IDENTIFICATION = "END";
    private static final InheritableThreadLocal<Map<String, String>> THREAD_MAP = new InheritableThreadLocal();

    @Pointcut(value="(execution(* com.ohaotian.authority.logger..*(..))) || (execution(* com.ohaotian.authority.dao..*(..))) || (execution(* com.ohaotian.authority.application..*(..))) || (execution(* com.ohaotian.authority.dic..*(..))) || (execution(* com.ohaotian.authority.districts..*(..))) || (execution(* com.ohaotian.authority.download..*(..))) || (execution(* com.ohaotian.authority.gray..*(..))) || (execution(* com.ohaotian.authority.logger..*(..))) || (execution(* com.ohaotian.authority.login..*(..))) || (execution(* com.ohaotian.authority.manager..*(..))) || (execution(* com.ohaotian.authority.menu..*(..))) || (execution(* com.ohaotian.authority.organisation..*(..))) || (execution(* com.ohaotian.authority.project..*(..))) || (execution(* com.ohaotian.authority.resourceTenant..*(..))) || (execution(* com.ohaotian.authority.role..*(..))) || (execution(* com.ohaotian.authority.station..*(..))) || (execution(* com.ohaotian.authority.tenant..*(..))) || (execution(* com.ohaotian.authority.user..*(..))) || (execution(* com.ohaotian.authority.workday..*(..)))")
    public void pointCut() {
    }

    @Pointcut(value="(execution(* com.ohaotian.authority.logger..*(..))) || (execution(* com.ohaotian.authority.application..*(..))) || (execution(* com.ohaotian.authority.dic..*(..))) || (execution(* com.ohaotian.authority.districts..*(..))) || (execution(* com.ohaotian.authority.download..*(..))) || (execution(* com.ohaotian.authority.gray..*(..))) || (execution(* com.ohaotian.authority.logger..*(..))) || (execution(* com.ohaotian.authority.login..*(..))) || (execution(* com.ohaotian.authority.manager..*(..))) || (execution(* com.ohaotian.authority.menu..*(..))) || (execution(* com.ohaotian.authority.organisation..*(..))) || (execution(* com.ohaotian.authority.project..*(..))) || (execution(* com.ohaotian.authority.resourceTenant..*(..))) || (execution(* com.ohaotian.authority.role..*(..))) || (execution(* com.ohaotian.authority.station..*(..))) || (execution(* com.ohaotian.authority.tenant..*(..))) || (execution(* com.ohaotian.authority.user..*(..))) || (execution(* com.ohaotian.authority.workday..*(..)))")
    public void abilityPointCut() {
    }

    @Before(value="pointCut()")
    public void deBefore(JoinPoint jp) {
        if (THREAD_MAP.get() == null) {
            HashMap mapInfo = Maps.newHashMapWithExpectedSize((int)2);
            UUID uuid = UUID.randomUUID();
            mapInfo.put(TRACE_IDENTIFICATION, uuid.toString().replace("-", ""));
            mapInfo.put(START_IDENTIFICATION, Long.toString(System.currentTimeMillis()));
            THREAD_MAP.set(mapInfo);
        }
        String[] infos = new String[3];
        infos[0] = this.getLogHeadInfo(jp);
        infos[1] = START_IDENTIFICATION;
        Object[] params = jp.getArgs();
        if (params != null && params.length > 0) {
            if (params.length == 1) {
                infos[2] = JSON.toJSONString((Object)params[0]);
            } else {
                StringBuilder paramsStr = new StringBuilder();
                paramsStr.append("[");
                for (Object obj : params) {
                    String objStr = null;
                    if (obj != null) {
                        objStr = JSON.toJSONString((Object)obj);
                    }
                    paramsStr.append(objStr);
                    paramsStr.append(",");
                }
                paramsStr.setLength(paramsStr.length() - 1);
                paramsStr.append("]");
                infos[2] = paramsStr.toString();
            }
        }
        log.debug(this.getLogInfoByStrings(infos));
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Object rspObj;
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> rspClass = method.getReturnType();
        try {
            rspObj = pjp.proceed();
        }
        catch (ZTBusinessException e) {
            String msgCode = "1";
            String desc = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)desc)) {
                desc = "\u5931\u8d25";
            }
            if ("void".equals(rspClass.getName())) {
                throw new ZTBusinessException(desc);
            }
            rspObj = rspClass.newInstance();
            this.printAopErrorLog(e, "\u4e1a\u52a1\u8c03\u7528\u5931\u8d25\u539f\u56e0\uff1a", (JoinPoint)pjp);
            this.putCodeToRsp(rspObj, msgCode, desc);
        }
        catch (DataAccessException e) {
            this.printAopErrorLog(e, "\u6570\u636e\u5f02\u5e38\u4fe1\u606f\uff1a", (JoinPoint)pjp);
            throw new ZTBusinessException("\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        catch (Throwable e) {
            this.printAopErrorLog(e, "\u670d\u52a1\u8c03\u7528\u5f02\u5e38\u4fe1\u606f\uff1a", (JoinPoint)pjp);
            throw new ZTBusinessException("\u670d\u52a1\u8c03\u7528\u5f02\u5e38");
        }
        return rspObj;
    }

    @AfterReturning(returning="rspObj", pointcut="pointCut() && abilityPointCut()")
    public void doAfterCall(JoinPoint jp, Object rspObj) {
        this.doAfterReturning(jp, rspObj);
        THREAD_MAP.remove();
    }

    @AfterReturning(returning="rspObj", pointcut="pointCut() && !abilityPointCut()")
    public void doAfterReturning(JoinPoint jp, Object rspObj) {
        if (null == jp) {
            return;
        }
        String[] infos = new String[5];
        infos[0] = this.getLogHeadInfo(jp);
        long nowTime = System.currentTimeMillis();
        infos[1] = END_IDENTIFICATION;
        if (rspObj != null && rspObj instanceof RspBaseBO) {
            RspBaseBO resp = (RspBaseBO)rspObj;
            if (log.isDebugEnabled()) {
                infos[2] = JSON.toJSONString((Object)rspObj);
            } else {
                infos[2] = resp.getCode();
                infos[3] = resp.getMessage();
            }
            try {
                infos[4] = "\u7528\u65f6\uff1a" + (nowTime - Long.parseLong((String)((Map)THREAD_MAP.get()).get(START_IDENTIFICATION))) + "ms";
            }
            catch (NullPointerException e) {
                infos[4] = "\u7528\u65f6\uff1a ? ms";
            }
        }
        log.debug(this.getLogInfoByStrings(infos));
    }

    @AfterThrowing(throwing="ex", pointcut="pointCut()")
    public void doAfterThrowing(JoinPoint jp, Throwable ex) {
        this.printAopErrorLog(ex, "\u73af\u7ed5\u901a\u77e5\u5f02\u5e38\u4fe1\u606f\uff1a", jp);
    }

    private String getLogHeadInfo(JoinPoint jp) {
        StringBuilder logHead;
        try {
            log.info(jp.getKind());
            logHead = new StringBuilder((String)((Map)THREAD_MAP.get()).get(TRACE_IDENTIFICATION) + SEPARATOR);
        }
        catch (NullPointerException e) {
            log.info(jp.getKind());
            logHead = new StringBuilder(" ? |");
        }
        String className = jp.getTarget().getClass().getName();
        String methodString = jp.getSignature().getName();
        logHead.append(className);
        logHead.append(CLASS_METHOD_SEPARATOR);
        logHead.append(methodString);
        return logHead.toString();
    }

    private String getLogInfoByStrings(String[] infos) {
        StringBuilder str = new StringBuilder();
        for (String info : infos) {
            if (StringUtils.isBlank((CharSequence)info)) {
                info = "";
            }
            str.append(info).append(SEPARATOR);
        }
        if (str.length() > 1) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }

    private void printAopErrorLog(Throwable e, String desc, JoinPoint jp) {
        String[] infos = new String[]{this.getLogHeadInfo(jp), ERROR_IDENTIFICATION, desc + e.getMessage()};
        log.error(this.getLogInfoByStrings(infos), e);
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, IllegalAccessException {
        if (object instanceof RspBaseBO) {
            Field field = RspBaseBO.class.getDeclaredField("code");
            field.setAccessible(true);
            if (field.get(object) == null) {
                field.set(object, code);
                field = RspBaseBO.class.getDeclaredField("message");
                field.setAccessible(true);
                field.set(object, desc);
            }
        } else {
            try {
                Field field = object.getClass().getDeclaredField("code");
                field.setAccessible(true);
                if (field.get(object) == null) {
                    field.set(object, code);
                    field = object.getClass().getDeclaredField("message");
                    field.setAccessible(true);
                    field.set(object, desc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

