/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.manager.bo.ManagerSearchReqBO;
import com.ohaotian.authority.manager.service.ManagerSearchService;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrgTreeNameService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.user.bo.OrgUser;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.manager.service.ManagerSearchService"})
public class ManagerSearchServiceImpl
implements ManagerSearchService {
    private static final Logger log = LoggerFactory.getLogger(ManagerSearchServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(ManagerSearchServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectOrgTreeNameService selectOrgTreeNameService;

    @PostMapping(value={"selectManagerSearch"})
    public RspPage<OrgUser> selectManagerSearch(@RequestBody ManagerSearchReqBO managerSearchReqBO) {
        logger.debug("[\u5165\u53c2managerSearchReqBO]={}", (Object)managerSearchReqBO);
        Page page = new Page(managerSearchReqBO.getPageNo(), managerSearchReqBO.getPageSize());
        ArrayList<String> mOrgTreePath = new ArrayList<String>();
        if (managerSearchReqBO.getMgrUserId() != null) {
            List<OrganisationPO> mOrgList = this.organizationMapper.selectOrgBymUserId(managerSearchReqBO.getMgrUserId());
            for (OrganisationPO orgPO : mOrgList) {
                mOrgTreePath.add(orgPO.getOrgTreePath());
            }
            managerSearchReqBO.setMgrOrgTreePaths(mOrgTreePath);
        }
        List<OrgUser> orgUsers = this.userMapper.queryManager(managerSearchReqBO, (Page<Map<String, Object>>)page);
        orgUsers.forEach(orgUser -> {
            OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(orgUser.getOrgId());
            if (organisationPO != null) {
                OrganisationBO organisationBO = null;
                organisationBO = (OrganisationBO)BeanMapper.map((Object)organisationPO, OrganisationBO.class);
                String orgTreeName = this.selectOrgTreeNameService.selectOrgTreeName(organisationBO);
                orgUser.setOrgName(orgTreeName);
            }
        });
        RspPage result = new RspPage();
        result.setRows(orgUsers);
        result.setPageNo(managerSearchReqBO.getPageNo());
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        return result;
    }
}

