/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.QueryOrgTreePathByParentIdService;
import com.ohaotian.authority.po.OrganisationPO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.BuilderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.organisation.service.QueryOrgTreePathByParentIdService"})
public class QueryOrgTreePathByParentIdServiceImpl
implements QueryOrgTreePathByParentIdService {
    private static final Logger log = LoggerFactory.getLogger(QueryOrgTreePathByParentIdServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(QueryOrgTreePathByParentIdServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;

    @PostMapping(value={"queryOrgTreePathByParentId"})
    public List<OrganisationBO> queryOrgTreePathByParentId(@RequestBody OrganisationBO organisationBO) {
        if (organisationBO == null || organisationBO.getParentId() == null) {
            throw new BuilderException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<OrganisationPO> organisationPO = this.organizationMapper.selectOrgByPId(organisationBO);
        logger.debug("organisationPO={}", organisationPO);
        List<OrganisationBO> organisationBOList = this.convert(organisationPO);
        logger.debug("[\u8fd4\u56de\u6570\u636e],organisationBOList={}", organisationBOList);
        return organisationBOList;
    }

    private List<OrganisationBO> convert(List<OrganisationPO> organisationPOList) {
        return organisationPOList.stream().map(e -> {
            OrganisationBO organisationBO = new OrganisationBO();
            if (e != null) {
                BeanUtils.copyProperties((Object)e, (Object)organisationBO);
                organisationBO.setOrganisationId(e.getOrgId());
            }
            return organisationBO;
        }).collect(Collectors.toList());
    }
}

