/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.resourceTenant;

import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.ResourceTenantMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.ResourceTenantPO;
import com.ohaotian.authority.resourceTenant.bo.ResourceTenantReqBO;
import com.ohaotian.authority.resourceTenant.service.AuthResTenantAddService;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.resourceTenant.service.AuthResTenantAddService"})
public class AuthResTenantAddServiceImpl
implements AuthResTenantAddService {
    private static final Logger log = LoggerFactory.getLogger(AuthResTenantAddServiceImpl.class);
    @Autowired
    private ResourceTenantMapper resourceTenantMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private CreateOrganisationService createOrganisationService;

    @PostMapping(value={"addResTenant"})
    public RspBaseBO addResTenant(@RequestBody ResourceTenantReqBO reqBO) {
        int insert;
        Long orgId;
        RspBaseBO rspBO = new RspBaseBO();
        this.initParam(reqBO);
        Long resTenantId = Sequence.getInstance().nextId();
        OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(reqBO.getOrgIdWeb());
        OrganisationBO organisationBO = new OrganisationBO();
        Sequence sequence = Sequence.getInstance();
        long organisationId = sequence.nextId();
        organisationBO.setOrganisationId(Long.valueOf(organisationId));
        organisationBO.setParentId(reqBO.getOrgIdWeb());
        organisationBO.setTitle(reqBO.getResTenantName());
        organisationBO.setCreatTime(new Date());
        organisationBO.setField1(resTenantId.toString());
        if (organisationPO.getTenantId() != null) {
            organisationBO.setTenantId(organisationPO.getTenantId());
        }
        if ((orgId = this.createOrganisationService.createOrganisation(organisationBO)) == null) {
            throw new ZTBusinessException("\u673a\u6784\u8868\u65b0\u589e\u5931\u8d25");
        }
        ResourceTenantPO resourceTenantInfoPO = new ResourceTenantPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)resourceTenantInfoPO);
        resourceTenantInfoPO.setResTenantId(resTenantId);
        resourceTenantInfoPO.setCreateUserId(reqBO.getUserId());
        resourceTenantInfoPO.setCreateTime(new Date());
        resourceTenantInfoPO.setOrgIdWeb(organisationId);
        if (null == resourceTenantInfoPO.getStatus()) {
            resourceTenantInfoPO.setStatus(0);
        }
        if ((insert = this.resourceTenantMapper.insert(resourceTenantInfoPO)) < 1) {
            throw new ZTBusinessException("\u8d44\u6e90\u79df\u6237\u65b0\u589e\u5931\u8d25");
        }
        rspBO.setCode("0");
        rspBO.setMessage("\u8d44\u6e90\u79df\u6237\u65b0\u589e\u6210\u529f");
        return rspBO;
    }

    private void initParam(ResourceTenantReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getResTenantName()) {
            throw new ZTBusinessException("\u5165\u53c2\u8d44\u6e90\u79df\u6237\u540d\u79f0[resTenantName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrgIdWeb()) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784id[orgIdWeb]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

