/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.dao.OrgRoleMenuMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.po.OrgRoleMenuPO;
import com.ohaotian.authority.po.RoleAutoPO;
import com.ohaotian.authority.role.bo.SaveRoleConfigMenusReqBO;
import com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import com.ohaotian.plugin.db.Sequence;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService"})
public class SaveRoleConfigMenusBusiServiceImpl
implements SaveRoleConfigMenusBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveRoleConfigMenusBusiServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private OrgRoleMenuMapper orgRoleMenuMapper;

    @PostMapping(value={"saveRoleConfigMenus"})
    public void saveRoleConfigMenus(@RequestBody SaveRoleConfigMenusReqBO saveRoleConfigMenusReqBO) {
        String orgTreePath = saveRoleConfigMenusReqBO.getOrgTreePath();
        Long roleId = saveRoleConfigMenusReqBO.getRoleId();
        String configDetail = saveRoleConfigMenusReqBO.getConfigDetail();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.roleConfig(configDetail);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        for (Long add : adds) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            this.roleMapper.saveRoleAuto(l, roleId, add);
            if (!"auth:org:manage".equals(saveRoleConfigMenusReqBO.getAuthIdentity())) continue;
            OrgRoleMenuPO record = new OrgRoleMenuPO();
            record.setOrgTreePath(orgTreePath);
            record.setRoleAutoId(l);
            this.orgRoleMenuMapper.insert(record);
        }
        for (Long delete : deletes) {
            RoleAutoPO roleAutoPO;
            if ("auth:org:manage".equals(saveRoleConfigMenusReqBO.getAuthIdentity()) && (roleAutoPO = this.roleMapper.selectRoleAutoByRoleAndMenu(roleId, delete)) != null) {
                this.orgRoleMenuMapper.deleteByOrgAndRole(orgTreePath, roleAutoPO.getAuthId());
            }
            this.roleMapper.deleteRoleAuto(roleId, delete);
        }
    }
}

