/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.station.bo.StationForUserAuthReqBO;
import com.ohaotian.authority.station.service.SaveStationAuthorityService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import com.ohaotian.plugin.db.Sequence;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.station.service.SaveStationAuthorityService"})
public class SaveStationAuthorityServiceImpl
implements SaveStationAuthorityService {
    private static final Logger log = LoggerFactory.getLogger(SaveStationAuthorityServiceImpl.class);
    @Autowired
    StationMapper stationMapper;

    @Transactional
    @PostMapping(value={"saveStationConfig"})
    public void saveStationConfig(@RequestBody StationForUserAuthReqBO stationAuthorityReqBO) {
        Long stationId = stationAuthorityReqBO.getStationId();
        String json = stationAuthorityReqBO.getJson();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> adds = stringSetMap.get("add");
        Set<Long> deletes = stringSetMap.get("delete");
        for (Long add : adds) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            this.stationMapper.saveStationAuth(l, stationId, add);
        }
        for (Long delete : deletes) {
            this.stationMapper.deleteStationAuth(stationId, delete);
        }
    }
}

