/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrgTreeNameService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.Station;
import com.ohaotian.authority.station.bo.SelectStationByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationByIdRspBO;
import com.ohaotian.authority.station.bo.StationBO;
import com.ohaotian.authority.station.service.SelectStationByIdBusiService;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.plugin.common.util.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.station.service.SelectStationByIdBusiService"})
public class SelectStationByIdBusiServiceImpl
implements SelectStationByIdBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectStationByIdBusiServiceImpl.class);
    @Autowired
    private StationMapper stationMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectOrgTreeNameService selectOrgTreeNameService;

    @PostMapping(value={"selectStationById"})
    public SelectStationByIdRspBO selectStationById(@RequestBody SelectStationByIdReqBO selectStationByIdReqBO) {
        OrganisationPO organisationPO;
        TenantRspBO tenantRspBO;
        Long stationId = selectStationByIdReqBO.getStationId();
        Station station = this.stationMapper.selectByPrimaryKey(stationId);
        StationBO stationBO = new StationBO();
        if (station != null) {
            BeanUtils.copyProperties((Object)station, (Object)stationBO);
        }
        if ((tenantRspBO = this.tenantMapper.selectTenantById(station.getTenantId())) != null) {
            stationBO.setTenantName(tenantRspBO.getTenantName());
        }
        if ((organisationPO = this.organizationMapper.selectOrganisationByOrgId(station.getOrgId())) != null) {
            OrganisationBO organisationBO = null;
            organisationBO = (OrganisationBO)BeanMapper.map((Object)organisationPO, OrganisationBO.class);
            String orgTreeName = this.selectOrgTreeNameService.selectOrgTreeName(organisationBO);
            stationBO.setOrgName(orgTreeName);
        }
        SelectStationByIdRspBO selectStationByIdRspBO = new SelectStationByIdRspBO();
        selectStationByIdRspBO.setStationBO(stationBO);
        return selectStationByIdRspBO;
    }
}

