/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValReqBO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValRspBO;
import com.ohaotian.authority.dic.service.SelectDicBypDicValBusiService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.user.bo.SelectSearchByUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoSearchRspBO;
import com.ohaotian.authority.user.service.SelectSearchByUserInfoService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Page;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP/1.0.0/com.ohaotian.authority.user.service.SelectSearchByUserInfoService"})
public class SelectSearchByUserInfoServiceImpl
implements SelectSearchByUserInfoService {
    private static final Logger log = LoggerFactory.getLogger(SelectSearchByUserInfoServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private SelectDicBypDicValBusiService selectDicBypDicValBusiService;

    @PostMapping(value={"selectSearchByUserInfoService"})
    public RspPage<SelectUserInfoSearchRspBO> selectSearchByUserInfoService(@RequestBody SelectSearchByUserInfoReqBO selectSearchByUserInfoReqBO) {
        Page page = new Page(selectSearchByUserInfoReqBO.getPageNo(), selectSearchByUserInfoReqBO.getPageSize());
        List<UserPO> userPOS = this.userMapper.selectSearchByUser(selectSearchByUserInfoReqBO, (Page<Map<String, Object>>)page);
        List rspBOS = userPOS.stream().map(userPO -> {
            TenantRspBO tenantRspBO;
            OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(userPO.getOrgId());
            SelectUserInfoSearchRspBO rspBO = null;
            if (userPO != null) {
                rspBO = (SelectUserInfoSearchRspBO)BeanMapper.map((Object)userPO, SelectUserInfoSearchRspBO.class);
            }
            if (organisationPO != null) {
                rspBO.setTitle(organisationPO.getTitle());
                rspBO.setOrgTreePath(organisationPO.getOrgTreePath());
                rspBO.setOrgStatus(organisationPO.getStatus());
            }
            if (userPO.getTenantId() != null && (tenantRspBO = this.tenantMapper.selectTenantById(userPO.getTenantId())) != null) {
                rspBO.setTenantName(tenantRspBO.getTenantName());
                rspBO.setTenantStatus(tenantRspBO.getStatus());
            }
            SelectDicBypDicValReqBO selectDicBypDicValReqBO = new SelectDicBypDicValReqBO();
            selectDicBypDicValReqBO.setpDicVal(Constants.DICVAL_USER_TYPE);
            SelectDicBypDicValRspBO selectDicBypDicValRspBO = this.selectDicBypDicValBusiService.selectDicBypDicVal(selectDicBypDicValReqBO);
            Map dicMap = selectDicBypDicValRspBO.getDicMap();
            String typeName = "";
            if (dicMap != null) {
                typeName = (String)dicMap.get(userPO.getType());
            }
            rspBO.setTypeName(typeName);
            return rspBO;
        }).collect(Collectors.toList());
        RspPage result = new RspPage();
        result.setRows(rspBOS);
        result.setPageNo(selectSearchByUserInfoReqBO.getPageNo());
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        return result;
    }
}

