/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.tenant;

import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.tenant.bo.AppConfigBO;
import com.ohaotian.authority.tenant.bo.CreateTenantBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantReqBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.bo.TenantSearchPageReqBO;
import com.ohaotian.authority.tenant.service.CreateAppFroTenantService;
import com.ohaotian.authority.tenant.service.CreateTenantService;
import com.ohaotian.authority.tenant.service.DeleteTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectAppForTenantService;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectTenantPageService;
import com.ohaotian.authority.tenant.service.StopTenantByTenantIdService;
import com.ohaotian.authority.tenant.service.UpdateTenantByTenantIdService;
import com.ohaotian.authority.user.bo.SelectTenantListByUserIdReqBO;
import com.ohaotian.authority.user.service.SelectTenantListByUserIdService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.db.Sequence;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"}, method={RequestMethod.GET, RequestMethod.POST})
public class TenantController {
    private static final Logger logger = LoggerFactory.getLogger(TenantController.class);
    @Reference(interfaceClass=CreateTenantService.class, version="1.0.0", group="AUTH_GROUP")
    private CreateTenantService createTenantService;
    @Reference(interfaceClass=SelectTenantPageService.class, version="1.0.0", group="AUTH_GROUP")
    private SelectTenantPageService selectTenantPageService;
    @Reference(interfaceClass=DeleteTenantByIdService.class, version="1.0.0", group="AUTH_GROUP")
    private DeleteTenantByIdService deleteTenantByIdService;
    @Reference(interfaceClass=SelectTenantByIdService.class, version="1.0.0", group="AUTH_GROUP")
    private SelectTenantByIdService selectTenantByIdService;
    @Reference(interfaceClass=UpdateTenantByTenantIdService.class, version="1.0.0", group="AUTH_GROUP")
    private UpdateTenantByTenantIdService updateTenantByTenantIdService;
    @Reference(interfaceClass=CreateAppFroTenantService.class, version="1.0.0", group="AUTH_GROUP")
    private CreateAppFroTenantService createAppFroTenantService;
    @Reference(interfaceClass=SelectAppForTenantService.class, version="1.0.0", group="AUTH_GROUP")
    private SelectAppForTenantService selectAppForTenantService;
    @Reference(interfaceClass=SelectTenantListByUserIdService.class, version="1.0.0", group="AUTH_GROUP")
    private SelectTenantListByUserIdService selectTenantListByUserIdService;
    @Reference(interfaceClass=StopTenantByTenantIdService.class, version="1.0.0", group="AUTH_GROUP")
    private StopTenantByTenantIdService stopTenantByTenantIdService;

    @RequestMapping(value={"/create"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u65b0\u5efa")
    public Object create(CreateTenantBO createTenantBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        createTenantBO.setTenantId(Long.valueOf(l));
        this.createTenantService.insertTenant(createTenantBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object search(TenantSearchPageReqBO tenantSearchPageReqBO) {
        return this.selectTenantPageService.selectTenantPage(tenantSearchPageReqBO);
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(TenantIdBO tenantId) {
        try {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(tenantId.getTenantId());
            TenantRspBO rspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u79df\u6237", (Throwable)e);
        }
        this.deleteTenantByIdService.deleteTenantById(tenantId);
        return null;
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(TenantIdBO tenantIdBO) {
        return this.selectTenantByIdService.selectTenantById(tenantIdBO);
    }

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object add(TenantReqBO tenantReqBO) {
        try {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(tenantReqBO.getTenantId());
            TenantRspBO rspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u79df\u6237", (Throwable)e);
        }
        this.updateTenantByTenantIdService.updateTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(TenantIdBO tenantId) {
        TenantReqBO tenantReqBO = new TenantReqBO();
        tenantReqBO.setTenantId(tenantId.getTenantId());
        tenantReqBO.setStatus(Integer.valueOf(2));
        this.stopTenantByTenantIdService.stopTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/restart"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u542f\u7528")
    public Object restart(TenantIdBO tenantId) {
        TenantReqBO tenantReqBO = new TenantReqBO();
        tenantReqBO.setTenantId(tenantId.getTenantId());
        tenantReqBO.setStatus(Integer.valueOf(0));
        this.updateTenantByTenantIdService.updateTenantByTenantId(tenantReqBO);
        return null;
    }

    @RequestMapping(value={"/configApp"})
    @BusiResponseBody
    @BussinessLog(module="\u79df\u6237\u7ba1\u7406", operat="\u5b9a\u5236\u5b50\u7cfb\u7edf")
    public Object configApp(AppConfigBO appConfigForTenantReqBO) {
        this.createAppFroTenantService.createAppforTenant(appConfigForTenantReqBO);
        return null;
    }

    @RequestMapping(value={"/selectconfigApp"})
    @BusiResponseBody
    public Object selectconfigApp(TenantIdBO tenantIdBO) {
        return this.selectAppForTenantService.selectAppforTenant(tenantIdBO);
    }

    @RequestMapping(value={"/selectUserTenant"})
    @BusiResponseBody
    public Object selectUserTenant(@RequestParam(value="userId") String userId, SelectTenantListByUserIdReqBO selectTenantListByUserIdReqBO) {
        return this.selectTenantListByUserIdService.selectTenants(selectTenantListByUserIdReqBO);
    }
}

