/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.station;

import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.station.bo.DeleteStationSourceReqBO;
import com.ohaotian.authority.station.bo.SelectStaBusiByAppCodeReqBO;
import com.ohaotian.authority.station.bo.SelectStationBusinessPageReqBO;
import com.ohaotian.authority.station.bo.SelectStationBusinessReqBO;
import com.ohaotian.authority.station.bo.SelectStationBusinessRspBO;
import com.ohaotian.authority.station.bo.StationBusinessBO;
import com.ohaotian.authority.station.service.DeleteStationBusinessByIdService;
import com.ohaotian.authority.station.service.SaveStationBusinessBusiService;
import com.ohaotian.authority.station.service.SelectStaBusiByAppCodeService;
import com.ohaotian.authority.station.service.SelectStationBusinessPageService;
import com.ohaotian.authority.station.service.SelectStationBusinessService;
import com.ohaotian.authority.station.service.UpdateStationBusinessService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.db.Sequence;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stationBusiness"}, method={RequestMethod.GET, RequestMethod.POST})
public class StationBusinessController {
    private Logger logger = LoggerFactory.getLogger(StationBusinessController.class);
    @Reference(interfaceClass=SaveStationBusinessBusiService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SaveStationBusinessBusiService saveStationBusinessBusiService;
    @Reference(interfaceClass=SelectStationBusinessPageService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectStationBusinessPageService selectStationBusinessPageService;
    @Reference(interfaceClass=SelectStationBusinessService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectStationBusinessService selectStationBusinessService;
    @Reference(interfaceClass=UpdateStationBusinessService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private UpdateStationBusinessService updateStationBusinessService;
    @Reference(interfaceClass=SelectStaBusiByAppCodeService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectStaBusiByAppCodeService selectStaBusiByAppCodeService;
    @Reference(interfaceClass=DeleteStationBusinessByIdService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private DeleteStationBusinessByIdService deleteStationBusinessByIdService;

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(SelectStationBusinessReqBO selectStationBusinessReqBO) {
        return this.selectStationBusinessService.selectStationBusiness(selectStationBusinessReqBO);
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object search(SelectStationBusinessPageReqBO selectStationBusinessPageReqBO) {
        return this.selectStationBusinessPageService.selectStationBusinessPage(selectStationBusinessPageReqBO);
    }

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u4e1a\u52a1\u7ba1\u7406", operat="\u65b0\u589e")
    public Object save(StationBusinessBO stationBusinessBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        stationBusinessBO.setAuthId(Long.valueOf(l));
        this.saveStationBusinessBusiService.saveStationBusiness(stationBusinessBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u4e1a\u52a1\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(StationBusinessBO stationBusinessBO) {
        try {
            SelectStationBusinessReqBO reqBO = new SelectStationBusinessReqBO();
            reqBO.setBusinessId(stationBusinessBO.getAuthId());
            SelectStationBusinessRspBO rspBO = this.selectStationBusinessService.selectStationBusiness(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updateStationBusinessService.updateStationBusiness(stationBusinessBO);
        return null;
    }

    @RequestMapping(value={"/selectByAppCode"})
    @BusiResponseBody
    public Object selectByAppCode(SelectStaBusiByAppCodeReqBO selectStaBusiByAppCodeReqBO) {
        return this.selectStaBusiByAppCodeService.selectStaBusiByAppCode(selectStaBusiByAppCodeReqBO);
    }

    @RequestMapping(value={"/deleteById"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u4e1a\u52a1\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteById(DeleteStationSourceReqBO deleteStationSourceReqBO) {
        try {
            SelectStationBusinessReqBO reqBO = new SelectStationBusinessReqBO();
            reqBO.setBusinessId(deleteStationSourceReqBO.getAuthId());
            SelectStationBusinessRspBO rspBO = this.selectStationBusinessService.selectStationBusiness(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664", (Throwable)e);
        }
        this.deleteStationBusinessByIdService.deleteById(deleteStationSourceReqBO);
        return null;
    }
}

