/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.station;

import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.station.bo.DeleteStationSourceReqBO;
import com.ohaotian.authority.station.bo.SaveStationSourceReqBO;
import com.ohaotian.authority.station.bo.SelectByBusiCodeAndSourceTypeReqBO;
import com.ohaotian.authority.station.bo.SelectByBusiCodeReqBO;
import com.ohaotian.authority.station.bo.SelectStationSourceByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationSourcePageReqBO;
import com.ohaotian.authority.station.bo.UpdateStationSourceReqBO;
import com.ohaotian.authority.station.service.DeleteStationSourceByIdService;
import com.ohaotian.authority.station.service.SaveStationSourceService;
import com.ohaotian.authority.station.service.SelectByBusiCodeAndSourceTypeService;
import com.ohaotian.authority.station.service.SelectByBusiCodeService;
import com.ohaotian.authority.station.service.SelectStationSourceByIdService;
import com.ohaotian.authority.station.service.SelectStationSourcePageService;
import com.ohaotian.authority.station.service.UpdateStationSourceService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.db.Sequence;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stationSource"}, method={RequestMethod.GET, RequestMethod.POST})
public class StationSourceController {
    private Logger logger = LoggerFactory.getLogger(StationSourceController.class);
    @Reference(interfaceClass=SaveStationSourceService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SaveStationSourceService saveStationSourceService;
    @Reference(interfaceClass=SelectStationSourceByIdService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectStationSourceByIdService selectStationSourceByIdService;
    @Reference(interfaceClass=SelectStationSourcePageService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectStationSourcePageService selectStationSourcePageService;
    @Reference(interfaceClass=UpdateStationSourceService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private UpdateStationSourceService updateStationSourceService;
    @Reference(interfaceClass=SelectByBusiCodeService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectByBusiCodeService selectByBusiCodeService;
    @Reference(interfaceClass=SelectByBusiCodeAndSourceTypeService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectByBusiCodeAndSourceTypeService selectByBusiCodeAndSourceTypeService;
    @Reference(interfaceClass=DeleteStationSourceByIdService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private DeleteStationSourceByIdService deleteStationSourceByIdService;
    @Reference(interfaceClass=SelectByApplicationCodeBusiService.class, version="1.0.0", group="AUTH_GROUP_DEV")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u6570\u636e\u8d44\u6e90\u7ba1\u7406", operat="\u65b0\u589e")
    public Object saveStationSource(SaveStationSourceReqBO saveStationSourceReqBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        saveStationSourceReqBO.setAuthId(Long.valueOf(l));
        if (saveStationSourceReqBO.getShortCutUrl() != null) {
            SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
            selectByApplicationCodeReqBO.setApplicationCode("system");
            SelectByApplicationCodeRspBO selectByApplicationCodeRspBO = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
            ApplicationBO applicationBO = selectByApplicationCodeRspBO.getApplicationBO();
            String domain = applicationBO.getDomain();
            if (StringUtils.isNotEmpty((CharSequence)domain)) {
                String url = domain = domain.endsWith("/") ? domain : domain.concat("/");
                if (saveStationSourceReqBO.getShortCutUrl() == 1) {
                    url = url + "rest/authority/DataSourceTest/treeTest";
                    saveStationSourceReqBO.setDataType(Integer.valueOf(1));
                    saveStationSourceReqBO.setUrl(url);
                } else if (saveStationSourceReqBO.getShortCutUrl() == 2) {
                    url = url + "rest/authority/DataSourceTest/listTest";
                    saveStationSourceReqBO.setDataType(Integer.valueOf(3));
                    saveStationSourceReqBO.setUrl(url);
                }
            }
        }
        this.saveStationSourceService.saveStationSource(saveStationSourceReqBO);
        return null;
    }

    @RequestMapping(value={"/selectById"})
    @BusiResponseBody
    public Object selectById(SelectStationSourceByIdReqBO selectStationSourceByIdReqBO) {
        return this.selectStationSourceByIdService.selectStationSourceById(selectStationSourceByIdReqBO);
    }

    @RequestMapping(value={"/selectSourcePage"})
    @BusiResponseBody
    public Object selectStationSourcePage(SelectStationSourcePageReqBO selectStationSourcePageReqBO) {
        return this.selectStationSourcePageService.selectStationSourcePage(selectStationSourcePageReqBO);
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u6570\u636e\u8d44\u6e90\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateStationSource(UpdateStationSourceReqBO updateStationSourceReqBO) {
        this.updateStationSourceService.updateStationSource(updateStationSourceReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u6570\u636e\u8d44\u6e90\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteStationSource(DeleteStationSourceReqBO deleteStationSourceReqBO) {
        this.deleteStationSourceByIdService.deleteStationSourceById(deleteStationSourceReqBO);
        return null;
    }

    @RequestMapping(value={"/selectByBusiCode"})
    @BusiResponseBody
    public Object selectByBusiCode(SelectByBusiCodeReqBO selectByBusiCodeReqBO) {
        return this.selectByBusiCodeService.selectByBusiCode(selectByBusiCodeReqBO);
    }

    @RequestMapping(value={"/selectByBusiCodeAndSourceType"})
    @BusiResponseBody
    public Object selectByBusiCodeAndSourceType(SelectByBusiCodeAndSourceTypeReqBO reqBO) {
        return this.selectByBusiCodeAndSourceTypeService.selectByBusiCodeAndSourceType(reqBO);
    }
}

