/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.districts;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.districts.bo.RegionNameListReqBO;
import com.ohaotian.authority.districts.bo.SelectDistrictByIdReqBO;
import com.ohaotian.authority.districts.bo.SelectDistrictByIdRspBO;
import com.ohaotian.authority.districts.bo.SysAreaReqBO;
import com.ohaotian.authority.districts.service.AddDistrictsService;
import com.ohaotian.authority.districts.service.DeleteDistrictsService;
import com.ohaotian.authority.districts.service.SelectDistrictByIdService;
import com.ohaotian.authority.districts.service.SelectDistrictsService;
import com.ohaotian.authority.districts.service.SelectRegionNameListService;
import com.ohaotian.authority.districts.service.UpdateDistrictsService;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/districts"}, method={RequestMethod.GET, RequestMethod.POST})
public class DistrictsController {
    private static final Logger logger = LoggerFactory.getLogger(DistrictsController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectDistrictsService selectDistrictsService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private AddDistrictsService addDistrictsService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private UpdateDistrictsService updateDistrictsService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private DeleteDistrictsService deleteDistrictsService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectRegionNameListService selectRegionNameListService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectDistrictByIdService selectDistrictByIdService;

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object search(SysAreaReqBO sysAreaReqBO) {
        logger.debug("......" + sysAreaReqBO);
        return this.selectDistrictsService.findPage(sysAreaReqBO);
    }

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u884c\u653f\u533a\u5212\u7ba1\u7406", operat="\u65b0\u589e")
    public Object add(SysAreaReqBO sysAreaReqBO) {
        this.addDistrictsService.insert(sysAreaReqBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u884c\u653f\u533a\u5212\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(SysAreaReqBO sysAreaReqBO) {
        try {
            SelectDistrictByIdReqBO reqBO = new SelectDistrictByIdReqBO();
            reqBO.setId(sysAreaReqBO.getId());
            SelectDistrictByIdRspBO rspBO = this.selectDistrictByIdService.selectDistrict(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updateDistrictsService.update(sysAreaReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u884c\u653f\u533a\u5212\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            throw new ZTBusinessException("\u5165\u53c2\u884c\u653f\u533a\u5212ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List integers = JSON.parseArray((String)ids, Integer.class);
        this.deleteDistrictsService.delete(integers);
        return null;
    }

    @RequestMapping(value={"/qryRegNameByParent"})
    @BusiResponseBody
    public Object qryRegNameByParent(RegionNameListReqBO reqBO) {
        return this.selectRegionNameListService.selectRegNameList(reqBO);
    }

    @RequestMapping(value={"/selectById"})
    @BusiResponseBody
    public Object selectById(SelectDistrictByIdReqBO selectDistrictByIdReqBO) {
        return this.selectDistrictByIdService.selectDistrict(selectDistrictByIdReqBO);
    }
}

