/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.station;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.service.SelectOrgByMuserIdService;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.station.bo.ChangeStatusByStationIdReqBO;
import com.ohaotian.authority.station.bo.DeleteByStationIdReqBO;
import com.ohaotian.authority.station.bo.RestartByStationIdReqBO;
import com.ohaotian.authority.station.bo.SaveRoleStationsServiceReqBO;
import com.ohaotian.authority.station.bo.SaveStationReqBO;
import com.ohaotian.authority.station.bo.SaveStationRolesServiceReqBO;
import com.ohaotian.authority.station.bo.SelectDataIdsByBusiCodeWebReqBO;
import com.ohaotian.authority.station.bo.SelectStationAlreadyAndNorUserReqBO;
import com.ohaotian.authority.station.bo.SelectStationByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationByIdRspBO;
import com.ohaotian.authority.station.bo.SelectStationPageReqBO;
import com.ohaotian.authority.station.bo.SelectStationsByBusiCodeAndUserIdServiceReqBO;
import com.ohaotian.authority.station.bo.SelectUserByStationCodeReqBO;
import com.ohaotian.authority.station.bo.StationForUserAuthReqBO;
import com.ohaotian.authority.station.bo.UpdateStationByIdReqBO;
import com.ohaotian.authority.station.service.ChangeStatusByStationIdBusiService;
import com.ohaotian.authority.station.service.DeleteByStationIdBusiService;
import com.ohaotian.authority.station.service.RestartByStationIdBusiService;
import com.ohaotian.authority.station.service.SaveRoleStationsService;
import com.ohaotian.authority.station.service.SaveStationAuthorityService;
import com.ohaotian.authority.station.service.SaveStationBusiService;
import com.ohaotian.authority.station.service.SaveStationRolesService;
import com.ohaotian.authority.station.service.SelectAllUserByStationIdService;
import com.ohaotian.authority.station.service.SelectAlreadyUserByStationIdService;
import com.ohaotian.authority.station.service.SelectDataIdsByBusiCodeWebService;
import com.ohaotian.authority.station.service.SelectStationByIdBusiService;
import com.ohaotian.authority.station.service.SelectStationsByBusiCodeAndUserIdService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiByOrgService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiByTowAdminService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiService;
import com.ohaotian.authority.station.service.SelectUserByStationCodeService;
import com.ohaotian.authority.station.service.UpdateStationByIdBusiService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.ListUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/station"}, method={RequestMethod.GET, RequestMethod.POST})
public class StationController {
    private Logger logger = LoggerFactory.getLogger(StationController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectStationsPageBusiService selectStationsPageBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectStationByIdBusiService selectStationByIdBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SaveStationBusiService saveStationBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private UpdateStationByIdBusiService updateStationByIdBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private ChangeStatusByStationIdBusiService changeStatusByStationIdBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private DeleteByStationIdBusiService deleteByStationIdBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private RestartByStationIdBusiService restartByStationIdBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectStationsPageBusiByTowAdminService selectStationsPageBusiByTowAdminService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectAllUserByStationIdService selectAllUserByStationIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectAlreadyUserByStationIdService selectAlreadyUserByStationIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SaveStationAuthorityService saveStationAuthorityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectUserByStationCodeService selectUserByStationCodeService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectDataIdsByBusiCodeWebService selectDataIdsByBusiCodeWebService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectOrgByMuserIdService selectOrgByMuserIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectStationsPageBusiByOrgService selectStationsPageBusiByOrgService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectStationsByBusiCodeAndUserIdService selectStationsByBusiCodeAndUserIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SaveRoleStationsService saveRoleStationsService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SaveStationRolesService saveStationRolesService;

    @RequestMapping(value={"/selectStationPage"})
    @BusiResponseBody
    public Object selectStationPage(SelectStationPageReqBO reqPageBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectStationsPageBusiService.selectstationPage(reqPageBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectStationsPageBusiByTowAdminService.selectStationPageByTwoAdmin(reqPageBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            Long userId = currentUser.getUserId();
            SelectOrgByMuserIdReqBO selectOrgByMuserIdReqBO = new SelectOrgByMuserIdReqBO();
            selectOrgByMuserIdReqBO.setmUserId(userId);
            SelectOrgByMuserIdRspBO select1 = this.selectOrgByMuserIdService.selectOrgByMuserId(selectOrgByMuserIdReqBO);
            if (select1 == null || select1.getTreePathRspBOS() == null || select1.getTreePathRspBOS().size() == 0) {
                throw new ZTBusinessException("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u7406\u7684\u7ec4\u7ec7\u673a\u6784");
            }
            ArrayList<String> orgTreePaths = new ArrayList<String>();
            List treePathRspBOS = select1.getTreePathRspBOS();
            for (TreePathRspBO BO : treePathRspBOS) {
                String orgTreePath = BO.getOrgTreePath();
                orgTreePaths.add(orgTreePath);
            }
            reqPageBO.setOrgTreePaths(orgTreePaths);
            return this.selectStationsPageBusiByOrgService.selectStationsPageBusiByOrg(reqPageBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectById"})
    @BusiResponseBody
    public Object selectById(SelectStationByIdReqBO selectStationByIdReqBO) {
        return this.selectStationByIdBusiService.selectStationById(selectStationByIdReqBO);
    }

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u65b0\u589e")
    public Object save(SaveStationReqBO saveStationReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u65b0\u589e\uff01");
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        saveStationReqBO.setStationId(Long.valueOf(l));
        this.saveStationBusiService.saveStation(saveStationReqBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(UpdateStationByIdReqBO updateStationByIdReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u7f16\u8f91\uff01");
        }
        try {
            SelectStationByIdReqBO reqBO = new SelectStationByIdReqBO();
            reqBO.setStationId(updateStationByIdReqBO.getStationId());
            SelectStationByIdRspBO rspBO = this.selectStationByIdBusiService.selectStationById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updateStationByIdBusiService.updateStationById(updateStationByIdReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteByStationId"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u505c\u7528")
    public Object deleteByStationId(String stationIds) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u505c\u7528\uff01");
        }
        List longList = JSON.parseArray((String)stationIds, Long.class);
        ChangeStatusByStationIdReqBO changeStatusByStationIdReqBO = new ChangeStatusByStationIdReqBO();
        changeStatusByStationIdReqBO.setStationIds(longList);
        changeStatusByStationIdReqBO.setStatus(Integer.valueOf(1));
        this.changeStatusByStationIdBusiService.changeStatusByStationId(changeStatusByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/phydeleteByStationId"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u5220\u9664")
    public Object phydeleteByStationId(String stationIds) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u5220\u9664\uff01");
        }
        List longList = JSON.parseArray((String)stationIds, Long.class);
        DeleteByStationIdReqBO deleteByStationIdReqBO = new DeleteByStationIdReqBO();
        deleteByStationIdReqBO.setStationIds(longList);
        this.deleteByStationIdBusiService.deleteByStationId(deleteByStationIdReqBO);
        return null;
    }

    @PostMapping(value={"/restartStation"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u542f\u7528")
    public Object restartRole(RestartByStationIdReqBO restartByStationIdReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u542f\u7528\uff01");
        }
        this.restartByStationIdBusiService.restartByStationId(restartByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/listReOpenByStationId"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u6279\u91cf\u542f\u7528")
    public Object listReOpenByStationId(String stationIds) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u6279\u91cf\u542f\u7528\uff01");
        }
        List longList = JSON.parseArray((String)stationIds, Long.class);
        ChangeStatusByStationIdReqBO changeStatusByStationIdReqBO = new ChangeStatusByStationIdReqBO();
        changeStatusByStationIdReqBO.setStationIds(longList);
        changeStatusByStationIdReqBO.setStatus(Integer.valueOf(0));
        this.changeStatusByStationIdBusiService.changeStatusByStationId(changeStatusByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/distributeUser"})
    @BusiResponseBody
    public Object distributeUser(SelectStationAlreadyAndNorUserReqBO reqBO) {
        if (reqBO.getOrgId() == null || reqBO.getStationId() == null) {
            throw new ZTBusinessException("\u673a\u6784Id\u6216\u5c97\u4f4dId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HasUserListBO allUserListBO = this.selectAllUserByStationIdService.selectAllUserByStationId(reqBO);
        List user = allUserListBO.getAllUser();
        List allUser = ListUtils.copyListProperties((List)user, UserBO.class);
        HasUserListBO alreadyuserListBO = this.selectAlreadyUserByStationIdService.selectAlreadyUser(reqBO);
        List alreadyUser = alreadyuserListBO.getAllUser();
        allUser.removeAll(alreadyUser);
        user.removeAll(allUser);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(user);
        orgDistributeRspBO.setNotGrantRoles(allUser);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/stationAuth"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ba1\u7406", operat="\u7528\u6237\u6388\u6743")
    public Object savestationAuth(StationForUserAuthReqBO reqBO) {
        this.saveStationAuthorityService.saveStationConfig(reqBO);
        return null;
    }

    @RequestMapping(value={"/selectByStationCode"})
    @BusiResponseBody
    public Object selectByStationCode(SelectUserByStationCodeReqBO reqBO) {
        return this.selectUserByStationCodeService.selectUsersByStationCode(reqBO);
    }

    @RequestMapping(value={"/selectDataIdsByBusiCode"})
    @BusiResponseBody
    public Object selectDataIdsByBusiCode(SelectDataIdsByBusiCodeWebReqBO selectDataIdsByBusiCodeWebReqBO) {
        return this.selectDataIdsByBusiCodeWebService.selectDataIdsByBusiCodeWeb(selectDataIdsByBusiCodeWebReqBO);
    }

    @RequestMapping(value={"/selectStationsByBusiCodeAndUserId"})
    @BusiResponseBody
    public Object selectStationsByBusiCodeAndUserId(SelectStationsByBusiCodeAndUserIdServiceReqBO reqBO) {
        return this.selectStationsByBusiCodeAndUserIdService.selectStationsByBusiCodeAndUserId(reqBO);
    }

    @RequestMapping(value={"/saveRoleStations"})
    @BusiResponseBody
    public Object saveRoleStations(SaveRoleStationsServiceReqBO reqBO) {
        this.saveRoleStationsService.saveRoleStations(reqBO);
        return null;
    }

    @RequestMapping(value={"/saveStationRoles"})
    @BusiResponseBody
    public Object saveStationRoles(SaveStationRolesServiceReqBO reqBO) {
        this.saveStationRolesService.saveStationRoles(reqBO);
        return null;
    }
}

