/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.user;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.logger.bo.SaveLoginLogReqBO;
import com.ohaotian.authority.logger.service.SaveLoginLogBusiService;
import com.ohaotian.authority.manager.bo.UpdateManagerOrgReqBO;
import com.ohaotian.authority.manager.service.UpdateManagerOrgService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathReqBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.bo.SelectUserRolesReqBO;
import com.ohaotian.authority.role.service.SelectOverallRoleService;
import com.ohaotian.authority.role.service.SelectRolesByOrgTreePathBusiService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.role.service.SelectUserRolesBusiService;
import com.ohaotian.authority.station.bo.SelectUserStationWebReqBO;
import com.ohaotian.authority.station.service.SelectUserStaionByUserIdWebService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.bo.AddUserWebReqBO;
import com.ohaotian.authority.user.bo.ChangePwdIsOrNotReqBO;
import com.ohaotian.authority.user.bo.ChangePwdReqBO;
import com.ohaotian.authority.user.bo.ChangePwdWebReqBO;
import com.ohaotian.authority.user.bo.DeleteUserReqBO;
import com.ohaotian.authority.user.bo.InsertExtUserConditionWebReqBO;
import com.ohaotian.authority.user.bo.LoginNameBO;
import com.ohaotian.authority.user.bo.OAuth2UserInfoReqBO;
import com.ohaotian.authority.user.bo.OAuth2UserInfoRspBO;
import com.ohaotian.authority.user.bo.QryVerifyCodePictureReqBO;
import com.ohaotian.authority.user.bo.RegIndividualUserWebReqBO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserReqBO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserRspBO;
import com.ohaotian.authority.user.bo.SaveUserDefaultAppReqBO;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.bo.SelectExtUserIdWebReqBO;
import com.ohaotian.authority.user.bo.SelectPublicUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectSearchByUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserByCellphoneReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameReqBO;
import com.ohaotian.authority.user.bo.SelectUserByRoleAndOrgWebReqBO;
import com.ohaotian.authority.user.bo.SelectUserDefaultAppReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoSearchRspBO;
import com.ohaotian.authority.user.bo.SelectUserOrgAndAuthIdentityPageWebReqBO;
import com.ohaotian.authority.user.bo.SelectUserOrgAndAuthIdentityWebReqBO;
import com.ohaotian.authority.user.bo.UpdatePersonCellPhoneNullReqBO;
import com.ohaotian.authority.user.bo.UpdatePublicUserBOReq;
import com.ohaotian.authority.user.bo.UpdateUserBOReq;
import com.ohaotian.authority.user.bo.UpdateUserInfoByRecReqBO;
import com.ohaotian.authority.user.bo.UserAuthReqBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.bo.UserParentIdOrgReqBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.user.service.AddPortalUserWebService;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.authority.user.service.ChangePwdByUserIdWebService;
import com.ohaotian.authority.user.service.ChangePwdOfExpireService;
import com.ohaotian.authority.user.service.DeleteUserService;
import com.ohaotian.authority.user.service.GetUserCountService;
import com.ohaotian.authority.user.service.InsertExtUserConditionWebService;
import com.ohaotian.authority.user.service.QryVerifyCodePictureService;
import com.ohaotian.authority.user.service.RegIndividualUserOAuth2WebService;
import com.ohaotian.authority.user.service.RegisterIndividualUserOAuth2Service;
import com.ohaotian.authority.user.service.ReopenUserStatusByUserIdService;
import com.ohaotian.authority.user.service.ResetPasswordService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.user.service.SaveUserDefaultAppService;
import com.ohaotian.authority.user.service.SelectExtUserIdWebService;
import com.ohaotian.authority.user.service.SelectPublicUserInfoService;
import com.ohaotian.authority.user.service.SelectSearchByUserInfoService;
import com.ohaotian.authority.user.service.SelectUserAlreadyAuthRolesService;
import com.ohaotian.authority.user.service.SelectUserByCellphoneService;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.authority.user.service.SelectUserByRoleAndOrgWebService;
import com.ohaotian.authority.user.service.SelectUserDefaultAppService;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.authority.user.service.SelectUserIdByOAuth2Service;
import com.ohaotian.authority.user.service.SelectUserNameServer;
import com.ohaotian.authority.user.service.SelectUserOrgAndAuthIdentityWebService;
import com.ohaotian.authority.user.service.SelectUserStaionByUserIdService;
import com.ohaotian.authority.user.service.StopUserStatusByUserIdService;
import com.ohaotian.authority.user.service.UpdatePersonCellPhoneNullService;
import com.ohaotian.authority.user.service.UpdatePublicUserService;
import com.ohaotian.authority.user.service.UpdateUserInfoByRecWebService;
import com.ohaotian.authority.user.service.UpdateUserService;
import com.ohaotian.authority.user.service.UserParentIdOrgService;
import com.ohaotian.authority.utils.AesUtil;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.ReqInfo;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.IPUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;

@RestController
@RequestMapping(value={"/user"}, method={RequestMethod.GET, RequestMethod.POST})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private SelectSearchByUserInfoService selectSearchByUserInfoService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;
    @Autowired
    private UpdateUserService updateUserService;
    @Autowired
    private StopUserStatusByUserIdService stopUserStatusByUserIdService;
    @Autowired
    private ReopenUserStatusByUserIdService reopenUserStatusByUserIdService;
    @Autowired
    private ResetPasswordService resetPasswordService;
    @Autowired
    private AddManageUserService addManageUserService;
    @Autowired
    private UserParentIdOrgService userParentIdOrgService;
    @Autowired
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Autowired
    private SelectUserAlreadyAuthRolesService selectUserAlreadyAuthRolesService;
    @Autowired
    private SaveUserAuthService saveUserAuthService;
    @Autowired
    private SelectUserRolesBusiService selectUserRolesBusiService;
    @Autowired
    private UpdateManagerOrgService updateManagerOrgService;
    @Autowired
    private SelectUserNameServer selectUserNameServer;
    @Autowired
    private DeleteUserService deleteUserService;
    @Autowired
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private ChangePwdByUserIdService changePwdByUserIdService;
    @Autowired
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Autowired
    private SelectUserStaionByUserIdService selectUserStaionByUserIdService;
    @Autowired
    private RegisterIndividualUserOAuth2Service registerIndividualUserService;
    @Autowired
    private SelectUserIdByOAuth2Service selectUserIdByOAuth2Service;
    @Autowired
    private SelectExtUserIdWebService selectExtUserIdWebService;
    @Autowired
    private SaveLoginLogBusiService saveLoginLogBusiService;
    @Autowired
    private SelectUserByCellphoneService selectUserByCellphoneService;
    @Autowired
    private InsertExtUserConditionWebService insertExtUserConditionWebService;
    @Autowired
    private RegIndividualUserOAuth2WebService regIndividualUserOAuth2WebService;
    @Autowired
    private SelectPublicUserInfoService selectPublicUserInfoService;
    @Autowired
    private UpdatePublicUserService updatePublicUserService;
    @Autowired
    private UpdatePersonCellPhoneNullService updatePersonCellPhoneNullService;
    @Autowired
    private UpdateUserInfoByRecWebService updateUserInfoByRecWebService;
    @Autowired
    private SelectRolesByOrgTreePathBusiService selectRolesByOrgTreePathBusiService;
    @Autowired
    private AddPortalUserWebService addPortalUserWebService;
    @Autowired
    private GetUserCountService getUserCountService;
    @Autowired
    private ChangePwdByUserIdWebService changePwdByUserIdWebService;
    @Autowired
    private ChangePwdOfExpireService changePwdOfExpireService;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${redis.database:2}")
    private int redisDatabase;
    @Autowired
    private SelectOverallRoleService selectOverallRoleService;
    @Autowired
    private SelectUserDefaultAppService selectUserDefaultAppService;
    @Autowired
    private SaveUserDefaultAppService saveUserDefaultAppService;
    @Autowired
    private QryVerifyCodePictureService qryVerifyCodePictureService;
    @Autowired
    private SelectUserByRoleAndOrgWebService selectUserByRoleAndOrgWebService;
    @Autowired
    private SelectUserOrgAndAuthIdentityWebService SelectUserOrgAndAuthIdentityWebService;
    @Autowired
    private SelectUserStaionByUserIdWebService selectUserStaionByUserIdWebService;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object selectSearchByUserInfoService(SelectSearchByUserInfoReqBO selectSearchByUserInfoReqBO) {
        LinkedList<String> typeList = new LinkedList<String>();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            typeList.add("auth:overall:manage");
            typeList.add("auth:tenant:manage");
            typeList.add("auth:org:manage");
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            typeList.add("auth:tenant:manage");
            typeList.add("auth:org:manage");
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage") || SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            typeList.add("auth:default:manage");
            typeList.add("auth:org:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
            RspPage orgUser = this.selectSearchByUserInfoService.selectSearchByUserInfoService(selectSearchByUserInfoReqBO);
            ArrayList<SelectUserInfoSearchRspBO> selectUserInfoSearchRspBO = new ArrayList<SelectUserInfoSearchRspBO>();
            for (SelectUserInfoSearchRspBO sOrgUser : orgUser.getRows()) {
                if (currentUser.getUserId().equals(sOrgUser.getUserId())) continue;
                selectUserInfoSearchRspBO.add(sOrgUser);
            }
            orgUser.setRows(selectUserInfoSearchRspBO);
            return orgUser;
        }
        return this.selectSearchByUserInfoService.selectSearchByUserInfoService(selectSearchByUserInfoReqBO);
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(UserIdBO userIdBO) {
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        return selectUserInfoRspBO;
    }

    @RequestMapping(value={"/getUserInfo"})
    @BusiResponseBody
    public Object getUserInfo() {
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        UserInfo user = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(user.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            resMap.put("loginName", selectUserInfoRspBO.getLoginName());
            resMap.put("name", selectUserInfoRspBO.getName());
            resMap.put("cellPhone", selectUserInfoRspBO.getCellPhone());
            resMap.put("email", selectUserInfoRspBO.getEmail());
        }
        if (user.getOrgId() != null) {
            OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
            organisationIdReqBO.setOrganisationId(user.getOrgId());
            RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
            if (organisationBO != null) {
                resMap.put("orgName", organisationBO.getTitle());
            }
        } else {
            resMap.put("orgName", "");
        }
        if (user.getTenantId() != null) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(user.getTenantId());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                resMap.put("tenantName", tenantRspBO.getTenantName());
            }
        } else {
            resMap.put("tenantName", "");
        }
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }

    @RequestMapping(value={"/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateUserByUserId(UpdateUserBOReq updateUserBOReq) {
        try {
            UserIdBO reqBo = new UserIdBO();
            reqBo.setUserId(updateUserBOReq.getUserIdReq());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(reqBo);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        this.updateUserService.updateUserByUserId(updateUserBOReq);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(UserIdBO userIdBO) {
        this.stopUserStatusByUserIdService.stopUserStatusByUserId(userIdBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(UserIdBO userIdBO) {
        this.reopenUserStatusByUserIdService.reopenUserStatusByUserId(userIdBO);
        return null;
    }

    @RequestMapping(value={"/reset"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u91cd\u7f6e\u5bc6\u7801")
    public Object reset(String userId) {
        List userIds = JSON.parseArray((String)userId, Long.class);
        this.resetPasswordService.resetPasswordByUserId(userIds);
        for (Long userIdReq : userIds) {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(userIdReq);
            SelectUserInfoRspBO userRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            Jedis resource = this.cacheClient.getJedisPool().getResource();
            String select = resource.select(this.redisDatabase);
            resource.del("cas" + userRspBO.getLoginName());
            resource.close();
        }
        return null;
    }

    @RequestMapping(value={"/add/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u65b0\u589e")
    public Object commit(AddUserReqBO addUserReqBO) {
        addUserReqBO.setDetialSource("00");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserReqBO.getNameReq()})) {
            try {
                addUserReqBO.setName(new String(addUserReqBO.getNameReq().getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if ("auth:overall:manage".equals(addUserReqBO.getType())) {
            addUserReqBO.setOrgIdReq(null);
            addUserReqBO.setTenantIdReq(null);
        } else if ("auth:tenant:manage".equals(addUserReqBO.getType())) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(addUserReqBO.getTenantIdReq());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                addUserReqBO.setmOrgId(tenantRspBO.getOrgRootId());
            }
        }
        if (!StringUtils.isEmpty((CharSequence)addUserReqBO.getPasswordReq())) {
            logger.debug("\u65b0\u5bc6\u7801\u5bc6\u6587:{}", (Object)addUserReqBO.getPasswordReq());
            logger.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
            String newPwd = AesUtil.decryptStr(addUserReqBO.getPasswordReq(), this.ORIGINAL_KEY);
            logger.debug("\u65b0\u5bc6\u7801\u660e\u6587:{}", (Object)newPwd);
            if (StringUtils.isEmpty((CharSequence)newPwd)) {
                throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u79d8\u94a5\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u5bc6");
            }
            addUserReqBO.setPasswordReq(newPwd);
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        addUserReqBO.setAuthUserId(Long.valueOf(l));
        addUserReqBO.setRegisterType("register:personal");
        this.addManageUserService.insertUser(addUserReqBO);
        return l;
    }

    @RequestMapping(value={"/add/commit/select"})
    @BusiResponseBody
    public Object selectUserName(LoginNameBO loginNameBO) {
        return this.selectUserNameServer.selectUserNameByLoginName(loginNameBO);
    }

    @PostMapping(value={"/add/tree"})
    @BusiResponseBody
    public Object tree(UserParentIdOrgReqBO userParentIdOrgReqBO) {
        return this.userParentIdOrgService.selectUserParentIdOrg(userParentIdOrgReqBO);
    }

    @RequestMapping(value={"/authUser"})
    @BusiResponseBody
    public Object authUser(UserAuthReqBO userAuthReqBO) {
        logger.info("com.ohaotian.authority.controller.user.UserController.authUser:" + JSON.toJSONString((Object)userAuthReqBO));
        List userOperateRoles = new ArrayList();
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            SelectRolesByOrgTreePathReqBO selectRolesByOrgTreePathReqBO = new SelectRolesByOrgTreePathReqBO();
            BeanUtils.copyProperties((Object)userAuthReqBO, (Object)selectRolesByOrgTreePathReqBO);
            selectRolesByOrgTreePathReqBO.setOrgTreePath(userAuthReqBO.getManaOrgTreePath());
            SelectRolesByOrgTreePathRspBO overallRole = this.selectOverallRoleService.overallRole(selectRolesByOrgTreePathReqBO);
            SelectRolesByOrgTreePathRspBO select = this.selectRolesByOrgTreePathBusiService.select(selectRolesByOrgTreePathReqBO);
            if (!CollectionUtils.isEmpty((Collection)select.getHasGrantRoles())) {
                userOperateRoles.addAll(select.getHasGrantRoles());
            }
            if (!CollectionUtils.isEmpty((Collection)overallRole.getHasGrantRoles())) {
                userOperateRoles.addAll(overallRole.getHasGrantRoles());
            }
        } else {
            SelectUserOperateRolesReqBO operateRolesReqBO = new SelectUserOperateRolesReqBO();
            BeanUtils.copyProperties((Object)userAuthReqBO, (Object)operateRolesReqBO);
            operateRolesReqBO.setPrarmUserId(userAuthReqBO.getPrarmUserId());
            SelectUserOperateRolesRspBO selectUserOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(operateRolesReqBO);
            userOperateRoles = selectUserOperateRolesRspBO.getUserOperateRoles();
        }
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectUserAlreadyAuthRolesService.selectOrgAlreadyRoles(userAuthReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        logger.info("com.ohaotian.authority.controller.user.UserController.userOperateRoles:" + JSON.toJSONString(userOperateRoles));
        userOperateRoles.removeAll(hasGrantRoles);
        logger.info("com.ohaotian.authority.controller.user.UserController.userOperateRoles:" + JSON.toJSONString(userOperateRoles));
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        if (userOperateRoles != null) {
            orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        } else {
            orgDistributeRspBO.setNotGrantRoles(new ArrayList());
        }
        logger.info("com.ohaotian.authority.controller.user.UserController.orgDistributeRspBO:" + JSON.toJSONString((Object)orgDistributeRspBO));
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/authUserCommit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u6388\u6743")
    public Object authUserCommit(SaveUserRolesAuthReqBO saveUserRolesAuthReqBO) {
        if (StringUtils.isEmpty((CharSequence)saveUserRolesAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (saveUserRolesAuthReqBO.getUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.saveUserAuthService.saveUserAuthService(saveUserRolesAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/selectUserRoles"})
    @BusiResponseBody
    public Object selectUserRoles(SelectUserRolesReqBO userRolesReqBO) {
        return this.selectUserRolesBusiService.selectUserRoles(userRolesReqBO);
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Object updateManagerService(UpdateManagerOrgReqBO updateManagerOrgReqBO) {
        this.updateManagerOrgService.updateManager(updateManagerOrgReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteUser(DeleteUserReqBO deleteUserReqBO) {
        try {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(deleteUserReqBO.getUserId());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        this.deleteUserService.deleteUserByUserId(deleteUserReqBO);
        return null;
    }

    @RequestMapping(value={"/changeUserPwd"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u4fee\u6539\u5bc6\u7801")
    public Object changeUserPwd(ChangePwdReqBO changePwdReqBO) {
        logger.debug("\u65b0\u5bc6\u7801\u5bc6\u6587:{}", (Object)changePwdReqBO.getNewPassword());
        logger.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
        String newPwd = AesUtil.decryptStr(changePwdReqBO.getNewPassword(), this.ORIGINAL_KEY);
        logger.debug("\u65b0\u5bc6\u7801\u660e\u6587:{}", (Object)newPwd);
        if (StringUtils.isEmpty((CharSequence)newPwd)) {
            throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u79d8\u94a5\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u5bc6");
        }
        changePwdReqBO.setNewPassword(newPwd);
        logger.debug("\u65b0\u5bc6\u7801\u5bc6\u6587:{}", (Object)changePwdReqBO.getOldPassword());
        logger.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
        String oldPwd = AesUtil.decryptStr(changePwdReqBO.getOldPassword(), this.ORIGINAL_KEY);
        logger.debug("\u65b0\u5bc6\u7801\u660e\u6587:{}", (Object)oldPwd);
        if (StringUtils.isEmpty((CharSequence)oldPwd)) {
            throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u79d8\u94a5\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u5bc6");
        }
        changePwdReqBO.setOldPassword(oldPwd);
        this.changePwdByUserIdService.changePasswordByUserId(changePwdReqBO);
        Jedis resource = this.cacheClient.getJedisPool().getResource();
        String select = resource.select(this.redisDatabase);
        resource.del("cas" + SecurityHelper.getCurrentUser().getUsername());
        resource.close();
        return null;
    }

    @RequestMapping(value={"/checkLoginName"})
    @BusiResponseBody
    public Object checkLoginName(@RequestParam String username, @RequestParam String password, @RequestParam(required=false) String type, SelectUserByLoginNameReqBO selectUserByLoginNameReqBO) {
        return this.selectUserByLoginNameService.selectUserByLoginNameService(selectUserByLoginNameReqBO);
    }

    @RequestMapping(value={"/selectUserStation"})
    @BusiResponseBody
    public Object selectUserStation(UserIdBO userId) {
        return this.selectUserStaionByUserIdService.selectUserStation(userId);
    }

    @RequestMapping(value={"/registerIndividualUser"})
    @BusiResponseBody
    public Object registerIndividualUser(@RequestParam(required=false) String name, @RequestParam(required=false) String loginName, RegisterIndividualUserReqBO reqBO) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
            try {
                reqBO.setName(new String(name.getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName})) {
            try {
                reqBO.setLoginName(new String(loginName.getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Sequence sequence = Sequence.getInstance();
        long id = sequence.nextId();
        reqBO.setUserId(Long.valueOf(id));
        RegisterIndividualUserRspBO rspBO = this.registerIndividualUserService.registerIndividualUser(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/getUserIdByOAuth2"})
    @BusiResponseBody
    public Object registerIndividualUser(OAuth2UserInfoReqBO reqBO) {
        OAuth2UserInfoRspBO rspBO = this.selectUserIdByOAuth2Service.selectUserIdByOAuth2(reqBO);
        if (rspBO.getUserId() != null) {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(rspBO.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            SaveLoginLogReqBO saveLoginLogReqBO = new SaveLoginLogReqBO();
            saveLoginLogReqBO.setLoginName(selectUserInfoRspBO.getLoginName());
            saveLoginLogReqBO.setMacInfo("\u767b\u5f55\u6210\u529f");
            this.saveLoginLogBusiService.saveLoginLog(saveLoginLogReqBO);
        }
        return rspBO;
    }

    @RequestMapping(value={"/selectExtUserId"})
    @BusiResponseBody
    public Object selectExtUserId(SelectExtUserIdWebReqBO reqBO) {
        return this.selectExtUserIdWebService.selectExtUserId(reqBO);
    }

    @RequestMapping(value={"/selPersonUserByPhone"})
    @BusiResponseBody
    public Object selPersonUserByPhone(SelectUserByCellphoneReqBO selectUserByCellphoneReqBO) {
        return this.selectUserByCellphoneService.selectUserByCellphone(selectUserByCellphoneReqBO);
    }

    @RequestMapping(value={"/insertExtUserCondition"})
    @BusiResponseBody
    public Object insertExtUserCondition(InsertExtUserConditionWebReqBO insertExtUserConditionWebReqBO) {
        this.insertExtUserConditionWebService.insertExtUserConditionWeb(insertExtUserConditionWebReqBO);
        return null;
    }

    @RequestMapping(value={"/regIndividualUserOAuth2Web"})
    @BusiResponseBody
    public Object regIndividualUserOAuth2Web(RegIndividualUserWebReqBO regIndividualUserWebReqBO) {
        if (StringUtils.isNotEmpty((CharSequence)regIndividualUserWebReqBO.getName())) {
            try {
                regIndividualUserWebReqBO.setName(new String(regIndividualUserWebReqBO.getName().getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)regIndividualUserWebReqBO.getLoginName())) {
            try {
                regIndividualUserWebReqBO.setLoginName(new String(regIndividualUserWebReqBO.getLoginName().getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.regIndividualUserOAuth2WebService.registerIndividualUser(regIndividualUserWebReqBO);
    }

    @RequestMapping(value={"/selectPublicUser"})
    @BusiResponseBody
    public Object selectPublicUser(SelectPublicUserInfoReqBO reqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectPublicUserInfoService.selectPublicUserInfo(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/publicCommit"})
    @BusiResponseBody
    @BussinessLog(module="\u516c\u4f17\u7528\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updatePublicUserByUserId(UpdatePublicUserBOReq updatePublicUserBOReq) {
        try {
            UserIdBO reqBo = new UserIdBO();
            reqBo.setUserId(updatePublicUserBOReq.getUserIdReq());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(reqBo);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updatePublicUserService.updatePublicUser(updatePublicUserBOReq);
        return null;
    }

    @RequestMapping(value={"/updatePersonCellPhoneNull"})
    @BusiResponseBody
    public Object updatePersonCellPhoneNull(UpdatePersonCellPhoneNullReqBO updatePersonCellPhoneNullReqBO) {
        this.updatePersonCellPhoneNullService.updatePersonCellPhoneNull(updatePersonCellPhoneNullReqBO);
        return null;
    }

    @RequestMapping(value={"/updateUserInfoByRec"})
    @BusiResponseBody
    public Object updateUserInfoByRec(UpdateUserInfoByRecReqBO userInfoByRecReqBO) {
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfoByRecReqBO.getName()})) {
                userInfoByRecReqBO.setName(new String(userInfoByRecReqBO.getName().getBytes("iso-8859-1"), "utf-8"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfoByRecReqBO.getLoginName()})) {
                userInfoByRecReqBO.setLoginName(new String(userInfoByRecReqBO.getLoginName().getBytes("iso-8859-1"), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.updateUserInfoByRecWebService.updateUserInfoByRecWeb(userInfoByRecReqBO);
        return null;
    }

    @RequestMapping(value={"/manageSearch"})
    @BusiResponseBody
    public Object searchTwoLevelManage(SelectSearchByUserInfoReqBO selectSearchByUserInfoReqBO) {
        LinkedList<String> typeList = new LinkedList<String>();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage") || SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        }
        return this.selectSearchByUserInfoService.selectSearchByUserInfoService(selectSearchByUserInfoReqBO);
    }

    @RequestMapping(value={"/addPortalUser"})
    @BusiResponseBody
    public Object addPortalUserWeb(AddUserWebReqBO addUserWebReqBO) {
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserWebReqBO.getName()})) {
                addUserWebReqBO.setName(new String(addUserWebReqBO.getName().getBytes("iso-8859-1"), "utf-8"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserWebReqBO.getLoginNameReq()})) {
                addUserWebReqBO.setLoginNameReq(new String(addUserWebReqBO.getLoginNameReq().getBytes("iso-8859-1"), "utf-8"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserWebReqBO.getCellPhoneReq()})) {
                addUserWebReqBO.setCellPhoneReq(new String(addUserWebReqBO.getCellPhoneReq().getBytes("iso-8859-1"), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.addPortalUserWebService.insertUser(addUserWebReqBO);
        return null;
    }

    @RequestMapping(value={"/updatePassword"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u8bbe\u7f6e\u5bc6\u7801")
    public Object updatePassword(ChangePwdWebReqBO changePwdWebReqBO) {
        logger.debug("\u65b0\u5bc6\u7801\u5bc6\u6587:{}", (Object)changePwdWebReqBO.getPasswordReq());
        logger.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
        String newPwd = AesUtil.decryptStr(changePwdWebReqBO.getPasswordReq(), this.ORIGINAL_KEY);
        logger.debug("\u65b0\u5bc6\u7801\u660e\u6587:{}", (Object)newPwd);
        if (StringUtils.isEmpty((CharSequence)newPwd)) {
            throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u79d8\u94a5\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u5bc6");
        }
        changePwdWebReqBO.setPasswordReq(newPwd);
        this.changePwdByUserIdWebService.changePasswordByUserId(changePwdWebReqBO);
        Jedis resource = this.cacheClient.getJedisPool().getResource();
        String select = resource.select(this.redisDatabase);
        if (changePwdWebReqBO.getUserIdReq() != null) {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(changePwdWebReqBO.getUserIdReq());
            SelectUserInfoRspBO userRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            resource.del("cas" + userRspBO.getLoginName());
        } else {
            resource.del("cas" + SecurityHelper.getCurrentUser().getUsername());
        }
        resource.close();
        return null;
    }

    @RequestMapping(value={"/changeInvalidPwd"})
    @BusiResponseBody
    public Object changeInvalidPwd(ChangePwdIsOrNotReqBO changePwdIsOrNotReqBO) {
        logger.debug("\u9a8c\u8bc1\u4fe1\u606f" + JSON.toJSONString((Object)changePwdIsOrNotReqBO));
        return this.changePwdOfExpireService.changePwd(changePwdIsOrNotReqBO);
    }

    @RequestMapping(value={"/selectUserDefaultApp"})
    @BusiResponseBody
    public Object selectUserDefaultApp(SelectUserDefaultAppReqBO reqBO) {
        return this.selectUserDefaultAppService.selectUserDefaultApp(reqBO);
    }

    @RequestMapping(value={"/saveUserDefaultApp"})
    @BusiResponseBody
    public Object saveUserDefaultApp(SaveUserDefaultAppReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getAppCode())) {
            throw new ZTBusinessException("\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.saveUserDefaultAppService.saveUserDefaultApp(reqBO);
        return null;
    }

    @RequestMapping(value={"/users/signup/getPicVfCode"})
    @BusiResponseBody
    public Object getPicVfCode(HttpServletRequest request) {
        QryVerifyCodePictureReqBO reqBO = new QryVerifyCodePictureReqBO();
        reqBO.setIp(IPUtils.getIp((HttpServletRequest)request));
        return this.qryVerifyCodePictureService.getPicVfCode(reqBO);
    }

    @RequestMapping(value={"/selectUserByRoleAndOrg"})
    @BusiResponseBody
    public Object selectUserByRoleAndOrg(SelectUserByRoleAndOrgWebReqBO reqBO) {
        return this.selectUserByRoleAndOrgWebService.selectUserByRoleAndOrg(reqBO);
    }

    @RequestMapping(value={"/selectUserOrgAndAuthIdentity"})
    @BusiResponseBody
    public Object selectUserOrgAndAuthIdentity(SelectUserOrgAndAuthIdentityWebReqBO reqBO) {
        return this.SelectUserOrgAndAuthIdentityWebService.selectUserOrgAndAuthIdentity(reqBO);
    }

    @RequestMapping(value={"/selectUserOrgAndAuthIdentityPage"})
    @BusiResponseBody
    public Object selectUserOrgAndAuthIdentityPage(SelectUserOrgAndAuthIdentityPageWebReqBO reqBO) {
        return this.SelectUserOrgAndAuthIdentityWebService.selectUserOrgAndAuthIdentityPage(reqBO);
    }

    @RequestMapping(value={"/selectUserStationByUserIdWeb"})
    @BusiResponseBody
    public Object selectUserStationByUserIdWeb(SelectUserStationWebReqBO reqBO) {
        return this.selectUserStaionByUserIdWebService.selectUserStation(reqBO);
    }

    @RequestMapping(value={"/getUserCounts"})
    @BusiResponseBody
    public Object getUserCounts(ReqInfo reqBO) {
        return this.getUserCountService.getUserCounts(reqBO);
    }
}

