/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.strategy.ExceptionStrategy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-1000)
public class ExceptionResolver
implements HandlerExceptionResolver {
    private Logger logger = LoggerFactory.getLogger(ExceptionResolver.class);
    @Value(value="${rpc.type}")
    private String rpcType;

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        ExceptionStrategy exceptionStrategy;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (e instanceof ExceptionStrategy) {
            exceptionStrategy = (ExceptionStrategy)e;
            String msg = exceptionStrategy.resolverException();
            this.addResult(result, msg);
        } else if (e instanceof ConstraintViolationException) {
            this.resolverBindException(e, result);
        } else if (e instanceof BindException) {
            BindException be = (BindException)e;
            BindingResult bindingResult = be.getBindingResult();
            if (bindingResult.hasErrors()) {
                this.addResult(result, ((ObjectError)bindingResult.getAllErrors().get(0)).getDefaultMessage());
            }
        } else if (null != e && StringUtils.isNotBlank((CharSequence)e.getMessage())) {
            this.addResult(result, e.getMessage());
        } else {
            this.addResult(result, "\u7cfb\u7edf\u5f02\u5e38");
        }
        this.logger.error("\u7a0b\u5e8f\u51fa\u73b0\u5f02\u5e38\uff1a" + JSON.toJSONString(result), (Throwable)e);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        if ("SpringCloud".equals(this.rpcType) && e instanceof ExceptionStrategy) {
            exceptionStrategy = (ExceptionStrategy)e;
            try {
                response.setHeader("errorMsg", URLEncoder.encode(exceptionStrategy.resolverException(), "utf-8"));
            }
            catch (UnsupportedEncodingException var9) {
                var9.printStackTrace();
            }
        }
        try {
            response.getWriter().write(JSON.toJSONString(result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse}));
        }
        catch (IOException var8) {
            this.logger.error("\u4e0e\u5ba2\u6237\u7aef\u901a\u8baf\u5f02\u5e38\uff1a" + var8.getMessage(), (Throwable)var8);
        }
        return new ModelAndView();
    }

    private void resolverBindException(Throwable e, Map<String, Object> result) {
        ConstraintViolationException ve = (ConstraintViolationException)e;
        Set violations = ve.getConstraintViolations();
        StringBuilder sb = new StringBuilder();
        int size = violations.size();
        int[] num = new int[]{1};
        violations.forEach(entry -> {
            int var10004 = num[0];
            int var10001 = num[0];
            num[0] = var10004 + 1;
            if (size == var10001) {
                sb.append(entry.getMessage());
            } else {
                sb.append(entry.getMessage()).append("\u5e76\u4e14");
            }
        });
        this.addResult(result, sb.toString());
    }

    private final void addResult(Map<String, Object> result, String message) {
        result.put("code", "1");
        result.put("message", message);
    }
}

