/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.organisation;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.organisation.bo.OrgSearchPageReqBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByExtOrgWebReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByMuserIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByOrgTreePathReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByRoleIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectTreePathByOrgId;
import com.ohaotian.authority.organisation.bo.TenanNameRspBO;
import com.ohaotian.authority.organisation.bo.TenantNameListRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.authority.organisation.service.DeleteOrganizationServer;
import com.ohaotian.authority.organisation.service.OrgSearchService;
import com.ohaotian.authority.organisation.service.QueryOrgTreePathByParentIdService;
import com.ohaotian.authority.organisation.service.ReopenOrganisationByOrgId;
import com.ohaotian.authority.organisation.service.SelectAllOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgByExtOrgWebService;
import com.ohaotian.authority.organisation.service.SelectOrgByMuserIdService;
import com.ohaotian.authority.organisation.service.SelectOrgByOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgByRoleIdService;
import com.ohaotian.authority.organisation.service.SelectOrgRootTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.organisation.service.SelectTenantNameService;
import com.ohaotian.authority.organisation.service.SelectTreePathByOrgIdService;
import com.ohaotian.authority.organisation.service.StopOrganisationByOrgId;
import com.ohaotian.authority.organisation.service.UpdateOrganisationService;
import com.ohaotian.authority.role.bo.SaveOrgGrantRolesReqBO;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesReqBO;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathReqBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.service.SaveOrgGrantRolesBusiService;
import com.ohaotian.authority.role.service.SelectOrgAlreadyRolesBusiService;
import com.ohaotian.authority.role.service.SelectOverallRoleService;
import com.ohaotian.authority.role.service.SelectRolesByOrgTreePathBusiService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.station.bo.DataSourceRspBO;
import com.ohaotian.authority.tenant.bo.SelectUserTenantReqBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectUserTenantService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/org"}, method={RequestMethod.GET, RequestMethod.POST})
public class OrgController {
    private static final Logger logger = LoggerFactory.getLogger(OrgController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private CreateOrganisationService createOrganisationService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private UpdateOrganisationService updateOrganisationService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private StopOrganisationByOrgId stopOrganisationByOrgId;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private ReopenOrganisationByOrgId reopenOrganisationByOrgId;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private OrgSearchService orgSearchService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgAlreadyRolesBusiService selectOrgAlreadyRolesBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SaveOrgGrantRolesBusiService saveOrgGrantRolesBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgTreePathService selectOrgTreePathService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgRootTreePathService selectOrgRootTreePathService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectTreePathByOrgIdService selectTreePathByOrgIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private DeleteOrganizationServer deleteOrganizationServer;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectTenantNameService selectTenantNameService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectTenantByIdService selectTenantByIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectUserTenantService selectUserTenantService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectAllOrgTreePathService selectAllOrgTreePathService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectUserInfoService selectUserInfoService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgByMuserIdService selectOrgByMuserIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgByRoleIdService selectOrgByRoleIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectRolesByOrgTreePathBusiService selectRolesByOrgTreePathBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgByOrgTreePathService selectOrgByOrgTreePathService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOverallRoleService selectOverallRoleService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectOrgByExtOrgWebService selectOrgByExtOrgWebService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private QueryOrgTreePathByParentIdService queryOrgTreePathByParentIdService;

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u65b0\u589e")
    public Object add(OrganisationBO organisationBO) {
        Date createTime = new Date();
        organisationBO.setCreatTime(createTime);
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        organisationBO.setOrganisationId(Long.valueOf(l));
        this.createOrganisationService.createOrganisation(organisationBO);
        return null;
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(OrganisationIdReqBO organisationBO) {
        RspOrganisationBO rspOrganisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationBO);
        return rspOrganisationBO;
    }

    @RequestMapping(value={"/selectTenant"})
    @BusiResponseBody
    public Object selectTenant() {
        ArrayList treePathRspBOS = new ArrayList();
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectTenantNameService.selectTenanNameService();
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            SelectUserTenantReqBO selectUserTenantReqBO = new SelectUserTenantReqBO();
            BeanUtils.copyProperties((Object)currentUser, (Object)selectUserTenantReqBO);
            TenantRspBO tenantRspBO = this.selectUserTenantService.selectUserTenant(selectUserTenantReqBO);
            TenantNameListRspBO rspBO = new TenantNameListRspBO();
            LinkedList<TenanNameRspBO> list = new LinkedList<TenanNameRspBO>();
            TenanNameRspBO tenanNameRspBO = new TenanNameRspBO();
            tenanNameRspBO.setTenantId(tenantRspBO.getTenantId());
            tenanNameRspBO.setTenantName(tenantRspBO.getTenantName());
            tenanNameRspBO.setOrgRootId(tenantRspBO.getOrgRootId());
            list.add(tenanNameRspBO);
            rspBO.setTenanNameRspBOList(list);
            return rspBO;
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage") && currentUser != null) {
            SelectOrgByMuserIdReqBO reqBO = new SelectOrgByMuserIdReqBO();
            reqBO.setmUserId(currentUser.getUserId());
            return this.selectOrgByMuserIdService.selectOrgByMuserId(reqBO);
        }
        return treePathRspBOS;
    }

    @RequestMapping(value={"/selectTenantBy"})
    @BusiResponseBody
    public Object selectTenantBy() {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectTenantNameService.selectTenanNameService();
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage") || SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            SelectUserTenantReqBO selectUserTenantReqBO = new SelectUserTenantReqBO();
            BeanUtils.copyProperties((Object)currentUser, (Object)selectUserTenantReqBO);
            TenantRspBO tenantRspBO = this.selectUserTenantService.selectUserTenant(selectUserTenantReqBO);
            TenantNameListRspBO rspBO = new TenantNameListRspBO();
            LinkedList<TenanNameRspBO> list = new LinkedList<TenanNameRspBO>();
            TenanNameRspBO tenanNameRspBO = new TenanNameRspBO();
            tenanNameRspBO.setTenantId(tenantRspBO.getTenantId());
            tenanNameRspBO.setTenantName(tenantRspBO.getTenantName());
            tenanNameRspBO.setOrgRootId(tenantRspBO.getOrgRootId());
            list.add(tenanNameRspBO);
            rspBO.setTenanNameRspBOList(list);
            return rspBO;
        }
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteOrg(OrganisationIdReqBO organisationBO) {
        try {
            OrganisationIdReqBO reqBO = new OrganisationIdReqBO();
            reqBO.setOrganisationId(organisationBO.getOrganisationId());
            RspOrganisationBO rspBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u673a\u6784", (Throwable)e);
        }
        this.deleteOrganizationServer.deleteOrganization(organisationBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(OrganisationBO organisationBO) {
        try {
            OrganisationIdReqBO reqBO = new OrganisationIdReqBO();
            reqBO.setOrganisationId(organisationBO.getOrganisationId());
            RspOrganisationBO rspBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u673a\u6784", (Throwable)e);
        }
        Date updateTime = new Date();
        organisationBO.setUpdateTime(updateTime);
        this.updateOrganisationService.updateOrganisation(organisationBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(OrganisationIdReqBO organisationBO) {
        this.stopOrganisationByOrgId.stopOrganisationByOrgId(organisationBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(OrganisationIdReqBO organisationBO) {
        this.reopenOrganisationByOrgId.reopenOrganisationByOrgId(organisationBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object orgSearch(OrgSearchPageReqBO orgSearchPageReqBO) {
        return this.orgSearchService.selectSearchOrg(orgSearchPageReqBO);
    }

    @RequestMapping(value={"/rootPath"})
    @BusiResponseBody
    public Object getRootPath(@RequestParam(required=false) Long tenantId, @RequestParam(required=false) String authIdEntity, @RequestParam(required=false) Long stationId) {
        ArrayList treePathRspBOS = new ArrayList();
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            if (tenantId != null && tenantId != 0L) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(tenantId);
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                return this.selectOrgRootTreePathService.selectOrgTreePath(tenantRspBO.getOrgRootId());
            }
            POrdIdBO pOrdIdBO = new POrdIdBO();
            pOrdIdBO.setParentId(Long.valueOf(1L));
            return this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            if (currentUser != null) {
                SelectUserInfoReqBO reqBO = new SelectUserInfoReqBO();
                reqBO.setUserId(currentUser.getUserId());
                SelectUserInfoRspBO userInfoRspBO = this.selectUserInfoService.selectUserInfo(reqBO);
                return this.selectOrgRootTreePathService.selectOrgTreePath(userInfoRspBO.getmOrgId());
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            if (authIdEntity != null && !"".equals(authIdEntity)) {
                SelectOrgByRoleIdReqBO reqBO = new SelectOrgByRoleIdReqBO();
                reqBO.setAuthIdEntity(authIdEntity);
                reqBO.setUserId(currentUser.getUserId());
                return this.selectOrgByRoleIdService.selectOrgByRoleId(reqBO);
            }
            if (stationId != null) {
                SelectOrgByOrgTreePathReqBO reqBO = new SelectOrgByOrgTreePathReqBO();
                reqBO.setStationId(stationId);
                reqBO.setUserId(currentUser.getUserId());
                return this.selectOrgByOrgTreePathService.selectOrgByOrgTreePath(reqBO);
            }
            SelectOrgByMuserIdReqBO reqBO = new SelectOrgByMuserIdReqBO();
            reqBO.setmUserId(currentUser.getUserId());
            return this.selectOrgByMuserIdService.selectOrgByMuserId(reqBO);
        }
        return treePathRspBOS;
    }

    @RequestMapping(value={"/getOrgByParentId"})
    @BusiResponseBody
    public Object getTreePath(POrdIdBO pOrdIdBO) {
        LinkedList<TreePathRspBO> treePathRspBOList = new LinkedList<TreePathRspBO>();
        if (pOrdIdBO.getmUserId() == null) {
            return this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        }
        if (pOrdIdBO.getmUserId() != null) {
            TreePathRspBOS treePathRspBOS = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
            for (TreePathRspBO treePathRspBO : treePathRspBOS.getTreePathRspBOList()) {
                if (pOrdIdBO.getmUserId().equals(treePathRspBO.getmUserId())) {
                    treePathRspBO.setIsParent(Integer.valueOf(1));
                }
                treePathRspBOList.add(treePathRspBO);
            }
            return treePathRspBOList;
        }
        return treePathRspBOList;
    }

    @RequestMapping(value={"/getAllOrgByParentId"})
    @BusiResponseBody
    public Object getAllTreePath(POrdIdBO pOrdIdBO) {
        return this.selectAllOrgTreePathService.selectAllOrgTreePath(pOrdIdBO);
    }

    @RequestMapping(value={"/qryParent"})
    @BusiResponseBody
    public Object qryParent(SelectTreePathByOrgId selectTreePathByOrgId) {
        return this.selectTreePathByOrgIdService.selectTreePathByOrgIdService(selectTreePathByOrgId);
    }

    @RequestMapping(value={"/alreadyAndNorRoles"})
    @BusiResponseBody
    public Object alreadyAndNorRoles(SelectOrgDistributeReqBO orgDistributeReqBO) {
        List userOperateRoles = new ArrayList();
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            SelectRolesByOrgTreePathReqBO selectRolesByOrgTreePathReqBO = new SelectRolesByOrgTreePathReqBO();
            selectRolesByOrgTreePathReqBO.setOrgTreePath(orgDistributeReqBO.getManaOrgTreePath());
            SelectRolesByOrgTreePathRspBO overallRole = this.selectOverallRoleService.overallRole(selectRolesByOrgTreePathReqBO);
            SelectRolesByOrgTreePathRspBO select = this.selectRolesByOrgTreePathBusiService.select(selectRolesByOrgTreePathReqBO);
            userOperateRoles.addAll(select.getHasGrantRoles());
            userOperateRoles.addAll(overallRole.getHasGrantRoles());
        } else {
            SelectUserOperateRolesReqBO map = (SelectUserOperateRolesReqBO)BeanMapper.map((Object)orgDistributeReqBO, SelectUserOperateRolesReqBO.class);
            map.setPrarmOrgTreePath(orgDistributeReqBO.getPrarmOrgTreePath());
            SelectUserOperateRolesRspBO userOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(map);
            userOperateRoles = userOperateRolesRspBO.getUserOperateRoles();
        }
        SelectOrgAlreadyRolesReqBO orgAlreadyRolesReqBO = new SelectOrgAlreadyRolesReqBO();
        orgAlreadyRolesReqBO.setOrgTreePath(orgDistributeReqBO.getOrgTreePath());
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectOrgAlreadyRolesBusiService.selectOrgAlreadyRoles(orgAlreadyRolesReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        userOperateRoles.removeAll(hasGrantRoles);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/grantToOrg"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u673a\u6784\u5206\u914d\u89d2\u8272")
    public Object grantToOrg(SaveOrgGrantRolesReqBO saveOrgGrantRolesReqBO) {
        this.saveOrgGrantRolesBusiService.saveOrgGrantRoles(saveOrgGrantRolesReqBO);
        return null;
    }

    @RequestMapping(value={"/tenantRootOrg"})
    @BusiResponseBody
    public Object tenantRootOrg(TenantIdBO tenantIdBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (SecurityHelper.hasAuthority((String)"auth:org:manage") && currentUser != null) {
            SelectOrgByMuserIdReqBO reqBO = new SelectOrgByMuserIdReqBO();
            reqBO.setmUserId(currentUser.getUserId());
            return this.selectOrgByMuserIdService.selectOrgByMuserId(reqBO);
        }
        TreePathRspBOS treePathRspBOS = new TreePathRspBOS();
        if (tenantIdBO == null) {
            return treePathRspBOS;
        }
        TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
        logger.debug("tenantRspBO" + tenantRspBO.toString());
        OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
        organisationIdReqBO.setOrganisationId(tenantRspBO.getOrgRootId());
        RspOrganisationBO rspOrganisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
        LinkedList<TreePathRspBO> treePathRspBOList = new LinkedList<TreePathRspBO>();
        TreePathRspBO treePathRspBO = (TreePathRspBO)BeanMapper.map((Object)rspOrganisationBO, TreePathRspBO.class);
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(tenantRspBO.getOrgRootId());
        TreePathRspBOS treePathRspBOS1 = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS1.getTreePathRspBOList() != null && treePathRspBOS1.getTreePathRspBOList().size() > 0) {
            treePathRspBO.setIsParent(Integer.valueOf(0));
        } else {
            treePathRspBO.setIsParent(Integer.valueOf(1));
        }
        treePathRspBOList.add(treePathRspBO);
        treePathRspBOS.setTreePathRspBOList(treePathRspBOList);
        return treePathRspBOS;
    }

    @RequestMapping(value={"/selectOrgIdAndNameData"})
    @BusiResponseBody
    public Object selectOrgIdAndNameData(POrdIdBO parentId) {
        TreePathRspBOS treePathRspBOS = this.selectOrgTreePathService.selectOrgTreePath(parentId);
        LinkedList<DataSourceRspBO> rspBOS = new LinkedList<DataSourceRspBO>();
        if (treePathRspBOS != null && treePathRspBOS.getTreePathRspBOList().size() > 0) {
            for (TreePathRspBO dataSourceRspBO : treePathRspBOS.getTreePathRspBOList()) {
                DataSourceRspBO dataSourceBO = new DataSourceRspBO();
                dataSourceBO.setDataId(Long.toString(dataSourceRspBO.getOrganisationId()));
                dataSourceBO.setDataName(dataSourceRspBO.getTitle());
                if (dataSourceRspBO.getIsParent() == 0) {
                    dataSourceBO.setHadSublevel(Boolean.valueOf(true));
                } else if (dataSourceRspBO.getIsParent() == 1) {
                    dataSourceBO.setHadSublevel(Boolean.valueOf(false));
                }
                rspBOS.add(dataSourceBO);
            }
        }
        return rspBOS;
    }

    @RequestMapping(value={"/selectOrgByExtOrg"})
    @BusiResponseBody
    public Object selectOrgByExtOrg(SelectOrgByExtOrgWebReqBO reqBO) {
        return this.selectOrgByExtOrgWebService.selectOrgByExtOrg(reqBO);
    }

    @RequestMapping(value={"/selectOrgByOrgTreePath"})
    @BusiResponseBody
    public Object selectOrgByExtOrg(SelectOrgByOrgTreePathReqBO reqBO) {
        return this.selectOrgByOrgTreePathService.selectOrgByOrgTreePath(reqBO);
    }

    @RequestMapping(value={"/queryOrgTreePathByParentId"})
    @BusiResponseBody
    public List<OrganisationBO> queryOrgTreePathByParentId(OrganisationBO organisationBO) {
        return this.queryOrgTreePathByParentIdService.queryOrgTreePathByParentId(organisationBO);
    }
}

