/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.config;

import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="minio")
public class MinioConfig {
    private static final Logger log = LoggerFactory.getLogger(MinioConfig.class);
    private String endpoint;
    private String accessKey;
    private String secretKey;
    private String bucketName;
    private String rootUrl;

    @Bean
    public MinioClient minioClient() {
        log.info("minio \u5ba2\u6237\u7aef\u542f\u52a8");
        return MinioClient.builder().endpoint(this.endpoint).credentials(this.accessKey, this.secretKey).build();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setRootUrl(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinioConfig)) {
            return false;
        }
        MinioConfig other = (MinioConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$accessKey = this.getAccessKey();
        String other$accessKey = other.getAccessKey();
        if (this$accessKey == null ? other$accessKey != null : !this$accessKey.equals(other$accessKey)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$rootUrl = this.getRootUrl();
        String other$rootUrl = other.getRootUrl();
        return !(this$rootUrl == null ? other$rootUrl != null : !this$rootUrl.equals(other$rootUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinioConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $accessKey = this.getAccessKey();
        result = result * 59 + ($accessKey == null ? 43 : $accessKey.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $rootUrl = this.getRootUrl();
        result = result * 59 + ($rootUrl == null ? 43 : $rootUrl.hashCode());
        return result;
    }

    public String toString() {
        return "MinioConfig(endpoint=" + this.getEndpoint() + ", accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", bucketName=" + this.getBucketName() + ", rootUrl=" + this.getRootUrl() + ")";
    }
}

