/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.role;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.google.common.collect.Lists;
import com.ohaotian.authority.annotation.Insert;
import com.ohaotian.authority.annotation.Update;
import com.ohaotian.authority.common.bo.BaseReqBO;
import com.ohaotian.authority.common.bo.DictCommonDelExportReqBO;
import com.ohaotian.authority.common.bo.DictCommonEnumTypeRspBO;
import com.ohaotian.authority.common.rsp.DictPage;
import com.ohaotian.authority.common.rsp.DictResult;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByTenantIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByTenantIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.SelectOrgByTenantIdBusiService;
import com.ohaotian.authority.organisation.service.SelectOrgStatusService;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.role.bo.CreatRoleReqBO;
import com.ohaotian.authority.role.bo.DeleteRoleReqBO;
import com.ohaotian.authority.role.bo.DictQueryRoleMenuBO;
import com.ohaotian.authority.role.bo.DictRoleAssignDataScopeReqBO;
import com.ohaotian.authority.role.bo.DictRoleAssignUserExportReqBO;
import com.ohaotian.authority.role.bo.DictRoleMenuExportRspBO;
import com.ohaotian.authority.role.bo.DictRoleQryReqBO;
import com.ohaotian.authority.role.bo.DictRoleQueryUserReqBO;
import com.ohaotian.authority.role.bo.DictRoleQueryUserRspBO;
import com.ohaotian.authority.role.bo.DictRoleReqBO;
import com.ohaotian.authority.role.bo.DictRoleRspBO;
import com.ohaotian.authority.role.bo.DictRoleUserExportRspBO;
import com.ohaotian.authority.role.bo.HasAllUserListBO;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.OrgBO;
import com.ohaotian.authority.role.bo.RoleBO;
import com.ohaotian.authority.role.bo.RoleInfoBO;
import com.ohaotian.authority.role.bo.RoleStatusReqBO;
import com.ohaotian.authority.role.bo.SaveOrgGrantUsersReqBO;
import com.ohaotian.authority.role.bo.SaveRoleConfigMenusReqBO;
import com.ohaotian.authority.role.bo.SaveRoleOrgsReqBO;
import com.ohaotian.authority.role.bo.SearchRolesRspBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorRolesReqBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorUsersReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdReqBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdRspBO;
import com.ohaotian.authority.role.bo.SelectRoleStationServiceReqBO;
import com.ohaotian.authority.role.bo.SelectRoleStationServiceRspBO;
import com.ohaotian.authority.role.bo.SelectRolesPageReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.bo.UpdateRoleByIDReqBO;
import com.ohaotian.authority.role.service.CreatRoleBusiService;
import com.ohaotian.authority.role.service.DeleteRoleBusiService;
import com.ohaotian.authority.role.service.RestartRoleByIdBusiService;
import com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService;
import com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService;
import com.ohaotian.authority.role.service.SaveRoleOrgsService;
import com.ohaotian.authority.role.service.SelectAdminRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectAllUserByRoleId;
import com.ohaotian.authority.role.service.SelectAlreadyUser;
import com.ohaotian.authority.role.service.SelectHasOrgsByRoleService;
import com.ohaotian.authority.role.service.SelectOrgRolesPageService;
import com.ohaotian.authority.role.service.SelectOverAllRolesPageService;
import com.ohaotian.authority.role.service.SelectRoleByIdBusiService;
import com.ohaotian.authority.role.service.SelectRoleInfoByIdService;
import com.ohaotian.authority.role.service.SelectRoleStationService;
import com.ohaotian.authority.role.service.SelectRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectTenantRolesPageService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.role.service.StopRoleByIdBusiService;
import com.ohaotian.authority.role.service.UpdateRoleByIDBusiService;
import com.ohaotian.authority.station.bo.AuthStationRolesBO;
import com.ohaotian.authority.user.bo.SaveUserAuthReqBO;
import com.ohaotian.authority.user.service.SaveRoleAuthService;
import com.ohaotian.authority.util.ExcelUtils;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import io.swagger.annotations.ApiOperation;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/udp/role"}, method={RequestMethod.GET, RequestMethod.POST})
public class RoleUdpController {
    private static final Logger logger = LoggerFactory.getLogger(RoleUdpController.class);
    @Autowired
    private CreatRoleBusiService creatRoleBusiService;
    @Autowired
    private StopRoleByIdBusiService stopRoleByIdBusiService;
    @Autowired
    private RestartRoleByIdBusiService restartRoleByIdBusiService;
    @Autowired
    private UpdateRoleByIDBusiService updateRoleByIDBusiService;
    @Autowired
    private SelectRoleByIdBusiService selectRoleByIdBusiService;
    @Autowired
    private SelectRolesPageBusiService selectRolesPageBusiService;
    @Autowired
    private SelectAdminRolesPageBusiService selectAdminRolesPageBusiService;
    @Autowired
    private SelectAllUserByRoleId selectAllUserByRoleId;
    @Autowired
    private SelectAlreadyUser selectAlreadyUser;
    @Autowired
    private SaveOrgGrantUsersBusiService saveOrgGrantUsersBusiService;
    @Autowired
    private SelectHasOrgsByRoleService selectHasOrgsByRoleService;
    @Autowired
    private SaveRoleOrgsService saveRoleOrgsService;
    @Autowired
    private SelectOrgTreePathService selectOrgTreePathService;
    @Autowired
    private SaveRoleAuthService saveRoleAuthService;
    @Autowired
    private SaveRoleConfigMenusBusiService saveRoleConfigMenusBusiService;
    @Autowired
    private DeleteRoleBusiService deleteRoleBusiService;
    @Autowired
    private SelectOverAllRolesPageService selectOverAllRolesPageService;
    @Autowired
    private SelectTenantRolesPageService selectTenantRolesPageService;
    @Autowired
    private SelectRoleInfoByIdService selectRoleInfoByIdService;
    @Autowired
    private SelectOrgRolesPageService selectOrgRolesPageService;
    @Autowired
    private SelectOrgStatusService selectOrgStatusService;
    @Autowired
    private SelectOrgByTenantIdBusiService selectOrgByTenantIdBusiService;
    @Autowired
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Autowired
    private SelectRoleStationService selectRoleStationService;

    @PostMapping(value={"/create"})
    public DictResult<String> add(@Validated(value={Insert.class}) @RequestBody DictRoleReqBO dictRoleReqBO) {
        String insertResult = this.creatRoleBusiService.creatRole2(dictRoleReqBO);
        if (StringUtils.isBlank((CharSequence)insertResult)) {
            return DictResult.success();
        }
        return DictResult.error(null, (String)insertResult);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272")
    public DictResult<String> update(@Validated(value={Update.class}) @RequestBody DictRoleReqBO dictRoleReqBO) {
        String updateResult = this.updateRoleByIDBusiService.updateRoleByID2(dictRoleReqBO);
        if (StringUtils.isBlank((CharSequence)updateResult)) {
            return DictResult.success();
        }
        return DictResult.error(null, (String)updateResult);
    }

    @PostMapping(value={"/pre-delete"})
    @ApiOperation(value="\u9884\u5220\u9664-\u5224\u65ad\u89d2\u8272\u662f\u5426\u53ef\u5220\u9664")
    public DictResult<String> preDelete(@Validated @RequestBody DictCommonDelExportReqBO commonDelExportReqBO) {
        String preDeleteMsg = this.deleteRoleBusiService.preDelete(commonDelExportReqBO);
        if (StringUtils.isBlank((CharSequence)preDeleteMsg)) {
            return DictResult.success();
        }
        return DictResult.error(null, (String)preDeleteMsg);
    }

    @PostMapping(value={"/delete2"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    public DictResult<String> delete(@Validated @RequestBody DictCommonDelExportReqBO commonDelExportReqBO) {
        String deleteResult = this.deleteRoleBusiService.deleteRole2(commonDelExportReqBO);
        if (StringUtils.isBlank((CharSequence)deleteResult)) {
            return DictResult.success();
        }
        return DictResult.error(null, (String)deleteResult);
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u89d2\u8272\u5217\u8868")
    public DictResult<DictPage<DictRoleRspBO>> list(@RequestBody DictRoleQryReqBO dictRoleQryReqBO) {
        return DictResult.success((Object)this.selectRolesPageBusiService.selectRolesPage2(dictRoleQryReqBO));
    }

    @PostMapping(value={"/all"})
    @ApiOperation(value="\u5168\u90e8\u89d2\u8272\u5217\u8868\uff08\u7528\u6237\u9009\u62e9\u89d2\u8272\u4f7f\u7528\uff09")
    public DictResult<List<DictRoleRspBO>> list(@RequestBody BaseReqBO baseReqBO) {
        return DictResult.success((Object)this.selectRolesPageBusiService.allRoles(baseReqBO));
    }

    @GetMapping(value={"/data-scope/enum"})
    @ApiOperation(value="\u6570\u636e\u6743\u9650\u5217\u8868")
    public DictResult<List<DictCommonEnumTypeRspBO>> dataScopeEnum() {
        return DictResult.success((Object)this.selectRolesPageBusiService.dataScopeEnum());
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void export(HttpServletResponse response, @RequestBody DictCommonDelExportReqBO commonDelExportReqBO) throws Exception {
        String ROLE_EXPORT_FILE_NAME = URLEncoder.encode("\u89d2\u8272\u7edf\u8ba1\u8868.xlsx", StandardCharsets.UTF_8.name().replace("\\+", "%20"));
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename*=UTF-8''" + ROLE_EXPORT_FILE_NAME);
        ExcelUtils.export((HttpServletResponse)response, (List)Lists.newArrayList((Object[])new ExcelUtils.ExportBO[]{this.getRoleUserExportBO(commonDelExportReqBO), this.getRoleMenuExportBO(commonDelExportReqBO)}));
    }

    @PostMapping(value={"/assign-data-scope"})
    @ApiOperation(value="\u5206\u914d\u6570\u636e\u6743\u9650")
    public DictResult<String> assignDataScope(@Validated @RequestBody DictRoleAssignDataScopeReqBO assignDataScopeReqBO) {
        this.updateRoleByIDBusiService.assignDataScope(assignDataScopeReqBO);
        return DictResult.success();
    }

    @PostMapping(value={"/switch-status"})
    @ApiOperation(value="\u72b6\u6001\u5f00\u5173")
    public DictResult<String> switchStatus(@RequestBody DictCommonDelExportReqBO bo) {
        if (CollectionUtils.isNotEmpty((Collection)bo.getIds())) {
            this.updateRoleByIDBusiService.switchStatus((String)bo.getIds().get(0));
            return DictResult.success();
        }
        return DictResult.error(null, (String)"\u8bf7\u9009\u62e9\u8981\u5f00\u542f/\u5173\u95ed\u7684\u89d2\u8272");
    }

    @PostMapping(value={"/assign-users/add"})
    @ApiOperation(value="\u5206\u914d\u7528\u6237")
    public DictResult<String> assignUsers(@Validated @RequestBody DictRoleAssignUserExportReqBO assignUserReqBO) {
        this.updateRoleByIDBusiService.assignUsers(assignUserReqBO);
        return DictResult.success();
    }

    @PostMapping(value={"/assign-users/cancel"})
    @ApiOperation(value="\u53d6\u6d88\u6388\u6743")
    public DictResult<String> cancelAssignUsers(@Validated @RequestBody DictRoleAssignUserExportReqBO assignUserReqBO) {
        this.updateRoleByIDBusiService.cancelAssignUsers(assignUserReqBO);
        return DictResult.success();
    }

    private ExcelUtils.ExportBO getRoleUserExportBO(DictCommonDelExportReqBO commonDelExportReqBO) {
        List roleUsers = this.selectRolesPageBusiService.getRoleUsers(commonDelExportReqBO);
        ExcelUtils.ExportBO roleUserExportBO = new ExcelUtils.ExportBO();
        roleUserExportBO.setExportClazz(DictRoleUserExportRspBO.class);
        roleUserExportBO.setSheetName("\u89d2\u8272\u7528\u6237\u8868");
        if (CollectionUtils.isNotEmpty((Collection)roleUsers)) {
            roleUserExportBO.setDataList(roleUsers);
            roleUserExportBO.setSheetWriteHandler((SheetWriteHandler)new ExcelUtils.AddCellRangeWriteHandler(DictRoleUserExportRspBO.createCellRangeAddressListRoleUser((List)roleUsers)));
        }
        return roleUserExportBO;
    }

    private ExcelUtils.ExportBO getRoleMenuExportBO(DictCommonDelExportReqBO commonDelExportReqBO) {
        List roleMenus = this.selectRolesPageBusiService.getRoleMenus(commonDelExportReqBO);
        ExcelUtils.ExportBO roleMenuExportBO = new ExcelUtils.ExportBO();
        roleMenuExportBO.setExportClazz(DictRoleMenuExportRspBO.class);
        roleMenuExportBO.setSheetName("\u89d2\u8272\u529f\u80fd\u6743\u9650\u8868");
        if (CollectionUtils.isNotEmpty((Collection)roleMenus)) {
            ArrayList roleMenuExportRspBOList = new ArrayList();
            AtomicInteger rowNumber = new AtomicInteger(1);
            roleMenus.stream().collect(Collectors.groupingBy(DictQueryRoleMenuBO::getRoleName, Collectors.groupingBy(DictQueryRoleMenuBO::getMenuParentId, Collectors.collectingAndThen(Collectors.toList(), list -> {
                list.sort(Comparator.comparing(DictQueryRoleMenuBO::getMenuSort));
                return list;
            })))).forEach((roleName, menuMap) -> ((List)menuMap.get(0L)).stream().map(roleMenuBO -> {
                DictQueryRoleMenuBO.MenuTreeDataBO testMenuTreeDataBO = new DictQueryRoleMenuBO.MenuTreeDataBO();
                testMenuTreeDataBO.setMenuId(roleMenuBO.getMenuId());
                testMenuTreeDataBO.setMenuName(roleMenuBO.getMenuName());
                testMenuTreeDataBO.setMenuParentId(roleMenuBO.getMenuParentId());
                testMenuTreeDataBO.setMenuSort(roleMenuBO.getMenuSort());
                testMenuTreeDataBO.setChildren(DictQueryRoleMenuBO.getMenuChildren((List)((List)menuMap.get(roleMenuBO.getMenuId())), (Map)menuMap));
                return testMenuTreeDataBO;
            }).forEach(menuTreeDataBO -> {
                if (CollectionUtils.isNotEmpty((Collection)menuTreeDataBO.getChildren())) {
                    menuTreeDataBO.getChildren().forEach(childrenMenu -> {
                        if (CollectionUtils.isNotEmpty((Collection)childrenMenu.getChildren())) {
                            childrenMenu.getChildren().forEach(ChildrenMenuButton -> {
                                DictRoleMenuExportRspBO dictRoleMenuExportRspBO = new DictRoleMenuExportRspBO();
                                dictRoleMenuExportRspBO.setRowNumber(Integer.valueOf(rowNumber.getAndIncrement()));
                                dictRoleMenuExportRspBO.setRoleName(roleName);
                                dictRoleMenuExportRspBO.setMenuName1(menuTreeDataBO.getMenuName());
                                dictRoleMenuExportRspBO.setMenuName2(childrenMenu.getMenuName());
                                dictRoleMenuExportRspBO.setMenuName3(ChildrenMenuButton.getMenuName());
                                roleMenuExportRspBOList.add(dictRoleMenuExportRspBO);
                            });
                        } else {
                            DictRoleMenuExportRspBO dictRoleMenuExportRspBO = new DictRoleMenuExportRspBO();
                            dictRoleMenuExportRspBO.setRowNumber(Integer.valueOf(rowNumber.getAndIncrement()));
                            dictRoleMenuExportRspBO.setRoleName(roleName);
                            dictRoleMenuExportRspBO.setMenuName1(menuTreeDataBO.getMenuName());
                            dictRoleMenuExportRspBO.setMenuName2(childrenMenu.getMenuName());
                            dictRoleMenuExportRspBO.setMenuName3("");
                            roleMenuExportRspBOList.add(dictRoleMenuExportRspBO);
                        }
                    });
                } else {
                    DictRoleMenuExportRspBO dictRoleMenuExportRspBO = new DictRoleMenuExportRspBO();
                    dictRoleMenuExportRspBO.setRowNumber(Integer.valueOf(rowNumber.getAndIncrement()));
                    dictRoleMenuExportRspBO.setRoleName(roleName);
                    dictRoleMenuExportRspBO.setMenuName1(menuTreeDataBO.getMenuName());
                    dictRoleMenuExportRspBO.setMenuName2("");
                    dictRoleMenuExportRspBO.setMenuName3("");
                    roleMenuExportRspBOList.add(dictRoleMenuExportRspBO);
                }
            }));
            roleMenuExportBO.setDataList(roleMenuExportRspBOList);
            roleMenuExportBO.setSheetWriteHandler((SheetWriteHandler)new ExcelUtils.AddCellRangeWriteHandler(DictRoleMenuExportRspBO.createCellRangeAddressListRoleMenu(roleMenuExportRspBOList)));
        }
        return roleMenuExportBO;
    }

    @PostMapping(value={"/queryUserByRole"})
    public DictResult<List<DictRoleQueryUserRspBO>> queryUserByRole(@Validated @RequestBody DictRoleQueryUserReqBO reqBO) {
        return DictResult.success((Object)this.selectRolesPageBusiService.queryUserByRole(reqBO));
    }

    @RequestMapping(value={"/alreadyAndNorUsers"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object getAlreadyAndNorUsers(@RequestBody SelectAlreadyAndNorUsersReqBO reqBO) {
        reqBO.setOrgId(reqBO.getOrgIdWeb());
        if (reqBO.getOrgId() == null || reqBO.getRoleId() == null) {
            throw new ZTBusinessException("\u89d2\u8272id\u6216\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HasUserListBO hasAllUserListBO = this.selectAllUserByRoleId.selectAllUserByRoleId(reqBO);
        List allUser = hasAllUserListBO.getAllUser();
        HasUserListBO hasUserListBO = this.selectAlreadyUser.selectAlreadyDistributeUser(reqBO);
        List user = hasUserListBO.getAllUser();
        allUser.removeAll(user);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(user);
        orgDistributeRspBO.setNotGrantRoles(allUser);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/alreadyAndNorRoles"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object alreadyAndNorRoles(@RequestBody SelectAlreadyAndNorRolesReqBO reqBO) {
        if (reqBO.getStationId() == null) {
            throw new ZTBusinessException("\u5c97\u4f4did[stationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SelectUserOperateRolesReqBO selectUserOperateRolesReqBO = new SelectUserOperateRolesReqBO();
        SelectUserOperateRolesRspBO selectUserOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(selectUserOperateRolesReqBO);
        List allRoles = selectUserOperateRolesRspBO.getUserOperateRoles();
        SelectRoleStationServiceReqBO selectRoleStationServiceReqBO = new SelectRoleStationServiceReqBO();
        selectRoleStationServiceReqBO.setStationId(reqBO.getStationId());
        SelectRoleStationServiceRspBO hasRolesListBO = this.selectRoleStationService.selectRoleStation(selectRoleStationServiceReqBO);
        List hasAuthRoles = hasRolesListBO.getRows();
        ArrayList<RoleBO> allRoleList = new ArrayList<RoleBO>();
        for (Object bo : allRoles) {
            RoleBO roleBO = new RoleBO();
            if (bo.getRoleId() != null) {
                roleBO.setRoleId(bo.getRoleId());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)bo.getRoleName())) {
                roleBO.setRoleName(bo.getRoleName());
            }
            allRoleList.add(roleBO);
        }
        ArrayList<RoleBO> hasAuthRoleList = new ArrayList<RoleBO>();
        for (AuthStationRolesBO bo : hasAuthRoles) {
            RoleBO roleBO = new RoleBO();
            if (bo.getRoleId() != null) {
                roleBO.setRoleId(bo.getRoleId());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)bo.getRoleName())) {
                roleBO.setRoleName(bo.getRoleName());
            }
            hasAuthRoleList.add(roleBO);
        }
        allRoleList.removeAll(hasAuthRoleList);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasAuthRoleList);
        orgDistributeRspBO.setNotGrantRoles(allRoleList);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/commit"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object commit(@RequestBody SaveOrgGrantUsersReqBO reqBO) {
        this.saveOrgGrantUsersBusiService.saveOrgGrantUsers(reqBO);
        return null;
    }

    @RequestMapping(value={"/alreadyAndNorOrg"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object getAlreadyAndNorOrg(@RequestBody SelectAlreadyAndNorUsersReqBO reqBO) {
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(reqBO.getOrgIdWeb());
        LinkedList<OrgBO> allOrgs = new LinkedList<OrgBO>();
        TreePathRspBOS treePathRspBOS = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS != null && treePathRspBOS.getTreePathRspBOList() != null && treePathRspBOS.getTreePathRspBOList().size() > 0) {
            for (TreePathRspBO bo : treePathRspBOS.getTreePathRspBOList()) {
                OrgBO orgBO = new OrgBO();
                orgBO.setOrgId(bo.getOrganisationId());
                orgBO.setTitle(bo.getTitle());
                orgBO.setOrgTreePath(bo.getOrgTreePath());
                allOrgs.add(orgBO);
            }
        }
        HasAllUserListBO hasOrgsByRole = this.selectHasOrgsByRoleService.getHasOrgsByRole(reqBO);
        List hasOrgs = hasOrgsByRole.getAllUser();
        allOrgs.removeAll(hasOrgs);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasOrgs);
        orgDistributeRspBO.setNotGrantRoles(allOrgs);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/orgCommit"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object orgCommit(@RequestBody SaveRoleOrgsReqBO reqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            reqBO.setAuthIdentity("auth:org:manage");
        }
        this.saveRoleOrgsService.saveRoleOrgs(reqBO);
        return null;
    }

    @RequestMapping(value={"/creatRole"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u65b0\u589e")
    public Object creatRole(@RequestBody CreatRoleReqBO creatRoleReqBO) throws Exception {
        SelectOrgByTenantIdRspBO select;
        SelectOrgByTenantIdReqBO reqBO;
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_OVERALL);
                creatRoleReqBO.setOrgTreePath(null);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
                reqBO = new SelectOrgByTenantIdReqBO();
                reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
                select = this.selectOrgByTenantIdBusiService.select(reqBO);
                if (select != null) {
                    creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
                }
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_PART);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
                reqBO = new SelectOrgByTenantIdReqBO();
                reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
                select = this.selectOrgByTenantIdBusiService.select(reqBO);
                if (select != null) {
                    creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
                }
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
            reqBO = new SelectOrgByTenantIdReqBO();
            reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
            select = this.selectOrgByTenantIdBusiService.select(reqBO);
            if (select != null) {
                creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            creatRoleReqBO.setUserAuthIdentity("auth:org:manage");
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_MANAGER);
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        creatRoleReqBO.setRoleId(Long.valueOf(l));
        this.creatRoleBusiService.creatRole(creatRoleReqBO);
        return null;
    }

    @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u505c\u7528")
    public Object stopRole(@RequestBody RoleStatusReqBO roleStatusReqBO) {
        this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/restart"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u542f\u7528")
    public Object restartRole(@RequestBody RoleStatusReqBO roleStatusReqBO) {
        this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/selectRole"}, method={RequestMethod.POST})
    @BusiResponseBody
    public SelectRoleByIdRspBO selectRole(@RequestBody SelectRoleByIdReqBO selectRoleByIdReqBO) {
        return this.selectRoleByIdBusiService.selectRoleById(selectRoleByIdReqBO);
    }

    @RequestMapping(value={"/updateRole"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateRole(@RequestBody UpdateRoleByIDReqBO updateRoleByIDReqBO) throws Exception {
        try {
            SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
            reqBO.setRoleId(updateRoleByIDReqBO.getRoleId());
            RoleInfoBO rspBO = this.selectRoleInfoByIdService.selectById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u89d2\u8272", (Throwable)e);
        }
        this.updateRoleByIDBusiService.updateRoleByID(updateRoleByIDReqBO);
        return null;
    }

    @RequestMapping(value={"/selectRoles"}, method={RequestMethod.POST})
    @BusiResponseBody
    public RspPage<SearchRolesRspBO> selectRoles(@RequestBody SelectRolesPageReqBO rolesPageReqBO) {
        UserInfo user;
        RspPage rsp = new RspPage();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectRolesPageBusiService.selectRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectOverAllRolesPageService.selectOverAllRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectTenantRolesPageService.selectTenantRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage") && (user = SecurityHelper.getCurrentUser()).getUserId() != null) {
            rolesPageReqBO.setmUserId(user.getUserId());
            return this.selectOrgRolesPageService.selectOrgRolesPage(rolesPageReqBO);
        }
        return rsp;
    }

    @RequestMapping(value={"/authUserCommit"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u7528\u6237\u6388\u6743")
    public Object authUserCommit(@RequestBody SaveUserAuthReqBO saveUserAuthReqBO) {
        if (org.springframework.util.StringUtils.isEmpty((Object)saveUserAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            saveUserAuthReqBO.setAuthIdentity("auth:org:manage");
        }
        this.saveRoleAuthService.saveRoleAuthService(saveUserAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/configMenus"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u914d\u7f6e")
    public Object configMenus(@RequestBody SaveRoleConfigMenusReqBO saveRoleConfigMenusReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            saveRoleConfigMenusReqBO.setOrgTreePath(saveRoleConfigMenusReqBO.getOrgTreePath());
            saveRoleConfigMenusReqBO.setAuthIdentity("auth:org:manage");
            this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        } else {
            this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(@RequestBody DeleteRoleReqBO deleteRoleReqBO) {
        try {
            SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
            reqBO.setRoleId(deleteRoleReqBO.getRoleId());
            reqBO.setAuthIdentity(deleteRoleReqBO.getRoleAuthIdentity());
            RoleInfoBO rspBO = this.selectRoleInfoByIdService.selectById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            deleteRoleReqBO.setRoleAuthIdentity("auth:org:manage");
        }
        this.deleteRoleBusiService.deleteRole(deleteRoleReqBO);
        return null;
    }

    @RequestMapping(value={"/batchStop"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object batchStopRolesUdp(@RequestBody RoleStatusReqBO reqBO) {
        for (Long role : reqBO.getRoles()) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/batchRestart"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object restartRoleUdp(@RequestBody RoleStatusReqBO reqBO) {
        for (Long role : reqBO.getRoles()) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectOrgByTenantId"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object select(@RequestBody SelectOrgByTenantIdReqBO reqBO) {
        return this.selectOrgByTenantIdBusiService.select(reqBO);
    }
}

