/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.role;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByTenantIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByTenantIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.SelectOrgByTenantIdBusiService;
import com.ohaotian.authority.organisation.service.SelectOrgStatusService;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.role.bo.CreatRoleReqBO;
import com.ohaotian.authority.role.bo.DeleteRoleReqBO;
import com.ohaotian.authority.role.bo.HasAllUserListBO;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.OrgBO;
import com.ohaotian.authority.role.bo.RoleBO;
import com.ohaotian.authority.role.bo.RoleInfoBO;
import com.ohaotian.authority.role.bo.RoleStatusReqBO;
import com.ohaotian.authority.role.bo.SaveOrgGrantUsersReqBO;
import com.ohaotian.authority.role.bo.SaveRoleConfigMenusReqBO;
import com.ohaotian.authority.role.bo.SaveRoleOrgsReqBO;
import com.ohaotian.authority.role.bo.SearchRolesRspBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorRolesReqBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorUsersReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdReqBO;
import com.ohaotian.authority.role.bo.SelectRoleStationServiceReqBO;
import com.ohaotian.authority.role.bo.SelectRoleStationServiceRspBO;
import com.ohaotian.authority.role.bo.SelectRolesPageReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.bo.UpdateRoleByIDReqBO;
import com.ohaotian.authority.role.service.CreatRoleBusiService;
import com.ohaotian.authority.role.service.DeleteRoleBusiService;
import com.ohaotian.authority.role.service.RestartRoleByIdBusiService;
import com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService;
import com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService;
import com.ohaotian.authority.role.service.SaveRoleOrgsService;
import com.ohaotian.authority.role.service.SelectAdminRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectAllUserByRoleId;
import com.ohaotian.authority.role.service.SelectAlreadyUser;
import com.ohaotian.authority.role.service.SelectHasOrgsByRoleService;
import com.ohaotian.authority.role.service.SelectOrgRolesPageService;
import com.ohaotian.authority.role.service.SelectOverAllRolesPageService;
import com.ohaotian.authority.role.service.SelectRoleByIdBusiService;
import com.ohaotian.authority.role.service.SelectRoleInfoByIdService;
import com.ohaotian.authority.role.service.SelectRoleStationService;
import com.ohaotian.authority.role.service.SelectRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectTenantRolesPageService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.role.service.StopRoleByIdBusiService;
import com.ohaotian.authority.role.service.UpdateRoleByIDBusiService;
import com.ohaotian.authority.station.bo.AuthStationRolesBO;
import com.ohaotian.authority.user.bo.SaveUserAuthReqBO;
import com.ohaotian.authority.user.service.SaveRoleAuthService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/role"}, method={RequestMethod.GET, RequestMethod.POST})
public class RoleController {
    private static final Logger logger = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private CreatRoleBusiService creatRoleBusiService;
    @Autowired
    private StopRoleByIdBusiService stopRoleByIdBusiService;
    @Autowired
    private RestartRoleByIdBusiService restartRoleByIdBusiService;
    @Autowired
    private UpdateRoleByIDBusiService updateRoleByIDBusiService;
    @Autowired
    private SelectRoleByIdBusiService selectRoleByIdBusiService;
    @Autowired
    private SelectRolesPageBusiService selectRolesPageBusiService;
    @Autowired
    private SelectAdminRolesPageBusiService selectAdminRolesPageBusiService;
    @Autowired
    private SelectAllUserByRoleId selectAllUserByRoleId;
    @Autowired
    private SelectAlreadyUser selectAlreadyUser;
    @Autowired
    private SaveOrgGrantUsersBusiService saveOrgGrantUsersBusiService;
    @Autowired
    private SelectHasOrgsByRoleService selectHasOrgsByRoleService;
    @Autowired
    private SaveRoleOrgsService saveRoleOrgsService;
    @Autowired
    private SelectOrgTreePathService selectOrgTreePathService;
    @Autowired
    private SaveRoleAuthService saveRoleAuthService;
    @Autowired
    private SaveRoleConfigMenusBusiService saveRoleConfigMenusBusiService;
    @Autowired
    private DeleteRoleBusiService deleteRoleBusiService;
    @Autowired
    private SelectOverAllRolesPageService selectOverAllRolesPageService;
    @Autowired
    private SelectTenantRolesPageService selectTenantRolesPageService;
    @Autowired
    private SelectRoleInfoByIdService selectRoleInfoByIdService;
    @Autowired
    private SelectOrgRolesPageService selectOrgRolesPageService;
    @Autowired
    private SelectOrgStatusService selectOrgStatusService;
    @Autowired
    private SelectOrgByTenantIdBusiService selectOrgByTenantIdBusiService;
    @Autowired
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Autowired
    private SelectRoleStationService selectRoleStationService;

    @RequestMapping(value={"/alreadyAndNorUsers"})
    @BusiResponseBody
    public Object getAlreadyAndNorUsers(SelectAlreadyAndNorUsersReqBO reqBO) {
        if (reqBO.getOrgId() == null || reqBO.getRoleId() == null) {
            throw new ZTBusinessException("\u89d2\u8272id\u6216\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HasUserListBO hasAllUserListBO = this.selectAllUserByRoleId.selectAllUserByRoleId(reqBO);
        List allUser = hasAllUserListBO.getAllUser();
        HasUserListBO hasUserListBO = this.selectAlreadyUser.selectAlreadyDistributeUser(reqBO);
        List user = hasUserListBO.getAllUser();
        allUser.removeAll(user);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(user);
        orgDistributeRspBO.setNotGrantRoles(allUser);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/alreadyAndNorRoles"})
    @BusiResponseBody
    public Object alreadyAndNorRoles(SelectAlreadyAndNorRolesReqBO reqBO) {
        if (reqBO.getStationId() == null) {
            throw new ZTBusinessException("\u5c97\u4f4did[stationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SelectUserOperateRolesReqBO selectUserOperateRolesReqBO = new SelectUserOperateRolesReqBO();
        SelectUserOperateRolesRspBO selectUserOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(selectUserOperateRolesReqBO);
        List allRoles = selectUserOperateRolesRspBO.getUserOperateRoles();
        SelectRoleStationServiceReqBO selectRoleStationServiceReqBO = new SelectRoleStationServiceReqBO();
        selectRoleStationServiceReqBO.setStationId(reqBO.getStationId());
        SelectRoleStationServiceRspBO hasRolesListBO = this.selectRoleStationService.selectRoleStation(selectRoleStationServiceReqBO);
        List hasAuthRoles = hasRolesListBO.getRows();
        ArrayList<RoleBO> allRoleList = new ArrayList<RoleBO>();
        for (Object bo : allRoles) {
            RoleBO roleBO = new RoleBO();
            if (bo.getRoleId() != null) {
                roleBO.setRoleId(bo.getRoleId());
            }
            if (!StringUtils.isEmpty((Object)bo.getRoleName())) {
                roleBO.setRoleName(bo.getRoleName());
            }
            allRoleList.add(roleBO);
        }
        ArrayList<RoleBO> hasAuthRoleList = new ArrayList<RoleBO>();
        for (AuthStationRolesBO bo : hasAuthRoles) {
            RoleBO roleBO = new RoleBO();
            if (bo.getRoleId() != null) {
                roleBO.setRoleId(bo.getRoleId());
            }
            if (!StringUtils.isEmpty((Object)bo.getRoleName())) {
                roleBO.setRoleName(bo.getRoleName());
            }
            hasAuthRoleList.add(roleBO);
        }
        allRoleList.removeAll(hasAuthRoleList);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasAuthRoleList);
        orgDistributeRspBO.setNotGrantRoles(allRoleList);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/commit"})
    @BusiResponseBody
    public Object commit(SaveOrgGrantUsersReqBO reqBO) {
        this.saveOrgGrantUsersBusiService.saveOrgGrantUsers(reqBO);
        return null;
    }

    @RequestMapping(value={"/alreadyAndNorOrg"})
    @BusiResponseBody
    public Object getAlreadyAndNorOrg(SelectAlreadyAndNorUsersReqBO reqBO) {
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(reqBO.getOrgId());
        LinkedList<OrgBO> allOrgs = new LinkedList<OrgBO>();
        TreePathRspBOS treePathRspBOS = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS != null && treePathRspBOS.getTreePathRspBOList() != null && treePathRspBOS.getTreePathRspBOList().size() > 0) {
            for (TreePathRspBO bo : treePathRspBOS.getTreePathRspBOList()) {
                OrgBO orgBO = new OrgBO();
                orgBO.setOrgId(bo.getOrganisationId());
                orgBO.setTitle(bo.getTitle());
                orgBO.setOrgTreePath(bo.getOrgTreePath());
                allOrgs.add(orgBO);
            }
        }
        HasAllUserListBO hasOrgsByRole = this.selectHasOrgsByRoleService.getHasOrgsByRole(reqBO);
        List hasOrgs = hasOrgsByRole.getAllUser();
        allOrgs.removeAll(hasOrgs);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasOrgs);
        orgDistributeRspBO.setNotGrantRoles(allOrgs);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/orgCommit"})
    @BusiResponseBody
    public Object orgCommit(SaveRoleOrgsReqBO reqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            reqBO.setAuthIdentity("auth:org:manage");
        }
        this.saveRoleOrgsService.saveRoleOrgs(reqBO);
        return null;
    }

    @RequestMapping(value={"/creatRole"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u65b0\u589e")
    public Object creatRole(CreatRoleReqBO creatRoleReqBO) throws Exception {
        SelectOrgByTenantIdRspBO select;
        SelectOrgByTenantIdReqBO reqBO;
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_OVERALL);
                creatRoleReqBO.setOrgTreePath(null);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
                reqBO = new SelectOrgByTenantIdReqBO();
                reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
                select = this.selectOrgByTenantIdBusiService.select(reqBO);
                if (select != null) {
                    creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
                }
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_PART);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
                reqBO = new SelectOrgByTenantIdReqBO();
                reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
                select = this.selectOrgByTenantIdBusiService.select(reqBO);
                if (select != null) {
                    creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
                }
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
            reqBO = new SelectOrgByTenantIdReqBO();
            reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
            select = this.selectOrgByTenantIdBusiService.select(reqBO);
            if (select != null) {
                creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            creatRoleReqBO.setUserAuthIdentity("auth:org:manage");
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_MANAGER);
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        creatRoleReqBO.setRoleId(Long.valueOf(l));
        this.creatRoleBusiService.creatRole(creatRoleReqBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u505c\u7528")
    public Object stopRole(RoleStatusReqBO roleStatusReqBO) {
        this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/restart"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u542f\u7528")
    public Object restartRole(RoleStatusReqBO roleStatusReqBO) {
        this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/selectRole"})
    @BusiResponseBody
    public Object selectRole(SelectRoleByIdReqBO selectRoleByIdReqBO) {
        return this.selectRoleByIdBusiService.selectRoleById(selectRoleByIdReqBO);
    }

    @RequestMapping(value={"/updateRole"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateRole(UpdateRoleByIDReqBO updateRoleByIDReqBO) throws Exception {
        try {
            SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
            reqBO.setRoleId(updateRoleByIDReqBO.getRoleId());
            RoleInfoBO rspBO = this.selectRoleInfoByIdService.selectById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u89d2\u8272", (Throwable)e);
        }
        this.updateRoleByIDBusiService.updateRoleByID(updateRoleByIDReqBO);
        return null;
    }

    @RequestMapping(value={"/selectRoles"})
    @BusiResponseBody
    public RspPage<SearchRolesRspBO> selectRoles(SelectRolesPageReqBO rolesPageReqBO) {
        UserInfo user;
        RspPage rsp = new RspPage();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectRolesPageBusiService.selectRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectOverAllRolesPageService.selectOverAllRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectTenantRolesPageService.selectTenantRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage") && (user = SecurityHelper.getCurrentUser()).getUserId() != null) {
            rolesPageReqBO.setmUserId(user.getUserId());
            return this.selectOrgRolesPageService.selectOrgRolesPage(rolesPageReqBO);
        }
        return rsp;
    }

    @RequestMapping(value={"/authUserCommit"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u7528\u6237\u6388\u6743")
    public Object authUserCommit(SaveUserAuthReqBO saveUserAuthReqBO) {
        if (StringUtils.isEmpty((Object)saveUserAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            saveUserAuthReqBO.setAuthIdentity("auth:org:manage");
        }
        this.saveRoleAuthService.saveRoleAuthService(saveUserAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/configMenus"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u914d\u7f6e")
    public Object configMenus(SaveRoleConfigMenusReqBO saveRoleConfigMenusReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            saveRoleConfigMenusReqBO.setOrgTreePath(saveRoleConfigMenusReqBO.getOrgTreePath());
            saveRoleConfigMenusReqBO.setAuthIdentity("auth:org:manage");
            this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        } else {
            this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(DeleteRoleReqBO deleteRoleReqBO) {
        try {
            SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
            reqBO.setRoleId(deleteRoleReqBO.getRoleId());
            reqBO.setAuthIdentity(deleteRoleReqBO.getRoleAuthIdentity());
            RoleInfoBO rspBO = this.selectRoleInfoByIdService.selectById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            deleteRoleReqBO.setRoleAuthIdentity("auth:org:manage");
        }
        this.deleteRoleBusiService.deleteRole(deleteRoleReqBO);
        return null;
    }

    @RequestMapping(value={"/batchStop"})
    @BusiResponseBody
    public Object batchStopRoles(@RequestParam(value="roles") String roles) {
        List longList = JSON.parseArray((String)roles, Long.class);
        for (Long role : longList) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/batchRestart"})
    @BusiResponseBody
    public Object restartRole(@RequestParam(value="roles") String roles) {
        List longList = JSON.parseArray((String)roles, Long.class);
        for (Long role : longList) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectOrgByTenantId"})
    @BusiResponseBody
    public Object select(SelectOrgByTenantIdReqBO reqBO) {
        return this.selectOrgByTenantIdBusiService.select(reqBO);
    }
}

