/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.utils;

import com.ohaotian.authority.config.MinioConfig;
import io.minio.BucketExistsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    @Autowired
    private MinioConfig prop;
    @Autowired
    private MinioClient minioClient;

    public Boolean bucketExists(String bucketName) {
        boolean found;
        try {
            found = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return found;
    }

    public Boolean makeBucket(String bucketName) {
        try {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Boolean removeBucket(String bucketName) {
        try {
            this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public List<Bucket> getAllBuckets() {
        try {
            return this.minioClient.listBuckets();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String upload(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        if (StringUtils.isBlank((CharSequence)originalFilename)) {
            throw new RuntimeException();
        }
        String fileName = UUID.randomUUID() + originalFilename.substring(originalFilename.lastIndexOf("."));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM/dd");
        String objectName = df.format(new Date()) + "/" + fileName;
        try {
            PutObjectArgs objectArgs = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.prop.getBucketName())).object(objectName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build();
            this.minioClient.putObject(objectArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return objectName;
    }

    public String preview(String fileName) {
        GetPresignedObjectUrlArgs build = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).method(Method.valueOf((String)"GET")).build();
        try {
            return this.minioClient.getPresignedObjectUrl(build);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Item> listObjects() {
        Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.prop.getBucketName())).build());
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            for (Result result : results) {
                items.add((Item)result.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return items;
    }

    public boolean remove(String fileName) {
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.prop.getBucketName())).object(fileName)).build());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

