/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.UserBO;
import com.ohaotian.authority.station.bo.SelectStationAlreadyAndNorUserReqBO;
import com.ohaotian.authority.station.service.SelectAllUserByStationIdService;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="service", serviceInterface=SelectAllUserByStationIdService.class)
public class SelectAllUserByStationIdServiceImpl
implements SelectAllUserByStationIdService {
    private static final Logger log = LoggerFactory.getLogger(SelectAllUserByStationIdServiceImpl.class);
    @Autowired
    private UserMapper userMapper;

    public HasUserListBO selectAllUserByStationId(SelectStationAlreadyAndNorUserReqBO reqBO) {
        List<Object> userBOS = new ArrayList();
        if (!StringUtils.isBlank((CharSequence)reqBO.getMemName())) {
            Page page = new Page(-1, -1);
            userBOS = this.userMapper.selectUserByOrgIdAndLoginName(reqBO.getOrgId(), reqBO.getMemName(), (Page<UserBO>)page);
        } else {
            userBOS = this.userMapper.selectUserByOrgId(reqBO.getOrgId());
        }
        HasUserListBO userListBO = new HasUserListBO();
        userListBO.setAllUser(userBOS);
        return userListBO;
    }

    public HasUserListBO selectAllUserByStationIdAndName(SelectStationAlreadyAndNorUserReqBO reqBO) {
        HasUserListBO hasUserListBO = new HasUserListBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<UserBO> userBOS = this.userMapper.selectUserByOrgIdAndLoginName(reqBO.getOrgId(), reqBO.getMemName(), (Page<UserBO>)page);
        HasUserListBO userListBO = new HasUserListBO();
        userListBO.setPageNo(page.getPageNo());
        userListBO.setTotal(page.getTotalPages());
        userListBO.setRecordsTotal(page.getTotalCount());
        userListBO.setAllUser(userBOS);
        return userListBO;
    }
}

