/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.StationMapper;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrgTreeNameService;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.station.bo.SelectStationPageReqBO;
import com.ohaotian.authority.station.bo.StationBO;
import com.ohaotian.authority.station.service.SelectStationsPageBusiService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Page;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="service", serviceInterface=SelectStationsPageBusiService.class)
public class SelectStationsPageBusiServiceImpl
implements SelectStationsPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectStationsPageBusiServiceImpl.class);
    @Autowired
    StationMapper stationMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectOrgTreeNameService selectOrgTreeNameService;

    public RspPage<StationBO> selectstationPage(SelectStationPageReqBO selectStationPageReqBO) {
        Page page = new Page(selectStationPageReqBO.getPageNo(), selectStationPageReqBO.getPageSize());
        List<StationBO> stations = this.stationMapper.selectStationPage(selectStationPageReqBO.getStationName(), selectStationPageReqBO.getTenantNameReq(), selectStationPageReqBO.getStatus(), selectStationPageReqBO.getTitle(), page);
        stations.forEach(bo -> {
            OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(bo.getOrgId());
            if (organisationPO != null) {
                OrganisationBO organisationBO = null;
                organisationBO = (OrganisationBO)BeanMapper.map((Object)organisationPO, OrganisationBO.class);
                String orgTreeName = this.selectOrgTreeNameService.selectOrgTreeName(organisationBO);
                bo.setOrgName(orgTreeName);
            }
        });
        RspPage rsp = new RspPage();
        rsp.setPageNo(selectStationPageReqBO.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(stations);
        return rsp;
    }
}

