/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.ManagerOrgMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.po.ManagerOrg;
import com.ohaotian.authority.po.Role;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.user.bo.AddUserListReqBO;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.bo.SelectUserByCellphoneBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.util.CommonUtils;
import com.ohaotian.authority.util.EncryptUtils;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="service", serviceInterface=AddManageUserService.class)
public class AddManageUserServiceImpl
implements AddManageUserService {
    private static final Logger log = LoggerFactory.getLogger(AddManageUserServiceImpl.class);
    @Value(value="${INITIAL_PASSWORD:ysyhl9T}")
    private String PASSWORD;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private ManagerOrgMapper managerOrgMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;
    @Value(value="${cellphone.switch:true}")
    private Boolean cellphoneSwitch;
    @Value(value="${cellphone.need.switch:true}")
    private Boolean cellphoneNeedSwitch;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Value(value="${admin.need.switch:false}")
    private Boolean adminNeedSwitch;
    @Autowired
    private EncryptUtils encryptUtils;

    @Transactional(rollbackFor={Exception.class})
    public Long insertUser(AddUserReqBO addUserReqBO) {
        UserPO userInfoPO;
        List<SelectUserByCellphoneBO> selectUserByCellphoneBOS;
        if (addUserReqBO.getPassCreate() == null) {
            addUserReqBO.setPassCreate(Integer.valueOf(1));
        }
        if (addUserReqBO.getPassCreate() == 2 && StringUtils.isEmpty((CharSequence)addUserReqBO.getPasswordReq())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.cellphoneSwitch.booleanValue() && (selectUserByCellphoneBOS = this.userMapper.selectUserByCellphone(addUserReqBO.getCellPhoneReq(), "true")) != null && selectUserByCellphoneBOS.size() > 0) {
            for (SelectUserByCellphoneBO userByCellphoneBO : selectUserByCellphoneBOS) {
                if (userByCellphoneBO.getUserId().equals(addUserReqBO.getAuthUserId())) continue;
                if (StringUtils.isNotEmpty((CharSequence)userByCellphoneBO.getType())) {
                    throw new ZTBusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u5360\u7528");
                }
                if (!StringUtils.isNotEmpty((CharSequence)userByCellphoneBO.getRegisterType())) continue;
                throw new ZTBusinessException("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
            }
        }
        if (this.cellphoneNeedSwitch.booleanValue() && StringUtils.isEmpty((CharSequence)addUserReqBO.getCellPhoneReq())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addUserReqBO.getType().equals("auth:tenant:manage") && this.adminNeedSwitch.booleanValue() && (userInfoPO = this.userMapper.selectTenantManage(addUserReqBO.getTenantIdReq())) != null) {
            throw new ZTBusinessException("\u521b\u5efa\u7528\u6237\u5931\u8d25\uff0c\u8be5\u79df\u6237\u5df2\u6709\u7ba1\u7406\u5458");
        }
        UserPO userPO = new UserPO();
        userPO.setUserId(addUserReqBO.getAuthUserId());
        userPO.setSource(0);
        userPO.setDetailSource(addUserReqBO.getDetialSource());
        userPO.setStatus(0);
        userPO.setType(addUserReqBO.getType());
        userPO.setRegisterType(addUserReqBO.getRegisterType());
        userPO.setOrgId(addUserReqBO.getOrgIdReq());
        userPO.setTenantId(addUserReqBO.getTenantIdReq());
        userPO.setLoginName(addUserReqBO.getLoginNameReq());
        userPO.setName(addUserReqBO.getNameReq());
        userPO.setCellPhone(addUserReqBO.getCellPhoneReq());
        userPO.setEmail(addUserReqBO.getEmailReq());
        userPO.setmOrgId(addUserReqBO.getmOrgId());
        userPO.setCreateUserId(addUserReqBO.getUserId());
        userPO.setField1(addUserReqBO.getField1());
        if (addUserReqBO.getPassCreate() == null || addUserReqBO.getPassCreate() == 1) {
            userPO.setInitialPassword(this.PASSWORD);
        } else if (addUserReqBO.getPassCreate() == 2) {
            String encrypt = this.encryptUtils.encryptByType(addUserReqBO.getPasswordReq(), this.encryptType);
            String salt = SaltUtils.getSerialNo(8);
            String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
            userPO.setSalt(salt);
            userPO.setPassword(pwd);
        } else if (addUserReqBO.getPassCreate() == 3) {
            String stringRandom = CommonUtils.getStringRandom(6);
            String encrypt = this.encryptUtils.encryptByType(stringRandom, this.encryptType);
            String salt = SaltUtils.getSerialNo(8);
            String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
            userPO.setSalt(salt);
            userPO.setPassword(pwd);
        }
        try {
            this.userMapper.insertUser(userPO);
        }
        catch (DuplicateKeyException e) {
            throw new ZTBusinessException("\u7528\u6237\u767b\u5f55\u540d\u4e0d\u80fd\u91cd\u590d");
        }
        Role role = this.roleMapper.selectRoleByAuthId(addUserReqBO.getType());
        AuthDistribute authDistribute = new AuthDistribute();
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        authDistribute.setAuthId(l);
        authDistribute.setUserId(userPO.getUserId());
        authDistribute.setRoleId(role.getRoleId());
        authDistribute.setDisFlag(1);
        this.authDistributeMapper.insert(authDistribute);
        if (addUserReqBO.getType().equals("auth:tenant:manage")) {
            LinkedList<Long> orgId = new LinkedList<Long>();
            TenantRspBO tenantRspBO = this.tenantMapper.selectTenantById(addUserReqBO.getTenantIdReq());
            orgId.add(tenantRspBO.getOrgRootId());
            this.organizationMapper.updateOrgMuserId(orgId, addUserReqBO.getAuthUserId());
            ManagerOrg managerOrg = new ManagerOrg();
            managerOrg.setOrgId(tenantRspBO.getOrgRootId());
            managerOrg.setUserId(addUserReqBO.getAuthUserId());
            this.managerOrgMapper.insert(managerOrg);
        }
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "add_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userPO.getUserId() + "");
        this.dataSend.send(proxyMessage);
        return userPO.getUserId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long insertBatchUser(AddUserListReqBO addUserListReqBO) throws ZTBusinessException {
        Role role;
        Long roleId = 0L;
        if (!StringUtils.isBlank((CharSequence)addUserListReqBO.getRoleCode()) && null != (role = this.roleMapper.selectRoleByAuthId(addUserListReqBO.getRoleCode()))) {
            roleId = role.getRoleId();
        }
        ArrayList<UserPO> addUserPOS = new ArrayList<UserPO>();
        ArrayList<AuthDistribute> addAuthDistributes = new ArrayList<AuthDistribute>();
        ArrayList<ProxyMessage> proxyMessages = new ArrayList<ProxyMessage>();
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        for (AddUserReqBO addUserReqBO : addUserListReqBO.getAddUserReqBOS()) {
            UserPO userPO = new UserPO();
            if (null != addUserReqBO.getPassCreate() && addUserReqBO.getPassCreate() == 2) {
                String encrypt = this.encryptUtils.encryptByType(addUserReqBO.getPasswordReq(), this.encryptType);
                String salt = SaltUtils.getSerialNo(8);
                String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
                userPO.setSalt(salt);
                userPO.setPassword(pwd);
            } else {
                addUserReqBO.setPassCreate(Integer.valueOf(1));
                userPO.setInitialPassword(this.PASSWORD);
            }
            userPO.setUserId(addUserReqBO.getAuthUserId());
            userPO.setSource(0);
            userPO.setDetailSource(addUserReqBO.getDetialSource());
            userPO.setStatus(0);
            userPO.setType(addUserReqBO.getType());
            userPO.setRegisterType(addUserReqBO.getRegisterType());
            userPO.setOrgId(addUserReqBO.getOrgIdReq());
            userPO.setTenantId(addUserReqBO.getTenantIdReq());
            userPO.setLoginName(addUserReqBO.getLoginNameReq());
            userPO.setName(addUserReqBO.getNameReq());
            userPO.setCellPhone(addUserReqBO.getCellPhoneReq());
            userPO.setEmail(addUserReqBO.getEmailReq());
            userPO.setmOrgId(addUserReqBO.getmOrgId());
            userPO.setCreateUserId(addUserReqBO.getUserId());
            userPO.setField1(addUserReqBO.getField1());
            addUserPOS.add(userPO);
            Role role2 = null;
            if (roleMap.get(addUserReqBO.getType()) == null) {
                role2 = this.roleMapper.selectRoleByAuthId(addUserReqBO.getType());
                roleMap.put(addUserReqBO.getType(), role2);
            } else {
                role2 = (Role)roleMap.get(addUserReqBO.getType());
            }
            AuthDistribute authDistribute = new AuthDistribute();
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            authDistribute.setAuthId(l);
            authDistribute.setUserId(userPO.getUserId());
            authDistribute.setRoleId(role2.getRoleId());
            authDistribute.setDisFlag(1);
            addAuthDistributes.add(authDistribute);
            if (!roleId.equals(0L)) {
                AuthDistribute roleDistribute = new AuthDistribute();
                roleDistribute.setAuthId(Sequence.getInstance().nextId());
                roleDistribute.setUserId(userPO.getUserId());
                roleDistribute.setRoleId(roleId);
                roleDistribute.setDisFlag(1);
                addAuthDistributes.add(roleDistribute);
            }
            ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "add_" + Constants.MQ_DATA_SEND_TAG_USER + "_" + userPO.getTenantId(), userPO.getUserId() + "");
            proxyMessages.add(proxyMessage);
        }
        this.userMapper.insertBatch(addUserPOS);
        this.authDistributeMapper.insertBatch(addAuthDistributes);
        for (ProxyMessage proxyMessage : proxyMessages) {
            this.dataSend.send(proxyMessage);
        }
        return 1L;
    }
}

