/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.ChangePwdReqBO;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.authority.util.EncryptUtils;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="service", serviceInterface=ChangePwdByUserIdService.class)
public class ChangePwdByUserIdServiceImpl
implements ChangePwdByUserIdService {
    private static final Logger log = LoggerFactory.getLogger(ChangePwdByUserIdServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(ChangePwdByUserIdServiceImpl.class);
    @Autowired
    UserMapper userMapper;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${CHECK_LASTPWD_FLAG:true}")
    private Boolean CHECK_LASTPWD_FLAG;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public void changePasswordByUserId(ChangePwdReqBO changePwdReqBO) {
        UserPO user = this.userMapper.selectUserInfo(changePwdReqBO.getUserId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{user.getInitialPassword()})) {
            if (!changePwdReqBO.getOldPassword().equals(user.getInitialPassword())) throw new ZTBusinessException("\u539f\u5bc6\u7801\u586b\u5199\u9519\u8bef\uff01");
            if (changePwdReqBO.getNewPassword().equals(user.getInitialPassword())) {
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
            }
        } else if (!this.encryptType.equals("SHA-256")) {
            String decryptFirst = this.encryptUtils.decryptByType(user.getPassword(), this.encryptType);
            this.logger.info("\u7b2c\u4e00\u6b21\u89e3\u5bc6\uff1a" + decryptFirst);
            this.logger.info("\u53bb\u6389\u76d0\u503c\uff1a" + decryptFirst.substring(0, decryptFirst.length() - user.getSalt().length()));
            String decryptSecond = this.encryptUtils.decryptByType(decryptFirst.substring(0, decryptFirst.length() - user.getSalt().length()), this.encryptType);
            this.logger.info("\u7b2c\u4e8c\u6b21\u89e3\u5bc6\uff1adecryptSecond = {},oldpassword = {},newpassword={}", new Object[]{decryptSecond, changePwdReqBO.getOldPassword(), changePwdReqBO.getNewPassword()});
            if (user.getPassword() != null && !decryptSecond.equals(changePwdReqBO.getOldPassword())) {
                this.logger.info("\u5339\u914d\u6210\u529f:{},{)", (Object)decryptSecond, (Object)changePwdReqBO.getOldPassword());
                throw new ZTBusinessException("\u539f\u5bc6\u7801\u586b\u5199\u9519\u8bef\uff01");
            }
            if (decryptSecond.equals(changePwdReqBO.getNewPassword())) {
                this.logger.info("\u5339\u914d\u6210\u529f:{},{}", (Object)decryptSecond, (Object)changePwdReqBO.getNewPassword());
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
            }
            if (this.CHECK_LASTPWD_FLAG.equals(true) && !StringUtils.isEmpty((CharSequence)user.getField4()) && !StringUtils.isEmpty((CharSequence)user.getField3())) {
                String decryptFirstField3 = this.encryptUtils.decryptByType(user.getField3(), this.encryptType);
                this.logger.info("\u4e0a\u4e00\u6b21\u7b2c\u4e00\u6b21\u89e3\u5bc6\uff1a" + decryptFirstField3);
                this.logger.info("\u53bb\u6389\u76d0\u503c\uff1a" + decryptFirstField3.substring(0, decryptFirstField3.length() - user.getField4().length()));
                String decryptSecondField3 = this.encryptUtils.decryptByType(decryptFirstField3.substring(0, decryptFirstField3.length() - user.getField4().length()), this.encryptType);
                this.logger.info("\u4e0a\u4e00\u6b21\u7b2c\u4e8c\u6b21\u89e3\u5bc6\uff1adecryptSecond = {},oldpassword = {},newpassword={}", new Object[]{decryptSecondField3, changePwdReqBO.getOldPassword(), changePwdReqBO.getNewPassword()});
                if (user.getField3() != null && decryptSecondField3.equals(changePwdReqBO.getNewPassword())) {
                    this.logger.info("\u5339\u914d\u6210\u529f", (Object)decryptSecond, (Object)changePwdReqBO.getOldPassword());
                    throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u4e0a\u4e00\u6b21\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
                }
            }
        } else {
            String newPwd;
            String oldencrypt = this.encryptUtils.encryptByType(changePwdReqBO.getOldPassword(), this.encryptType);
            String pwd = this.encryptUtils.encryptByType(oldencrypt + user.getSalt(), this.encryptType);
            if (!pwd.equals(user.getPassword())) {
                throw new ZTBusinessException("\u539f\u5bc6\u7801\u586b\u5199\u9519\u8bef\uff01");
            }
            String newPwdEncrypt = this.encryptUtils.encryptByType(changePwdReqBO.getNewPassword(), this.encryptType);
            String newpwd = this.encryptUtils.encryptByType(newPwdEncrypt + user.getSalt(), this.encryptType);
            if (newpwd.equals(user.getPassword())) {
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
            }
            if (this.CHECK_LASTPWD_FLAG.equals(true) && !StringUtils.isEmpty((CharSequence)user.getField4()) && !StringUtils.isEmpty((CharSequence)user.getField3()) && (newPwd = this.encryptUtils.encryptByType(newPwdEncrypt + user.getField4(), this.encryptType)).equals(user.getField3())) {
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u4e0a\u4e00\u6b21\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
            }
        }
        String newEncrypt = this.encryptUtils.encryptByType(changePwdReqBO.getNewPassword(), this.encryptType);
        String newSalt = SaltUtils.getSerialNo(8);
        String newPwd = this.encryptUtils.encryptByType(newEncrypt + newSalt, this.encryptType);
        UserPO newUser = new UserPO();
        newUser.setUserId(changePwdReqBO.getUserId());
        newUser.setSalt(newSalt);
        newUser.setPassword(newPwd);
        Date now = new Date();
        newUser.setEffDate(now);
        this.userMapper.updateByPrimaryKeySelective(newUser);
    }
}

