/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.workday;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.authority.dao.SpecialDateMapper;
import com.ohaotian.authority.util.WorkDayUtils;
import com.ohaotian.authority.workday.bo.SelectHandleWorkdayCountWebReqBO;
import com.ohaotian.authority.workday.bo.SelectHandleWorkdayCountWebRspBO;
import com.ohaotian.authority.workday.bo.SpecialDateBO;
import com.ohaotian.authority.workday.service.SelectHandleWorkdayCountWebService;
import com.ohaotian.plugin.common.util.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="service", serviceInterface=SelectHandleWorkdayCountWebService.class)
public class SelectHandleWorkdayCountWebServiceImpl
implements SelectHandleWorkdayCountWebService {
    private static final Logger log = LoggerFactory.getLogger(SelectHandleWorkdayCountWebServiceImpl.class);
    @Autowired
    private SpecialDateMapper specialDateMapper;

    public SelectHandleWorkdayCountWebRspBO selectHandleDays(SelectHandleWorkdayCountWebReqBO reqBO) {
        Date startdate = DateUtils.strToDate((String)reqBO.getStartTime());
        Date enddate = DateUtils.strToDate((String)reqBO.getEndTime());
        Long days = WorkDayUtils.workdayCount(reqBO.getStartTime(), reqBO.getEndTime());
        List<SpecialDateBO> specialDateBOS = this.specialDateMapper.selectHolidayCount(startdate, enddate);
        List<SpecialDateBO> weekDayCount = this.specialDateMapper.selectWeekDayCount(startdate, enddate);
        SpecialDateBO specialDate = this.specialDateMapper.selectBySpecialDay(reqBO.getStartTime());
        Long l = days - (long)specialDateBOS.size() - (long)WorkDayUtils.getWeekends(startdate, enddate) + (long)weekDayCount.size();
        Long day = null;
        int dayofweek = WorkDayUtils.getDayofweek(reqBO.getStartTime());
        if (dayofweek > 1 && dayofweek < 7) {
            day = specialDate == null ? Long.valueOf(l - 1L) : l;
        } else if (dayofweek == 1 || dayofweek == 7) {
            day = specialDate != null && specialDate.getDayType().equals(3) ? Long.valueOf(l - 1L) : l;
        }
        SelectHandleWorkdayCountWebRspBO rspBO = new SelectHandleWorkdayCountWebRspBO();
        rspBO.setWorkdays(day);
        return rspBO;
    }
}

