/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.utils;

import com.ohaotian.plugin.security.utils.UserAgent;
import org.apache.commons.lang3.StringUtils;

public class UserAgentUtil {
    public static UserAgent getUserAgent(String userAgent) {
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return null;
        }
        if (userAgent.contains("Windows")) {
            if (userAgent.contains("Windows NT 6.2")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "8", null);
            }
            if (userAgent.contains("Windows NT 6.1")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "7", null);
            }
            if (userAgent.contains("Windows NT 6.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "Vista", null);
            }
            if (userAgent.contains("Windows NT 5.2")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "XP", "x64 Edition");
            }
            if (userAgent.contains("Windows NT 5.1")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "XP", null);
            }
            if (userAgent.contains("Windows NT 5.01")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "2000", "SP1");
            }
            if (userAgent.contains("Windows NT 5.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "2000", null);
            }
            if (userAgent.contains("Windows NT 4.0")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "NT 4.0", null);
            }
            if (userAgent.contains("Windows 98; Win 9x 4.90")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "ME", null);
            }
            if (userAgent.contains("Windows 98")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "98", null);
            }
            if (userAgent.contains("Windows 95")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "95", null);
            }
            if (userAgent.contains("Windows CE")) {
                return UserAgentUtil.judgeBrowser(userAgent, "Windows", "CE", null);
            }
            return UserAgentUtil.judgeBrowser(userAgent, "Windows", "10", null);
        }
        if (userAgent.contains("Mac OS X")) {
            if (userAgent.contains("iPod")) {
                return UserAgentUtil.judgeBrowser(userAgent, "iPod", null, null);
            }
            if (userAgent.contains("iPad")) {
                return UserAgentUtil.judgeBrowser(userAgent, "iPad", null, null);
            }
            if (userAgent.contains("iPhone")) {
                return UserAgentUtil.judgeBrowser(userAgent, "iPhone", null, null);
            }
            return UserAgentUtil.judgeBrowser(userAgent, "Mac OS X", null, null);
        }
        return UserAgentUtil.judgeBrowser(userAgent, "OTHER", "10", null);
    }

    private static UserAgent judgeBrowser(String userAgent, String platformType, String platformSeries, String platformVersion) {
        if (userAgent.contains("Chrome")) {
            String temp = userAgent.substring(userAgent.indexOf("Chrome/") + 7);
            String chromeVersion = null;
            chromeVersion = temp.indexOf(" ") < 0 ? temp : temp.substring(0, temp.indexOf(" "));
            return new UserAgent("Chrome", chromeVersion, platformType, platformSeries, platformVersion);
        }
        if (userAgent.contains("Firefox")) {
            String temp = userAgent.substring(userAgent.indexOf("Firefox/") + 8);
            String ffVersion = null;
            ffVersion = temp.indexOf(" ") < 0 ? temp : temp.substring(0, temp.indexOf(" "));
            return new UserAgent("Firefox", ffVersion, platformType, platformSeries, platformVersion);
        }
        if (userAgent.contains("MSIE")) {
            if (userAgent.contains("MSIE 10.0")) {
                return new UserAgent("Internet Explorer", "10", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("MSIE 9.0")) {
                return new UserAgent("Internet Explorer", "9", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("MSIE 8.0")) {
                return new UserAgent("Internet Explorer", "8", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("MSIE 7.0")) {
                return new UserAgent("Internet Explorer", "7", platformType, platformSeries, platformVersion);
            }
            if (userAgent.contains("MSIE 6.0")) {
                return new UserAgent("Internet Explorer", "6", platformType, platformSeries, platformVersion);
            }
        } else {
            return new UserAgent(null, null, platformType, platformSeries, platformVersion);
        }
        return null;
    }
}

