/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.utils;

import com.ohaotian.plugin.security.utils.ExceptionHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class UtilString
extends StringUtils {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final char SEPARATOR = '_';
    private static final String CHARSET_NAME = "UTF-8";

    public static String defaultIfNull(String object, String defaultValue) {
        return object == null ? defaultValue : object;
    }

    public static final Pattern compileRegex(String regex) {
        Pattern pattern = PATTERN_CACHE.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            PATTERN_CACHE.put(regex, pattern);
        }
        return pattern;
    }

    public static boolean isEmptyObject(Object obj) {
        return obj == null || "".equals(obj.toString());
    }

    public static boolean isTrue(Object obj) {
        return "true".equals(String.valueOf(obj));
    }

    public static boolean isNumber(Object obj) {
        if (obj instanceof Number) {
            return true;
        }
        return UtilString.isInt(obj) || UtilString.isDouble(obj);
    }

    public static boolean isInt(Object obj) {
        if (UtilString.isEmptyObject(obj)) {
            return false;
        }
        if (obj instanceof Integer) {
            return true;
        }
        return obj.toString().matches("[-+]?\\d+");
    }

    public static boolean isDouble(Object obj) {
        if (UtilString.isEmptyObject(obj)) {
            return false;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return true;
        }
        return UtilString.compileRegex("[-+]?\\d+\\.\\d+").matcher(obj.toString()).matches();
    }

    public static boolean isBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return true;
        }
        String strVal = String.valueOf(obj);
        return "true".equalsIgnoreCase(strVal) || "false".equalsIgnoreCase(strVal);
    }

    public static int toInt(Object object, int defaultValue) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (UtilString.isInt(object)) {
            return Integer.parseInt(object.toString());
        }
        if (UtilString.isDouble(object)) {
            return (int)Double.parseDouble(object.toString());
        }
        return defaultValue;
    }

    public static int toInt(Object object) {
        return UtilString.toInt(object, 0);
    }

    public static long toLong(Object object, long defaultValue) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (UtilString.isInt(object)) {
            return Long.parseLong(object.toString());
        }
        if (UtilString.isDouble(object)) {
            return (long)Double.parseDouble(object.toString());
        }
        return defaultValue;
    }

    public static long toLong(Object object) {
        return UtilString.toLong(object, 0L);
    }

    public static double toDouble(Object object, double defaultValue) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (UtilString.isNumber(object)) {
            return Double.parseDouble(object.toString());
        }
        if (null == object) {
            return defaultValue;
        }
        return 0.0;
    }

    public static double toDouble(Object object) {
        return UtilString.toDouble(object, 0.0);
    }

    public static String concatWithMarkAndSplit(String mark, String split, Collection more) {
        StringBuilder buf = new StringBuilder();
        if (more == null || more.isEmpty()) {
            return buf.toString();
        }
        int i = 0;
        for (Object obj : more) {
            if (i != 0) {
                buf.append(mark).append(obj).append(mark).append(split);
            }
            buf.append(mark).append(obj).append(mark);
            ++i;
        }
        return buf.toString();
    }

    public static String concat(Collection more) {
        return UtilString.concatWithSpilt("", more);
    }

    public static String concatWithSpilt(String split, Collection more) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Object obj : more) {
            if (i != 0) {
                buf.append(split);
            }
            buf.append(obj);
            ++i;
        }
        return buf.toString();
    }

    public static String concat(Object ... more) {
        return UtilString.concatWithSpilt("", more);
    }

    public static String concatWithSpilt(String split, Object ... more) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < more.length; ++i) {
            if (i != 0) {
                buf.append(split);
            }
            buf.append(more[i]);
        }
        return buf.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = UtilString.toCamelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String toUnderScoreCase(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i > 0 && Character.isUpperCase(c)) {
                if (!upperCase || !nextUpperCase) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String abbr(String str, int length) {
        if (str == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            int currentLength = 0;
            for (char c : UtilString.replaceHtml(StringEscapeUtils.unescapeHtml4((String)str)).toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("GBK").length) > length - 3) {
                    sb.append("...");
                    break;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String replaceHtml(String html) {
        if (UtilString.isBlank((CharSequence)html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static String javascriptGetValueStyle(String objectString) {
        StringBuilder result = new StringBuilder();
        StringBuilder val = new StringBuilder();
        String[] vals = UtilString.split((String)objectString, (String)".");
        for (int i = 0; i < vals.length; ++i) {
            val.append("." + vals[i]);
            result.append("!" + val.substring(1) + "?'':");
        }
        result.append(val.substring(1));
        return result.toString();
    }

    public static String format(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        return ft.getMessage();
    }

    public static String urlEncode(String part) {
        try {
            return URLEncoder.encode(part, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionHelper.unchecked(e);
        }
    }

    private UtilString() {
    }
}

