/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterRequestWrapper.class);
    private String requestBody;
    private Map<String, String[]> params = Maps.newHashMapWithExpectedSize((int)16);

    ParameterRequestWrapper(HttpServletRequest request) {
        super(request);
        this.params.putAll(request.getParameterMap());
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        LOGGER.debug("ParameterRequestWrapper---\u5305\u88c5\u7528\u6237\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)userInfo));
        LOGGER.debug("ParameterRequestWrapper---params\uff1a" + JSON.toJSONString(this.params));
        if (userInfo != null) {
            for (Map.Entry<String, Object> entry : ParameterRequestWrapper.transBean2Map(userInfo).entrySet()) {
                if (this.params.get(entry.getKey()) != null) continue;
                this.addParameter(entry.getKey(), entry.getValue());
            }
        }
        if (request.getContentType() != null && request.getContentType().contains("application/json")) {
            StringBuilder stringBuilder;
            block30: {
                stringBuilder = new StringBuilder();
                try (ServletInputStream inputStream = request.getInputStream();){
                    if (inputStream == null) break block30;
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                        int bytesRead;
                        char[] charBuffer = new char[128];
                        while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                            stringBuilder.append(charBuffer, 0, bytesRead);
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error("\u83b7\u53d6\u5165\u53c2\u8f93\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            this.requestBody = stringBuilder.toString();
        }
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestBody == null) {
            return super.getInputStream();
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)this.requestBody);
        }
        catch (Exception e) {
            LOGGER.error("\u5165\u53c2\u4e0d\u662fJSON\u683c\u5f0f\uff0c\u4e0d\u5305\u88c5\u7528\u6237\u4fe1\u606f");
        }
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (jsonObject != null && userInfo != null) {
            JSONObject userJson = (JSONObject)JSON.toJSON(ParameterRequestWrapper.transBean2Map(userInfo));
            userJson.putAll((Map)jsonObject);
            this.requestBody = userJson.toJSONString();
        }
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.requestBody.getBytes());
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    private void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.params.put(name, (String[])value);
            } else if (value instanceof String) {
                this.params.put(name, new String[]{(String)value});
            } else {
                this.params.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    private static Map<String, Object> transBean2Map(Object obj) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                String key = property.getName();
                if ("class".equals(key) || (getter = property.getReadMethod()) == null) continue;
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7528\u6237\u4fe1\u606f\u8f6cmap\u5931\u8d25 ", (Throwable)e);
        }
        return map;
    }
}

