/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.utils;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.security.utils.Resources;
import com.ohaotian.plugin.security.utils.UtilFile;
import com.ohaotian.plugin.security.utils.UtilString;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class CaptchaUtil {
    private static Logger log = LoggerFactory.getLogger(CaptchaUtil.class);
    private static final int SHADOW_WIDTH = 2;
    private static final int LIGHT_HEIGHT_WIDTH = 2;
    private static final int ARC = 10;
    private static final String PIC_SUFFIX = ".png";
    private static final String PNG_SUFFIX = "png";
    private static final Color clrGlowInnerHi = new Color(253, 239, 175, 148);
    private static final Color clrGlowInnerLo = new Color(255, 209, 0);
    private static final Color clrGlowOuterHi = new Color(253, 239, 175, 124);
    private static final Color clrGlowOuterLo = new Color(255, 179, 0);
    @Value(value="${picVfCodeExpTime:300}")
    private int picVfCodeExpTime;
    private int tailoringWidth = 50;
    private int tailoringHeight = 50;
    private int locationX = 0;
    private int locationY = 0;
    @Autowired
    private CacheClient cacheService;

    public Map<String, String> createCaptchaImage(String host, String sourceImageName, byte[] imageData) throws IOException {
        String sourceName = sourceImageName.substring(sourceImageName.lastIndexOf("/") + 1);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        log.info("\u5f00\u59cb\u521b\u5efa\u6ed1\u52a8\u9a8c\u8bc1\u7801\u76f8\u5173\u56fe\u7247----\u8bf7\u6c42\u5730\u5740\u4e3a:{}", (Object)host);
        InputStream sourceImageInputStream = UtilFile.byte2Input(imageData);
        if (Objects.isNull(sourceImageInputStream)) {
            log.warn("\u8bfb\u53d6\u539f\u59cb\u56fe\u7247\u5f02\u5e38:{}", (Object)sourceImageName);
            return resultMap;
        }
        BufferedImage bufferedImage = ImageIO.read(sourceImageInputStream);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (width <= this.tailoringWidth * 2 || height <= this.tailoringHeight) {
            log.warn("\u539f\u59cb\u56fe\u7247\u4e0d\u7b26\u5408\u9ed8\u8ba4\u5c3a\u5bf8:{}*{}", (Object)width, (Object)height);
            return resultMap;
        }
        Random random = new Random();
        this.locationX = random.nextInt(width - this.tailoringWidth * 2) + this.tailoringWidth;
        this.locationY = random.nextInt(height - this.tailoringHeight);
        BufferedImage tailoringImageBuffer = this.tailoringImage(imageData);
        List<Shape> shapes = this.createSmallShape();
        if (shapes.isEmpty()) {
            log.error("\u751f\u6210\u526a\u88c1\u5c0f\u56fe\u968f\u673a\u5f62\u72b6\u5f02\u5e38\uff01");
            return resultMap;
        }
        Shape area = shapes.get(0);
        Shape bigarea = shapes.get(1);
        BufferedImage bfm1 = new BufferedImage(this.tailoringWidth, this.tailoringHeight, 2);
        BufferedImage bfm2 = new BufferedImage(this.tailoringWidth, this.tailoringHeight, 2);
        for (int i = 0; i < this.tailoringWidth; ++i) {
            for (int j = 0; j < this.tailoringHeight; ++j) {
                if (area.contains(i, j)) {
                    bfm1.setRGB(i, j, tailoringImageBuffer.getRGB(i, j));
                }
                if (!bigarea.contains(i, j)) continue;
                bfm2.setRGB(i, j, Color.black.getRGB());
            }
        }
        BufferedImage resultImgBuff = this.dealLightAndShadow(bfm1, area);
        String smallFileName = this.createSmallImg(resultImgBuff);
        String bigImgName = this.createBigImg(bfm2, sourceImageName);
        if (smallFileName == null) {
            return null;
        }
        resultMap.put("smallImgName", smallFileName);
        resultMap.put("bigImgName", bigImgName);
        resultMap.put("location_y", String.valueOf(this.locationY));
        resultMap.put("sourceImgName", sourceName);
        InputStream sourceInput = UtilFile.byte2Input(imageData);
        String sourcePngBase64 = CaptchaUtil.getBase64FromInputStream(sourceInput);
        this.cacheService.set("captchaImage" + sourceName, (Object)sourcePngBase64, this.picVfCodeExpTime);
        String point = String.valueOf(this.locationX);
        this.cacheService.set("verificationCode" + host, (Object)point, this.picVfCodeExpTime);
        return resultMap;
    }

    private String createSmallImg(BufferedImage resultImgBuff) {
        String smallFileName = this.randomImgName("small_source_");
        InputStream inputStream = CaptchaUtil.getInputStreamFromBufferedImage(resultImgBuff, PNG_SUFFIX);
        if (Objects.isNull(inputStream)) {
            log.warn("\u751f\u6210\u5c0f\u56fe\u5931\u8d25\uff1a\u8f6cinputStream\u6d41\u5931\u8d25\uff01");
            return null;
        }
        String smallPngBase64 = CaptchaUtil.getBase64FromInputStream(inputStream);
        if (UtilString.isEmpty((CharSequence)smallPngBase64)) {
            log.warn("\u751f\u6210\u5c0f\u56fe\u5931\u8d25\uff1a\u8f6cbase64\u7f16\u7801\u5931\u8d25\uff01");
            return null;
        }
        this.cacheService.set("captchaImage" + smallFileName, (Object)smallPngBase64, this.picVfCodeExpTime);
        return smallFileName;
    }

    private String createBigImg(BufferedImage sourceImageBuffer, String sourceName) throws IOException {
        String bigImgName = this.randomImgName("big_source_");
        BufferedImage bigImg = this.addWatermark(sourceName, sourceImageBuffer, 0.6f);
        InputStream inputStream = CaptchaUtil.getInputStreamFromBufferedImage(bigImg, PNG_SUFFIX);
        if (Objects.isNull(inputStream)) {
            log.warn("\u751f\u6210\u5927\u56fe\u5931\u8d25\uff1a\u8f6cinputStream\u6d41\u5931\u8d25\uff01");
            return null;
        }
        String bigPngBase64 = CaptchaUtil.getBase64FromInputStream(inputStream);
        if (UtilString.isEmpty((CharSequence)bigPngBase64)) {
            log.warn("\u751f\u6210\u5927\u56fe\u5931\u8d25\uff1a\u8f6cbase64\u7f16\u7801\u5931\u8d25\uff01");
            return null;
        }
        this.cacheService.set("captchaImage" + bigImgName, (Object)bigPngBase64, this.picVfCodeExpTime);
        return bigImgName;
    }

    private BufferedImage addWatermark(String sourceName, BufferedImage smallImage, float alpha) throws IOException {
        InputStream inputStream = Resources.getResourceAsStream(sourceName);
        BufferedImage source = ImageIO.read(inputStream);
        Graphics2D graphics2D = source.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(10, alpha));
        graphics2D.drawImage((Image)smallImage, this.locationX, this.locationY, null);
        graphics2D.dispose();
        return source;
    }

    private String randomImgName(String suf) {
        return suf + this.locationY + "_" + DigestUtils.md5Hex((String)String.valueOf(this.locationX)).substring(0, 16) + PIC_SUFFIX;
    }

    private List<Shape> createSmallShape() {
        int face2;
        int face1 = RandomUtils.nextInt((int)3);
        while (face1 == (face2 = RandomUtils.nextInt((int)3))) {
        }
        int position1 = RandomUtils.nextInt((int)((this.tailoringHeight - 20) / 2)) + (this.tailoringHeight - 20) / 2;
        Shape shape1 = this.createShape(face1, 0, position1);
        Shape bigshape1 = this.createShape(face1, 2, position1);
        Rectangle2D.Float centre = new Rectangle2D.Float(10.0f, 10.0f, this.tailoringWidth - 20, this.tailoringHeight - 20);
        int position2 = RandomUtils.nextInt((int)((this.tailoringHeight - 20) / 2)) + (this.tailoringHeight - 20) / 2;
        Shape shape2 = this.createShape(face2, 0, position2);
        Shape bigshape2 = this.createShape(face2, 1, position2);
        Rectangle2D.Float bigcentre = new Rectangle2D.Float(9.0f, 9.0f, 32.0f, 32.0f);
        Area area = new Area(centre);
        area.add(new Area(shape1));
        area.add(new Area(shape2));
        Area bigarea = new Area(bigcentre);
        bigarea.add(new Area(bigshape1));
        bigarea.add(new Area(bigshape2));
        ArrayList<Shape> list = new ArrayList<Shape>();
        list.add(area);
        list.add(bigarea);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage tailoringImage(byte[] imageData) throws IOException {
        BufferedImage tailoringImageBuffer;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(PNG_SUFFIX);
        ImageReader render = iterator.next();
        InputStream sourceInputStream = UtilFile.byte2Input(imageData);
        if (Objects.isNull(sourceInputStream)) {
            log.info("\u526a\u88c1\u56fe\u7247\u65f6\u83b7\u53d6\u539f\u56fe\u6587\u4ef6\u6d41\u5f02\u5e38\uff01");
            throw new IOException("\u526a\u88c1\u56fe\u7247\u65f6\u83b7\u53d6\u539f\u56fe\u6587\u4ef6\u6d41\u5f02\u5e38");
        }
        InputStream inputStream = UtilFile.byte2Input(imageData);
        ImageInputStream in = ImageIO.createImageInputStream(inputStream);
        render.setInput(in, true);
        try {
            ImageReadParam param = render.getDefaultReadParam();
            Rectangle rect = new Rectangle(this.locationX, this.locationY, this.tailoringWidth, this.tailoringHeight);
            param.setSourceRegion(rect);
            tailoringImageBuffer = render.read(0, param);
        }
        finally {
            try {
                in.close();
                inputStream.close();
                sourceInputStream.close();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38{}", (Throwable)e);
                e.printStackTrace();
            }
        }
        return tailoringImageBuffer;
    }

    private Shape createShape(int type, int size, int position) {
        Arc2D.Float d = type == 0 ? new Arc2D.Float(position, 5.0f, 10 + size, 10 + size, 0.0f, 190.0f, 1) : (type == 1 ? new Arc2D.Float(35.0f, position, 10 + size, 10 + size, 270.0f, 190.0f, 1) : (type == 2 ? new Arc2D.Float(position, 35.0f, 10 + size, 10 + size, 180.0f, 190.0f, 1) : (type == 3 ? new Arc2D.Float(5.0f, position, 10 + size, 10 + size, 90.0f, 190.0f, 1) : new Arc2D.Float(5.0f, position, 10 + size, 10 + size, 90.0f, 190.0f, 1))));
        return d;
    }

    private BufferedImage dealLightAndShadow(BufferedImage bfm, Shape shape) {
        BufferedImage buffimg = ((Graphics2D)bfm.getGraphics()).getDeviceConfiguration().createCompatibleImage(50, 50, 3);
        Graphics2D graphics2D = buffimg.createGraphics();
        Graphics2D g2 = (Graphics2D)bfm.getGraphics();
        this.paintBorderGlow(g2, 2, shape);
        this.paintBorderShadow(graphics2D, 2, shape);
        graphics2D.drawImage((Image)bfm, 0, 0, null);
        return buffimg;
    }

    private void paintBorderGlow(Graphics2D g2, int glowWidth, Shape clipShape) {
        int gw;
        for (int i = gw = glowWidth * 2; i >= 2; i -= 2) {
            float pct = (float)(gw - i) / (float)(gw - 1);
            Color mixHi = CaptchaUtil.getMixedColor(clrGlowInnerHi, pct, clrGlowOuterHi, 1.0f - pct);
            Color mixLo = CaptchaUtil.getMixedColor(clrGlowInnerLo, pct, clrGlowOuterLo, 1.0f - pct);
            g2.setPaint(new GradientPaint(0.0f, 8.75f, mixHi, 0.0f, 35.0f, mixLo));
            g2.setComposite(AlphaComposite.getInstance(10, pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(clipShape);
        }
    }

    private void paintBorderShadow(Graphics2D g2, int shadowWidth, Shape clipShape) {
        int sw;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = sw = shadowWidth * 2; i >= 2; i -= 2) {
            float pct = (float)(sw - i) / (float)(sw - 1);
            if ((double)pct < 0.3 || (double)pct > 0.8) continue;
            g2.setColor(CaptchaUtil.getMixedColor(new Color(54, 54, 54), pct, Color.WHITE, 1.0f - pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(clipShape);
        }
    }

    private static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        for (int i = 0; i < clr1.length; ++i) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBase64FromInputStream(InputStream inputStream) {
        byte[] data;
        if (Objects.isNull(inputStream)) {
            return null;
        }
        try {
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[100];
            int rc = 0;
            while ((rc = inputStream.read(buffer, 0, 100)) > 0) {
                arrayOutputStream.write(buffer, 0, rc);
            }
            data = arrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u6d41\u8f6cbase64\u7f16\u7801\u5f02\u5e38\uff1a{}", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return new String(Base64.encodeBase64((byte[])data));
    }

    public static InputStream getInputStreamFromBase64Str(String base64Str) {
        if (UtilString.isEmpty((CharSequence)base64Str)) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((String)base64Str);
        if (Objects.isNull(bytes) || bytes.length == 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    private static InputStream getInputStreamFromBufferedImage(BufferedImage bufferedImage, String fileType) {
        if (Objects.isNull(bufferedImage)) {
            log.warn("BufferImage\u8f6cInputStream\u5f02\u5e38\uff1a\u4f20\u5165bufferedImage\u4e3a\u7a7a\uff01");
            return null;
        }
        if (UtilString.isEmpty((CharSequence)fileType)) {
            fileType = PNG_SUFFIX;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, fileType, outputStream);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (IOException e) {
            log.error("BufferImage\u8f6cInputStream\u5f02\u5e38\uff1a{}", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            InputStream asStream = Resources.getResourceAsStream("static/themes/new/img/source/2.png");
            System.out.println(asStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

