/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config.filter;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.security.config.filter.CustomHttpServletRequestWrapper;
import com.ohaotian.plugin.security.utils.AesUtils;
import com.ohaotian.plugin.security.utils.RegexUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.filter.OncePerRequestFilter;

public class CustomFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CustomFilter.class);
    @Value(value="${encrypt.white.list}")
    private String whiteList;

    public static String convertInputStreamToString(InputStream inputStream) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        reader.close();
        return sb.toString();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected void doFilterInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws ServletException, IOException {
        String method = httpRequest.getMethod();
        if ("GET".equals(method)) {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        } else {
            String contentType = httpRequest.getContentType();
            boolean needCheck = true;
            String url = httpRequest.getRequestURI();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.whiteList})) {
                String[] split;
                for (String staticResource : split = this.whiteList.split(";")) {
                    if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                    needCheck = false;
                }
            }
            if (needCheck) {
                if (contentType.startsWith("multipart/form-data")) {
                    HashMap<String, String> decryptedParams = new HashMap<String, String>();
                    Collection parts = httpRequest.getParts();
                    for (Part part : parts) {
                        if (CustomFilter.isBlank(part.getSubmittedFileName())) {
                            String partName = part.getName();
                            String partValue = CustomFilter.convertInputStreamToString(part.getInputStream()).replace("\n", "");
                            decryptedParams.put(partName, AesUtils.decrypt(partValue));
                            continue;
                        }
                        InputStream fileContent = part.getInputStream();
                        decryptedParams.put(part.getName(), CustomFilter.convertInputStreamToString(fileContent));
                    }
                    CustomHttpServletRequestWrapper wrappedRequest = new CustomHttpServletRequestWrapper(httpRequest, decryptedParams);
                    filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)httpResponse);
                }
                if (contentType.startsWith("application/json")) {
                    String originalBody = "";
                    try (BufferedReader reader = httpRequest.getReader();){
                        String line;
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            stringBuilder.append(line);
                        }
                        originalBody = stringBuilder.toString();
                    }
                    JSONObject originalBodyJson = JSONObject.parseObject((String)originalBody);
                    String decryptionStr = originalBodyJson.getString("decryptedParam");
                    originalBodyJson.remove((Object)"decryptedParam");
                    String decryptedParam = AesUtils.decrypt(decryptionStr);
                    if (StringUtils.isNotEmpty((CharSequence)decryptedParam)) {
                        JSONObject jsonObject = JSONObject.parseObject((String)decryptedParam);
                        originalBodyJson.putAll((Map)jsonObject);
                    }
                    String reqJsonString = originalBodyJson.toJSONString();
                    CustomHttpServletRequestWrapper wrappedRequest = new CustomHttpServletRequestWrapper(httpRequest, reqJsonString);
                    filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)httpResponse);
                }
            } else {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readRequestBody(HttpServletRequest request) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        return stringBuilder.toString();
    }

    private Map<String, String> parseRequestBody(String body) {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs = body.split("&")) {
            String[] keyValue = pair.split("=");
            String key = keyValue[0];
            String value = keyValue.length > 1 ? keyValue[1] : "";
            params.put(key, value);
        }
        return params;
    }

    private Map<String, String> decryptParams(Map<String, String> params) {
        HashMap<String, String> decryptedParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String decryptedValue = AesUtils.decrypt(entry.getValue());
            decryptedParams.put(entry.getKey(), decryptedValue);
        }
        return decryptedParams;
    }
}

