/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.ohaotian.plugin.security.jwt.TokenState;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class Jwt {
    private static final Logger logger = LoggerFactory.getLogger(Jwt.class);
    private static byte[] SECRET;
    @Value(value="${app.secret}")
    private String secret;
    private static final JWSHeader header;

    @PostConstruct
    public void init() {
        Assert.notNull((Object)this.secret, (String)"secret is null");
        if (SECRET == null) {
            SECRET = this.secret.getBytes();
        }
    }

    public static void initSecret(String secret) {
        Assert.notNull((Object)secret, (String)"secret is null");
        SECRET = secret.getBytes();
    }

    public static String createToken(Map<String, Object> payload) {
        String tokenString = null;
        JWSObject jwsObject = new JWSObject(header, new Payload(new JSONObject(payload)));
        try {
            jwsObject.sign((JWSSigner)new MACSigner(SECRET));
            tokenString = jwsObject.serialize();
        }
        catch (JOSEException e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
        }
        return tokenString;
    }

    public static Map<String, Object> validToken(String token, Long expTime, String userAgent, String jSessionId, Boolean loginModifyValid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (expTime == null) {
            expTime = 0L;
        }
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            Payload payload = jwsObject.getPayload();
            MACVerifier verifier = new MACVerifier(SECRET);
            if (jwsObject.verify((JWSVerifier)verifier)) {
                SimpleDateFormat sd;
                Date date;
                JSONObject jsonOBj = payload.toJSONObject();
                if (loginModifyValid.booleanValue()) {
                    logger.warn("JSESSIONID=" + jsonOBj.get((Object)"JSESSIONID") + ",jSessionId=" + jSessionId);
                    logger.warn("User-Agent=" + jsonOBj.get((Object)"User-Agent") + ",userAgent=" + userAgent);
                    if (jSessionId != null) {
                        if (!jSessionId.trim().equals(jsonOBj.get((Object)"JSESSIONID"))) {
                            resultMap.put("state", TokenState.MODIFIED.toString());
                            return resultMap;
                        }
                        if (!userAgent.trim().equals(jsonOBj.get((Object)"User-Agent"))) {
                            resultMap.put("state", TokenState.MODIFIED.toString());
                            return resultMap;
                        }
                    }
                }
                resultMap.put("state", TokenState.VALID.toString());
                Long curTime = System.currentTimeMillis();
                logger.debug("\u5f53\u524d\u65f6\u95f4Long:{}", (Object)curTime);
                logger.debug("\u5230\u671f\u65f6\u95f4Long:{}", (Object)expTime);
                if (curTime != null) {
                    date = new Date(curTime);
                    sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    logger.debug("\u5f53\u524d\u65f6\u95f4:{}", (Object)sd.format(date));
                }
                if (expTime != null) {
                    date = new Date(expTime);
                    sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    logger.debug("\u5230\u671f\u65f6\u95f4:{}", (Object)sd.format(date));
                }
                if (curTime > expTime) {
                    resultMap.clear();
                    resultMap.put("state", TokenState.EXPIRED.toString());
                }
                resultMap.put("data", jsonOBj);
            } else {
                resultMap.put("state", TokenState.INVALID.toString());
            }
        }
        catch (Exception e) {
            resultMap.clear();
            resultMap.put("state", TokenState.INVALID.toString());
            logger.error("", (Throwable)e);
        }
        return resultMap;
    }

    static {
        header = new JWSHeader(JWSAlgorithm.HS256, JOSEObjectType.JWT, null, null, null, null, null, null, null, null, null, null, null);
    }
}

