/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.security.config.filter.BusiResponseBody;
import com.ohaotian.plugin.security.config.filter.JsonBusiResponseBody;
import com.ohaotian.plugin.security.utils.AesUtils;
import com.ohaotian.plugin.security.utils.RegexUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class JsonReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonReturnValueHandler.class);
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String SUCCESS = "\u6210\u529f";
    private static final String DATA = "data";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private RequestResponseBodyMethodProcessor target;
    private String whiteList;

    public JsonReturnValueHandler(RequestResponseBodyMethodProcessor target) {
        this.target = target;
    }

    public JsonReturnValueHandler(RequestResponseBodyMethodProcessor target, String whiteList) {
        this.target = target;
        this.whiteList = whiteList;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        Class containingClass = returnType.getContainingClass();
        RestController annotation = containingClass.getAnnotation(RestController.class);
        return returnType.hasMethodAnnotation(JsonBusiResponseBody.class) || returnType.hasMethodAnnotation(ResponseBody.class) || returnType.hasMethodAnnotation(BusiResponseBody.class) || annotation != null;
    }

    public void handleReturnValue(Object obj, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) throws Exception {
        HashMap<String, String> rsp = new HashMap<String, String>(16);
        modelAndViewContainer.setRequestHandled(true);
        HttpServletRequest httpServletRequest = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        String requestURI = httpServletRequest.getRequestURI();
        boolean needCheck = true;
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.whiteList})) {
            String[] split;
            for (String staticResource : split = this.whiteList.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, requestURI)) continue;
                needCheck = false;
            }
        }
        try {
            if (obj instanceof RspPage) {
                if (needCheck) {
                    JSONObject obj1 = JSONObject.parseObject((String)this.objToJsonString(obj));
                    rsp.put(DATA, AesUtils.encrypt(obj1.toString()));
                } else {
                    rsp.put(DATA, this.objToJsonString(obj));
                }
                if (StringUtils.isNotEmpty((String)((RspPage)obj).getCode())) {
                    rsp.put(CODE, ((RspPage)obj).getCode());
                    rsp.put(MESSAGE, ((RspPage)obj).getMessage());
                } else {
                    rsp.put(CODE, ZERO);
                    rsp.put(MESSAGE, SUCCESS);
                }
                this.target.handleReturnValue(rsp, methodParameter, modelAndViewContainer, nativeWebRequest);
            } else if (obj instanceof RspBaseBO) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)this.objToJsonString(obj), LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                JSONObject jsonObject = new JSONObject();
                jsonObject.putAll((Map)linkedHashMap);
                if (jsonObject.size() == 1) {
                    Set keySet = jsonObject.keySet();
                    for (String str : keySet) {
                        Object o = jsonObject.get((Object)str);
                        if (needCheck) {
                            rsp.put(DATA, AesUtils.encrypt(this.objToJsonString(o)));
                            continue;
                        }
                        rsp.put(DATA, this.objToJsonString(o));
                    }
                } else if (needCheck) {
                    rsp.put(DATA, AesUtils.encrypt(jsonObject.toString()));
                } else {
                    rsp.put(DATA, jsonObject.toString());
                }
                if (StringUtils.isNotEmpty((String)((RspBaseBO)obj).getCode())) {
                    rsp.put(CODE, ((RspBaseBO)obj).getCode());
                    rsp.put(MESSAGE, ((RspBaseBO)obj).getMessage());
                } else {
                    rsp.put(CODE, ZERO);
                    rsp.put(MESSAGE, SUCCESS);
                }
                this.target.handleReturnValue(rsp, methodParameter, modelAndViewContainer, nativeWebRequest);
            } else {
                rsp.put(CODE, ZERO);
                rsp.put(MESSAGE, SUCCESS);
                if (obj != null) {
                    if (needCheck) {
                        rsp.put(DATA, AesUtils.encrypt(this.objToJsonString(obj)));
                    } else {
                        rsp.put(DATA, this.objToJsonString(obj));
                    }
                }
                this.target.handleReturnValue(rsp, methodParameter, modelAndViewContainer, nativeWebRequest);
            }
        }
        catch (Exception var13) {
            rsp.put(CODE, ZERO);
            rsp.put(MESSAGE, SUCCESS);
            rsp.put(DATA, this.objToJsonString(obj));
            log.info("\u8f6c\u6362\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u6d88\u606f\u8f6c\u6362");
            this.target.handleReturnValue(obj, methodParameter, modelAndViewContainer, nativeWebRequest);
        }
    }

    private String objToJsonString(Object msg) {
        return JSON.toJSONString((Object)msg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullBooleanAsFalse});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnMsg(Object msg, HttpServletResponse response) {
        try (PrintWriter writer = null;){
            writer = response.getWriter();
            writer.write(this.objToJsonString(msg));
            writer.flush();
        }
    }
}

