/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.aspect.aspectImpl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.IPUtils;
import com.ohaotian.plugin.security.aspect.annotation.OperLog;
import com.ohaotian.plugin.security.aspect.bo.SysOperLog;
import com.ohaotian.plugin.security.aspect.enums.BusinessStatus;
import com.ohaotian.plugin.security.aspect.enums.HttpMethod;
import com.ohaotian.plugin.security.aspect.mq.RabbitMQSender;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import com.ohaotian.plugin.security.utils.ServletUtils;
import com.ohaotian.plugin.security.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private RabbitMQSender rabbitMQSender;

    @Pointcut(value="@annotation(com.ohaotian.plugin.security.aspect.annotation.OperLog)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="logPointCut()", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Object jsonResult) {
        this.handleLog(joinPoint, null, jsonResult);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Exception e, Object jsonResult) {
        try {
            OperLog controllerLog = this.getAnnotationLog(joinPoint);
            if (controllerLog == null) {
                return;
            }
            UserInfo userInfo = SecurityHelper.getCurrentUser();
            String loginUser = userInfo.getUsername();
            log.info("LogAspect\uff1a\u83b7\u53d6\u5f53\u524d\u7684\u7528\u6237:" + loginUser);
            SysOperLog operLog = new SysOperLog();
            operLog.setStatus(BusinessStatus.SUCCESS.ordinal());
            String ip = IPUtils.getIp((HttpServletRequest)ServletUtils.getRequest());
            operLog.setOperIp(ip);
            operLog.setJsonResult(JSON.toJSONString((Object)jsonResult));
            operLog.setOperUrl(ServletUtils.getRequest().getRequestURI());
            if (loginUser != null) {
                operLog.setOperName(loginUser);
            }
            if (e != null) {
                operLog.setStatus(BusinessStatus.FAIL.ordinal());
                operLog.setErrorMsg(StringUtils.substring(e.getMessage(), 0, 2000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            operLog.setMethod(className + "." + methodName + "()");
            operLog.setRequestMethod(ServletUtils.getRequest().getMethod());
            this.getControllerMethodDescription(joinPoint, controllerLog, operLog);
            this.rabbitMQSender.send(JSON.toJSONString((Object)operLog));
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, OperLog log, SysOperLog operLog) throws Exception {
        operLog.setBusinessType(log.businessType().ordinal());
        operLog.setTitle(log.title());
        operLog.setOperatorType(1);
        if (log.isSaveRequestData()) {
            this.setRequestValue(joinPoint, operLog);
        }
    }

    private void setRequestValue(JoinPoint joinPoint, SysOperLog operLog) throws Exception {
        String requestMethod = operLog.getRequestMethod();
        if (HttpMethod.PUT.name().equals(requestMethod) || HttpMethod.POST.name().equals(requestMethod)) {
            String params = this.argsArrayToString(joinPoint.getArgs());
            operLog.setOperParam(StringUtils.substring(params, 0, 2000));
        } else {
            Map paramsMap = (Map)ServletUtils.getRequest().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            operLog.setOperParam(StringUtils.substring(paramsMap.toString(), 0, 2000));
        }
    }

    private OperLog getAnnotationLog(JoinPoint joinPoint) throws Exception {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(OperLog.class);
        }
        return null;
    }

    private String argsArrayToString(Object[] paramsArray) {
        String params = "";
        if (paramsArray != null && paramsArray.length > 0) {
            for (int i = 0; i < paramsArray.length; ++i) {
                if (this.isFilterObject(paramsArray[i])) continue;
                Object jsonObj = JSON.toJSON((Object)paramsArray[i]);
                params = params + jsonObj.toString() + " ";
            }
        }
        return params.trim();
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iter;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iter2 = collection.iterator();
            if (iter2.hasNext()) {
                return iter2.next() instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iter = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry entry = iter.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }
}

