/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.config.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StringUtils;

public class CustomHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final String modifiedBody;
    private final Map<String, String> decryptedParams;

    public CustomHttpServletRequestWrapper(HttpServletRequest request, String modifiedBody) {
        super(request);
        this.decryptedParams = new HashMap<String, String>();
        this.modifiedBody = !StringUtils.hasText((String)modifiedBody) ? "" : modifiedBody;
    }

    public CustomHttpServletRequestWrapper(HttpServletRequest request, Map<String, String> decryptedParams) {
        super(request);
        this.modifiedBody = "";
        this.decryptedParams = decryptedParams;
    }

    public BufferedReader getReader() throws IOException {
        if (StringUtils.hasText((String)this.modifiedBody)) {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
        }
        return super.getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (StringUtils.hasText((String)this.modifiedBody)) {
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.modifiedBody.getBytes());
            return new ServletInputStream(){

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }

                public boolean isFinished() {
                    return byteArrayInputStream.available() == 0;
                }

                public boolean isReady() {
                    return true;
                }

                public void setReadListener(ReadListener readListener) {
                }
            };
        }
        return super.getInputStream();
    }

    public String getParameter(String name) {
        return this.decryptedParams.getOrDefault(name, null);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.decryptedParams.keySet());
    }

    public String[] getParameterValues(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.decryptedParams.entrySet()) {
            if (!entry.getKey().equals(name)) continue;
            values.add(entry.getValue());
        }
        return values.toArray(new String[0]);
    }
}

