/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.log;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.HttpKit;
import com.ohaotian.authority.log.IPUtils;
import com.ohaotian.authority.log.LogManager;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.log.LogTaskFactory;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAop {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.ohaotian.authority.log.BussinessLog)")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object recordSysLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        try {
            this.handle(point);
        }
        catch (Exception e) {
            this.log.error("\u65e5\u5fd7\u8bb0\u5f55\u51fa\u9519!", (Throwable)e);
        }
        return result;
    }

    private void handle(ProceedingJoinPoint point) throws Exception {
        Signature sig = point.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        msig = (MethodSignature)sig;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        UserInfo user = SecurityHelper.getCurrentUser();
        if (null == user) {
            return;
        }
        String className = point.getTarget().getClass().getName();
        Object[] params = point.getArgs();
        BussinessLog annotation = currentMethod.getAnnotation(BussinessLog.class);
        String bussinessName = annotation.operat();
        String key = annotation.key();
        String module = annotation.module();
        HttpServletRequest request = HttpKit.getRequest();
        String ip = IPUtils.getIp(request);
        StringBuilder sb = new StringBuilder();
        for (Object param : params) {
            sb.append(param);
            sb.append(" & ");
        }
        String preData = null;
        Object obj = LogObjectHolder.me().get();
        if (obj != null) {
            preData = JSON.toJSONString((Object)obj);
        }
        Map<String, String> parameters = HttpKit.getRequestParameters();
        String parametersJson = JSON.toJSONString(parameters);
        LogManager.me().executeLog(LogTaskFactory.bussinessLog(user.getUserId(), user.getTenantId(), module, bussinessName, className, ip, preData, parametersJson));
    }
}

