/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.security.controller;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.menu.service.SelectAccessMenuService;
import com.ohaotian.authority.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.authority.role.service.SelectRoleAuthoritysService;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.IPUtils;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.jwt.Jwt;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionsController {
    private Logger logger = LoggerFactory.getLogger(PermissionsController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectAccessMenuService selectAccessMenuService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP")
    private SelectUserInfoService selectUserInfoService;
    @Autowired
    private CacheClient cacheClient;

    @RequestMapping(value={"/auth/getUserMenus"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserMenus(@RequestParam(required=false) String appCode) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashMap map = new HashMap();
            this.logger.debug("getUserMenus" + appCode);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appCode})) {
                Map menus = user.getMenus();
                SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
                selectByApplicationCodeReqBO.setApplicationCode(appCode);
                SelectByApplicationCodeRspBO application = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
                map.put("menus", menus.get(appCode));
                if (application != null) {
                    map.put("appName", application.getApplicationBO().getApplicationName());
                }
            } else {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setUserId(user.getUserId());
                applicationByUserReqBO.setOrgPath(user.getOrgPath());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                if (applicationBOS != null && applicationBOS.size() > 0) {
                    ApplicationBO applicationBO = (ApplicationBO)applicationBOS.get(0);
                    map.put("appName", applicationBO.getApplicationName());
                    map.put("isExt", applicationBO.getIsExt());
                    appCode = applicationBO.getApplicationCode();
                    Map menus = user.getMenus();
                    map.put("menus", menus.get(appCode));
                }
            }
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/havePerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object havePerms(@RequestParam String[] authority) {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String auth : authority) {
                map.put(auth, user.hasAuthority(auth));
            }
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserPerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserPerms() {
        UserInfo user = SecurityHelper.getCurrentUser();
        if (user != null) {
            HashSet permission = new HashSet();
            user.getPermission().forEach(perm -> permission.add(perm.getKey()));
            return permission;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, String> resMap = new HashMap<String, String>();
            String userId = String.valueOf(userInfo.getUserId());
            resMap.put("userId", userId);
            resMap.put("userName", userInfo.getUsername());
            resMap.put("orgName", userInfo.getOrgName());
            resMap.put("name", userInfo.getName());
            rspMapInfoBO.setData(resMap);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    @RequestMapping(value={"/auth/getFullUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getFullUserInfo() {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo != null) {
            return userInfo;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    @RequestMapping(value={"/api/token/get"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getToken(@RequestParam(required=false) String loginName, @RequestParam(required=false) String passWord, @RequestParam(required=false) Long userId, String appCode) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Date date = new Date();
        UserInfo userInfo = new UserInfo();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{passWord})) {
            SelectUserByLoginNameReqBO selectUserByLoginNameReqBO = new SelectUserByLoginNameReqBO();
            selectUserByLoginNameReqBO.setUsername(loginName);
            selectUserByLoginNameReqBO.setPassword(passWord);
            selectUserByLoginNameReqBO.setType(null);
            SelectUserByLoginNameRspBO rspUser = this.selectUserByLoginNameService.selectUserByLoginNameService(selectUserByLoginNameReqBO);
            if (rspUser != null) {
                payload.put("userId", rspUser.getUserId());
                userInfo.setUserId(rspUser.getUserId());
                userInfo.setName(rspUser.getName());
                userInfo.setUsername(rspUser.getLoginName());
                userInfo.setOrgId(rspUser.getOrgId());
                userInfo.setCellphone(rspUser.getCellPhone());
            }
        } else if (userId != null && userId != 0L) {
            payload.put("userId", userId);
        } else {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
            payload.put("appCode", appCode);
        }
        payload.put("iat", date.getTime());
        payload.put("ext", date.getTime() + 0x6DDD00L);
        String token = Jwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("token", token);
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/users/signup/token/get"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getIToken(HttpServletRequest request, @RequestParam(required=false) String loginName, @RequestParam(required=false) String passWord, @RequestParam(required=false) Long userId, String appCode, @RequestParam(required=false) String vfCode) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Date date = new Date();
        UserInfo userInfo = new UserInfo();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{passWord})) {
            if (StringUtils.isBlank((CharSequence)vfCode)) {
                throw new ZTBusinessException("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            }
            String ip = IPUtils.getIp((HttpServletRequest)request);
            if (StringUtils.isBlank((CharSequence)ip)) {
                throw new ZTBusinessException("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            }
            Object obj = this.cacheClient.get(ip);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ip:{}", (Object)ip);
            }
            if (null == obj) {
                throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            Object objCode = this.cacheClient.get(String.valueOf(obj) + "_" + ip);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("key:{}", (Object)(String.valueOf(obj) + "_" + ip));
            }
            if (null == objCode) {
                throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u5931\u6548");
            }
            this.cacheClient.delete(ip);
            this.cacheClient.delete(String.valueOf(obj) + "_" + ip);
            SelectUserByLoginNameReqBO selectUserByLoginNameReqBO = new SelectUserByLoginNameReqBO();
            selectUserByLoginNameReqBO.setUsername(loginName);
            selectUserByLoginNameReqBO.setPassword(passWord);
            selectUserByLoginNameReqBO.setType(null);
            SelectUserByLoginNameRspBO rspUser = this.selectUserByLoginNameService.selectUserByLoginNameService(selectUserByLoginNameReqBO);
            if (rspUser == null) throw new ZTBusinessException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef");
            if (null == rspUser.getUserId()) {
                throw new ZTBusinessException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef");
            }
            payload.put("userId", rspUser.getUserId());
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getName());
            userInfo.setUsername(rspUser.getLoginName());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setCellphone(rspUser.getCellPhone());
        } else {
            if (userId == null || userId == 0L) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            payload.put("userId", userId);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
            payload.put("appCode", appCode);
        }
        payload.put("iat", date.getTime());
        payload.put("ext", date.getTime() + 0x6DDD00L);
        String token = Jwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("token", token);
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }
}

