/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.security.controller;

import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.menu.bo.SelectAccessMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAccessMenuRspBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuReqBO;
import com.ohaotian.authority.menu.bo.SelectAuthoritysMenuRspBO;
import com.ohaotian.authority.menu.service.SelectAccessMenuService;
import com.ohaotian.authority.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysReqBO;
import com.ohaotian.authority.role.bo.SelectRoleAuthoritysRspBO;
import com.ohaotian.authority.role.service.SelectRoleAuthoritysService;
import com.ohaotian.authority.security.CustomUserDetailsService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.cache.CacheTemplate;
import com.ohaotian.plugin.common.util.ListUtils;
import com.ohaotian.plugin.security.entity.AuthorityInfo;
import com.ohaotian.plugin.security.entity.MenuInfo;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.filter.TokenAuthenticationFilter;
import com.ohaotian.plugin.security.service.GetUserInfoByUserIdService;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
@Order(value=9999)
public class GetUserInfoByUserIdServiceImpl
implements GetUserInfoByUserIdService {
    @Autowired
    private CustomUserDetailsService userDetailsService;
    @Autowired
    private TokenAuthenticationFilter tokenAuthenticationFilter;
    @Autowired
    private SelectUserInfoService selectUserInfoService;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;
    @Autowired
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Autowired
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @Autowired
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Autowired
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Autowired
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @Autowired
    private SelectAccessMenuService selectAccessMenuService;
    private CacheTemplate cacheTemplate = CacheTemplate.getIstance();

    @PostConstruct
    private void init() {
        this.tokenAuthenticationFilter.setGetUserInfoByTokenService((GetUserInfoByUserIdService)this);
    }

    public UserDetails getUserInfoByUserId(Long userId, String token, String appCode) {
        Object o = this.cacheTemplate.get(token);
        if (o != null) {
            return (UserDetails)o;
        }
        UserInfo userInfo = this.loadUserInfo(userId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
            try {
                this.loadUserMenus(userInfo, appCode);
                this.loadUserAuthoritys(userInfo, appCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cacheTemplate.set(token, (Object)userInfo);
        return userInfo;
    }

    private UserInfo loadUserInfo(Long userId) {
        UserInfo userInfo = new UserInfo();
        SelectUserInfoReqBO userInfoReqBO = new SelectUserInfoReqBO();
        userInfoReqBO.setUserId(userId);
        SelectUserInfoRspBO rspUser = this.selectUserInfoService.selectUserInfo(userInfoReqBO);
        if (rspUser != null) {
            userInfo.setUserId(rspUser.getUserId());
            userInfo.setName(rspUser.getName());
            userInfo.setUsername(rspUser.getLoginName());
            userInfo.setOrgId(rspUser.getOrgId());
            userInfo.setCellphone(rspUser.getCellPhone());
            if (rspUser.getTenantId() != null) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(rspUser.getTenantId());
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                userInfo.setTenantId(tenantRspBO.getTenantId());
                userInfo.setTenantName(tenantRspBO.getTenantName());
            }
            if (userInfo.getOrgId() != null) {
                OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
                organisationIdReqBO.setOrganisationId(userInfo.getOrgId());
                RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
                if (organisationBO != null) {
                    userInfo.setOrgPath(organisationBO.getOrgTreePath());
                    userInfo.setOrgName(organisationBO.getTitle());
                }
            }
        }
        return userInfo;
    }

    private void loadUserMenus(UserInfo userInfo, String appCode) throws Exception {
        SelectAccessMenuReqBO menuReqBO = new SelectAccessMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        menuReqBO.setApplicationCode(appCode);
        SelectAccessMenuRspBO menuRspBO = this.selectAccessMenuService.selectAccessMenuService(menuReqBO);
        List menuList = menuRspBO.getAccessMenuList();
        if (menuList != null && menuList.size() > 0) {
            List unMenuInfos = ListUtils.copyListProperties((List)menuList, MenuInfo.class);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appCode})) {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setOrgPath(userInfo.getOrgPath());
                applicationByUserReqBO.setUserId(userInfo.getUserId());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                applicationBOS.forEach(a -> {
                    if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{a.getApplicationCode()}) && a.getApplicationCode().equals(appCode) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getUrl()})) {
                        MenuInfo m = new MenuInfo();
                        m.setUrl(a.getUrl());
                        unMenuInfos.add(m);
                    }
                });
            }
            MenuInfo m = new MenuInfo();
            m.setUrl("/index.html");
            unMenuInfos.add(m);
            MenuInfo m1 = new MenuInfo();
            m1.setUrl("/rest/**");
            unMenuInfos.add(m1);
            userInfo.setUnstructuredMunes(unMenuInfos);
        }
    }

    private void loadUserAuthoritys(UserInfo userInfo, String appCode) {
        HashSet authorities = new HashSet();
        SelectAuthoritysMenuReqBO menuReqBO = new SelectAuthoritysMenuReqBO();
        menuReqBO.setUserId(userInfo.getUserId());
        menuReqBO.setApplicationCode(appCode);
        menuReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectAuthoritysMenuRspBO authoritysMenuRspBO = this.selectAuthoritysMenuService.selectAuthoritysMenuService(menuReqBO);
        List authorityMenuList = authoritysMenuRspBO.getAuthorityMenuList();
        if (authorityMenuList != null && authorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)authorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
        }
        SelectRoleAuthoritysReqBO roleAuthoritysReqBO = new SelectRoleAuthoritysReqBO();
        roleAuthoritysReqBO.setUserId(userInfo.getUserId());
        roleAuthoritysReqBO.setOrgTreePath(userInfo.getOrgPath());
        SelectRoleAuthoritysRspBO roleAuthoritysRspBO = this.selectRoleAuthoritysService.selectRoleAuthoritysService(roleAuthoritysReqBO);
        List roleAuthoritysRspBOAuthorityMenuList = roleAuthoritysRspBO.getAuthorityMenuList();
        if (roleAuthoritysRspBOAuthorityMenuList != null && roleAuthoritysRspBOAuthorityMenuList.size() > 0) {
            List authorityInfos = ListUtils.copyListProperties((List)roleAuthoritysRspBOAuthorityMenuList, AuthorityInfo.class);
            authorities.addAll(authorityInfos);
        }
        userInfo.setPermission(authorities);
    }
}

